﻿(function (aGbl) {
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    function mCreateUI(aObj) {
        var mPorW = (aObj instanceof Panel) ? aObj : new Window("palette", "Symmetrika", undefined);
        mPorW.preferredSize = [200, 100];
        mPorW.margins = [10, 10, 10, 10];
        mPorW.spacing = 10;
        mPorW.orientation = "row";

        mPorW.mGpBts = mPorW.add("group { orientation : 'column' , alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0]}");
        mPorW.mGpBts.spacing = 0;
        mPorW.mBtX = mPorW.mGpBts.add("button { preferredSize : [60‬,20] , text : 'X' }");
        mPorW.mBtY = mPorW.mGpBts.add("button { preferredSize : [60‬,20]  , text : 'Y' }");
        mPorW.mBtXY = mPorW.mGpBts.add("button { preferredSize : [60‬,20]  , text : 'XY' }");

        mPorW.add("panel { preferredSize : [0,-1] ,alignment :  [ 'left','fill' ]}");

        mPorW.mGpOpts = mPorW.add("group { orientation : 'column' , alignment :  [ 'fill','top' ] , margins : [0, 0, 0, 0]}");
        mPorW.mGpOpts.spacing = 0;
        mPorW.mGpTxts = mPorW.mGpOpts.add("group { alignment :  [ 'fill','top' ] , margins : [0, 0, 0, 0]}");
        mPorW.mGpTxts.spacing = 0;
        mPorW.mStLine = mPorW.mGpTxts.add("statictext { preferredSize : [-1,20] , text : 'Axis :', alignment :  [ 'left','top' ]}");
        mPorW.mStCt = mPorW.mGpTxts.add("statictext { preferredSize : [-1,20], text : 'This Comp' , alignment :  [ 'left','top' ]}");
        mPorW.mBtCt = mPorW.mGpOpts.add("button { preferredSize : [60‬,20] , text : 'PickUp' ,alignment :  [ 'left','top' ]}");

        return mPorW;
    }

    //mPnlという名でメインウインドウを作成。
    var mPnl = mCreateUI(aGbl);
    if (mPnl instanceof Window) {
        mPnl.center();
        mPnl.show();
    } else if (mPnl instanceof Panel) {
        //UIパネルの場合は以下をしないと自動レイアウトされない。
        mPnl.layout.layout(true);
    }

    //--------------------------------------------------------------------------------------------------------------------------------------------------
    mPnl.mBtCt.onClick = function () {
        var mAi = app.project.activeItem;
        var mSls = mAi.selectedLayers;

        if (mSls.length === 0) {
            mPnl.mStCt.text = "This Comp";
        } else {
            mPnl.mStCt.text = "Layer " + mSls[0].index;
        }
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    mPnl.mBtX.onClick = function () { mApplyPos(0); }
    mPnl.mBtY.onClick = function () { mApplyPos(1); }
    mPnl.mBtXY.onClick = function () { mApplyPos(2); }

    function mApplyPos(aXorNot) {
        var mAi = app.project.activeItem;
        var mSls = mAi.selectedLayers;
        var mCtlLyr = mAi.selectedLayers[0];
        var mSlsForDel = mAi.selectedLayers;
        var mSlF = mSls[0];
        var mSlL = mSls[1];
        //-------------------------------------------------------------------------
        app.beginUndoGroup("Symmetrika");

        //選択レイヤーゼロにポイント制御を付ける。
        mSetPointCtlToSelLyrZero(mCtlLyr);

        try {
            //まずは中心のPtを出す。
            //コンポの場合。
            if (mPnl.mStCt.text === "This Comp") {
                var mCtpt = [mAi.width / 2, mAi.height / 2];
                //レイヤーの場合。
            } else {
                //0~9以外の文字を空白にしたものを整数にして、インデックスを得る。
                var mIdx = parseInt(mPnl.mStCt.text.replace(/[^0-9]/g, ''));
                var mSl0 = mAi.layers[mIdx];
                //親子対策でコンポ位置を得る。
                var mCtpt = mGetCompPos(mSl0, mCtlLyr);
            }
            //-------------------------------------------------------------------------
            //目標位置は、中心点から基準位置へのベクトルを逆にして、その原点を中心位置にすればよい。
            var mStdPt = mGetCompPos(mSlF, mCtlLyr);
            var mVec = mStdPt - mCtpt;
            var mTgtRstPt = (mVec * -1) + mCtpt;

            //XY一緒に処理したので、XYどちらかだけの場合は、もう一方の値を基準位置と一緒にする。
            if (aXorNot === 0) { mTgtRstPt = [mTgtRstPt[0], mStdPt[1]]; }
            else if (aXorNot === 1) { mTgtRstPt = [mStdPt[0], mTgtRstPt[1]]; }

            //適用するレイヤーに親があれば、位置Pptyは親レイヤー座標となっているので、それに変換する。
            if (mSlL.parent !== null) {
                mTgtRstPt = mGetLyrCoordFromCompPos(mTgtRstPt, mSlL.parent, mCtlLyr);
            }

            //キーフレームのありなし、次元分割の有無を考慮してsetValueする。
            mSetPosVal(mSlL.position, mTgtRstPt, mAi.time);

            //ポイント制御エフェクトを消す。
            mDelPointCtlToSelLyrZero(mCtlLyr, mSlsForDel);

        } catch (e) {
            //なんらかのエラーが出た場合はポイント制御エフェクトだけ消しておく。
            mDelPointCtlToSelLyrZero(mCtlLyr, mSlsForDel);
        }

        app.endUndoGroup();
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //キーフレームのありなし、次元分割の有無を考慮したPosition用setValue関数。
    function mSetPosVal(aPosPpty, aVal, aTime) {
        //次元分割されていない場合。
        if (aPosPpty.dimensionsSeparated === false) {
            //キーフレームがあれば追加する。
            if (aPosPpty.isTimeVarying == true) {
                aPosPpty.setValueAtTime(aTime, aVal);
                //なければキーフレ無しの値を入れる。
            } else {
                aPosPpty.setValue(aVal);
            }
            //次元分割されている場合。
        } else {
            var mXPpty = aPosPpty.getSeparationFollower(0);
            var mYPpty = aPosPpty.getSeparationFollower(1);

            //XYそれぞれについて、キーフレームがあれば追加する。
            if (mXPpty.isTimeVarying == true) {
                mXPpty.setValueAtTime(aTime, aVal[0]);
                //なければキーフレ無しの値を入れる。    
            } else {
                mXPpty.setValue(aVal[0]);
            }
            if (mYPpty.isTimeVarying == true) {
                mYPpty.setValueAtTime(aTime, aVal[1]);
            } else {
                mYPpty.setValue(aVal[1]);
            }
        }
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //コンポ座標やレイヤー座標を得るための仮ポイント制御エフェクトを任意のレイヤーに付ける関数。
    //以下のコンポ座標やレイヤー座標変換関数は、そのレイヤーに以下の名のポイント制御があることを前提に動く。
    function mSetPointCtlToSelLyrZero(aCtlLyr) {
        var mPtCtl = aCtlLyr.effect.addProperty("ADBE Point Control");
        mPtCtl.name = "PtCtlForGetCmpAndLyrPos";
    }

    //仮ポイント制御エフェクトを消す関数。
    //なんらかのプロパティが選択されていた場合、すべてのレイヤーの選択が外れるので
    //操作するmSlsとは別に選択レイヤー群をとっておき、それらを再選択する。
    //任意のポイント制御付きレイヤーのなんらかのプロパティが選択されていたら、そのプロパティは選択が外れることに注意する。
    function mDelPointCtlToSelLyrZero(aCtlLyr, aSlsForDel) {
        var mSelLyrs = aSlsForDel;
        aCtlLyr.effect("PtCtlForGetCmpAndLyrPos").remove();
        for (var i = 0; i < mSelLyrs.length; i++) {
            mSelLyrs[i].selected = true;
        }
    }

    //aLyrのコンポ座標を得る。
    function mGetCompPos(aLyr, aCtlLyr) {
        var mPtCtl = aCtlLyr.effect("PtCtlForGetCmpAndLyrPos");
        //エクスプレッションでコンポ座標を得る。
        mPtCtl("ADBE Point Control-0001").expression
            = "thisComp.layer(" + aLyr.index + ").toComp( thisComp.layer(" + aLyr.index + ").anchorPoint );"
        //変数に値を入れる。
        var mRstPt = mPtCtl("ADBE Point Control-0001").value;

        //値をリターンする。
        return mRstPt;
    }
    //コンポ座標aCoordをaLyr上でのレイヤー座標に変換する。
    function mGetLyrCoordFromCompPos(aCoord, aLyr, aCtlLyr) {
        var mPtCtl = aCtlLyr.effect("PtCtlForGetCmpAndLyrPos");
        //エクスプレッションでレイヤー座標を得る。
        var mCoordStr = "[" + aCoord.join(",") + "]";
        mPtCtl("ADBE Point Control-0001").expression
            = "thisComp.layer(" + aLyr.index + ").fromComp( " + mCoordStr + ");"
        //変数に値を入れる。
        var mRstPt = mPtCtl("ADBE Point Control-0001").value;

        //値をリターンする。
        return mRstPt;
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
}(this));


