﻿(function (aGbl) {
    //グローバル的なLRチェック。
    var mTopObj ={};
    mTopObj.mIsL = false;
    //あれば設定を読み込んで上書きする。
    if (app.settings.haveSetting("SpookieSide", "mRbL")) {
        mTopObj.mIsL = (app.settings.getSetting("SpookieSide", "mRbL") === "true");
    }
    //----------------------------------------------------------------------------------------------------------------------
    //カーソル位置取得用ウインドウを作る関数。
    function mMakeCursorChkWdw() {
        //大きさは仮で、上部分の帯を無くし、透明度を最小にして出現させる。
        var mWdw = new Window("palette", "SpookieSideBar", [0, 0, 100, 100], { borderless: true });
        mWdw.opacity = 0.01;
        mWdw.show();
        
        //スクリーンを取得。
        //１画面対応なので配列のゼロ番目だけでよい。
        var mScreen = $.screens[0];
        
        //AEスクリプトではデフォルトでウインドウの最大サイズ上限がある。
        //（AEのメニューや×ボタンを隠してしまい操作不能になるのを防ぐため？）
        //位置取得範囲を全面にしたいので、上限を無くす。
        //まずは最大サイズをスクリーンサイズまで上げる。
        mWdw.maximumSize = [mScreen.right, mScreen.bottom];
        //それから実際にサイズを大きくする。
        mWdw.bounds = [mScreen.right - 1, mScreen.top, mScreen.right, mScreen.bottom];

        //ウインドウ自体にはカーソル感知領域がないので、同サイズのパネルをウインドウ内に作る。
        mWdw.mP1 = mWdw.add("panel", [0, 0, 100, 100]);
        mWdw.mP1.maximumSize = [mScreen.right, mScreen.bottom];
        mWdw.mP1.bounds = [0, mScreen.top, mScreen.right + 1, mScreen.bottom];

        //イベントリスナーでカーソル感知機能と、検知後の操作を付ける。
        mWdw.addEventListener("mouseover", mApr);
        
        //もしもLチェックがあれば左に移動させる。
        if(mTopObj.mIsL){ mWdw.location = [0,0];}

        //後でこのウインドウ内のプロパティを使うので、戻り値をウインドウ自体にする。
        return mWdw;
    }
    //----------------------------------------------------------------------------------------------------------------------
    //画面横にカーソル判定ウインドウを出す。
    mMakeCursorChkWdw();

    //画面右にカーソルが当たると、即、以下の検知後関数が実行される。
    //----------------------------------------------------------------------------------------------------------------------
    //----------------------------------------------------------------------------------------------------------------------
    //カーソル感知後の処理用関数。
    //イベントリスナーの引数として使うので、eでマウス情報が得られる。
    function mApr(e) {
        //メイン部分をTryしてエラーが出たらアラートを出す。
        //mAprMain();
        try {
            mAprMain(e);
        } catch (err) {
            alert(err.message + "\n" + err.line);
            //+"\n" +err.fileName
        }
        //-------------------------------------------------------------------------
        function mAprMain(e) {
            var mScreen = $.screens[0];
            
            //マウスドラッグで領域にインした場合はリターンする。
            var mDrgBtn = e.button;
            if(mDrgBtn === 0 || mDrgBtn === 1 || mDrgBtn === 2 ){return;}  
                
           //TLチェックがあれば、ビューワーが見えていない場合もリターンする。
           var mDntOpnTLOnly = false;
            if (app.settings.haveSetting("SpookieSide", "mCbTL")) {
                mDntOpnTLOnly = (app.settings.getSetting("SpookieSide", "mCbTL") === "true");
            }
            if( mDntOpnTLOnly && app.activeViewer === null){return;}  
  
            //Ctrl（あるいはWindowOrCommand）を押しながらインした場合はセッティングウインドウを出す。
            if(e.ctrlKey || e.metaKey){mMakeSettingWdw();return;}  

            //カーソル座標を取得。
            var mCoord = [e.screenX, e.screenY];

            //出現させるスクリプトがあるフォルダを取得。
            var mPath = new File($.fileName);
            var mPath = mPath.parent.fullName + "/(forSpookieSide)";
            
            //フォルダ内のファイルからjsxを探す。
            var mFiles = new Folder(mPath).getFiles();
            var mFile = null;
            var mRegix = new RegExp(".*\\.jsx.*$");
            for (var i = 0; i < mFiles.length; i++) {
                var mFileTp = mFiles[i];
                if (mFileTp instanceof File && mRegix.test(mFileTp.name)) {
                    mFile = mFileTp;
                    break;
                }
            }
            if (mFile === null) { return };

            //スクリプトを実行。だいたいのスクリプトは真ん中に出現する。
            $.evalFile(mFile.fullName);

            //開いたウインドウを得る。
            var mCld =Window.children[Window.children.length - 1];
            
            //同スクリプトウインドウを多数出現させないため、直前に開いたもの以外の、同名の開いているスクリプトは消す。
            mRemoveScr(mCld.text);
            
            //出現させたスクリプトを移動する。右端に出現の場合、Xは出現スクリプトの横幅を引いた値にする。そしてちょっと空ける。
            //Xはロケーションでよいが、Yはウインドウバー分があるのでフレームロケーションで規定する。
            //また、Yが画面下すぎる場合ははみ出た分上げる。
            var mGap = 10;
            if( mTopObj.mIsL ){ mCld.location[0] = mCoord[0] + mGap;}
            else{ mCld.location[0] = mCoord[0] - mCld.bounds.width - mGap;}
            
            var mScrUnderPtY = mCoord[1] + mCld.frameBounds.height;
            if( mScrUnderPtY > mScreen.bottom ){ mCld.location[1] = mScreen.bottom - mCld.bounds.height;}
            else{ mCld.frameLocation[1] = mCoord[1];}

            //付属のスクリプトは移動が目立たないように不透明度を下げているので、上げる。
            //元々上がっているものに指し変わっても、上げる分には問題ない。
            mCld.opacity = 1;
            
        }
    }
    //----------------------------------------------------------------------------------------------------------------------
    //----------------------------------------------------------------------------------------------------------------------
    //フォルダパスからファイルObjを再帰処理で得る関数。
    //ファイルObjのプロパティは以下。
    //fsName　フルパス＆ファイル名。
    //path　フルパス。
    //name　ファイル名。
    function mGetFile(aPth) {
        var mRst = null;
        var mStopOrNot = false;
        var mStdTime = Date.now();

        mExecute(aPth);

        //取得処理が終わり、mStopOrNotがtrueになっていれば１秒タイムアウトなのでnullを返す。
        if (mStopOrNot === true) { return null; }
        return mRst;

        //ファイルObj取得関数。再帰処理で()付き以外のサブフォルダも探す。
        function mExecute(aPth) {
            //もしも指定ミリ秒を超えたら、ストップorNotチェックをtrueにして、リターンする。
            if (mTimeOut(mStdTime, 100)) {
                mStopOrNot = true;
                return;
            }
            //getFiles()で得られるものはフルパス名ではなくファイルObj。
            var mFls = new Folder(aPth).getFiles();
            //正規表現（カッコでくくられた文字列）。
            var mExt = ".*\\(.*\\)$";
            //正規表現（jsxを含む）。
            var mExtJsx = ".*\\.jsx.*$";
            for (var i = 0; i < mFls.length; i++) {
                //もしもフルパス先がフォルダ、かつ名前にカッコがなければ、再帰処理でmExecuteを行う。
                if (mFls[i] instanceof Folder
                    && RegExp(mExt).test(mFls[i].name) === false ) {
                    mExecute(mFls[i]);
                    //ファイルの形式が『ファイル』で、『.jsx』が含まれるならば変数に代入する。
                } else {
                    if (mFls[i] instanceof File === true
                        && RegExp(mExtJsx).test(mFls[i].name) === true) {
                        mRst = mFls[i];
                        break;
                    }
                }
            }
        }

        //使用関数。
        //タイムアウト関数。もしも経過時間（ 現在時間 - 引数の基準時間 )が指定ミリ秒を超えたらtrueを返す。
        function mTimeOut(aStdTime, aMilliSec) {
            var mNowTime = Date.now();
            if (mNowTime - aStdTime > aMilliSec) {return true;}
            else{ return false;}
                
        }
    }
    //----------------------------------------------------------------------------------------------------------------------
    //画面上にあるスクリプトを名前指定で消す関数。
    //最後のものは直前に開いたものなので対象外にする。
    //都度消すので、同じものは１枚しかないという想定で、後ろから調べてあったら消してreturnする。
    function mRemoveScr(aName){
        var mClds = Window.children;
        for( var i = mClds.length-2; i >= 0; i-- ){
            var mCld = mClds[i];
            //パネルスクリプトをパネル群から消した後に参照すると、それが『無効』でエラーとなるのでTryする。
            //Tryの中身はエラーが起こればなんでもいいのでnullと比較する。
            try{ mCld === null }
            catch(e){ continue;}
            if( mCld instanceof Window
            && mCld.text === aName
            && mCld.visible){
                mCld.close();
                return;
            }
        }
    }
    //----------------------------------------------------------------------------------------------------------------------
    //名前が一致するもの全てを消す関数。サイドウインドウを消すときに使う。
    function mRemoveAllNameScr(aName){
        var mClds = Window.children;
        for( var i = mClds.length-1; i >= 0; i-- ){
            var mCld = mClds[i];
            if( mCld instanceof Window
            && mCld.text === aName
            && mCld.visible){
                mCld.close();
            }
        }
    }

    //----------------------------------------------------------------------------------------------------------------------
    //セッティングウインドウ出現関数。
    function mMakeSettingWdw() {
        var mWdw = new Window("palette", "SpookieSideSettings", undefined, { resizeable: true });
        mWdw.preferredSize = [240, 100];
        mWdw.margins = [5, 5, 5, 5];
        mWdw.spacing = 0;
        mWdw.onResizing = mWdw.onResize = function () { this.layout.resize(); }

        mWdw.mPlMain = mWdw.add("panel { alignment :  [ 'fill','fill' ] , margins : [5, 5, 5, 5] , spacing : 10}");
        mWdw.mGpLR = mWdw.mPlMain.add("group { alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0] , spacing : 0}");
        mWdw.mRbL = mWdw.mGpLR.add("radiobutton {preferredSize : [60, 20], alignment :  [ 'left','top' ] , text:'L'}");
        mWdw.mRbR = mWdw.mGpLR.add("radiobutton {preferredSize : [60, 20], alignment :  [ 'left','top' ] , text:'R'}");
        mWdw.mRbL.value = false;
        mWdw.mRbR.value = true;
        
        mWdw.mCbTL = mWdw.mPlMain.add("checkbox {preferredSize : [-1, 20], alignment :  [ 'left','top' ] , text:''}");
        mWdw.mCbTL.text = "Don\'t open when in timeline-only mode";
        mWdw.mCbTL.value = true;

        mWdw.mRbL.onClick = mWdw.mRbR.onClick = function () {
            app.settings.saveSetting("SpookieSide", "mRbL", mWdw.mRbL.value.toString());
        }
        mWdw.mCbTL.onClick = function () {
            app.settings.saveSetting("SpookieSide", "mCbTL", mWdw.mCbTL.value.toString());
        }
    
        //あれば設定を読み込んで上書きする。
        if (app.settings.haveSetting("SpookieSide", "mRbL")) {
            mWdw.mRbL.value = (app.settings.getSetting("SpookieSide", "mRbL") === "true");
            mWdw.mRbR.value = !(mWdw.mRbL.value);
        }
        if (app.settings.haveSetting("SpookieSide", "mCbTL")) {
            mWdw.mCbTL.value = (app.settings.getSetting("SpookieSide", "mCbTL") === "true");
        }
        
        //グローバル的なLRチェックを変更してからサイドウインドウを消し、再び発動させる。
        mWdw.onClose = function(){
            mTopObj.mIsL = mWdw.mRbL.value;
            mRemoveAllNameScr("SpookieSideBar");
            mMakeCursorChkWdw();
        }
        mWdw.center();
        mWdw.show();

        return mWdw;
    }
    //----------------------------------------------------------------------------------------------------------------------
}(this));


















