﻿(function (aGbl) {
    var mFileName = "SpookieSideLauncher";
    var mOpc =0.01;
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    function mCreateUI(aObj) {
        var mPorW = (aObj instanceof Panel) ? aObj : new Window("palette", mFileName, undefined,{ resizeable: true });
        mPorW.preferredSize = [200, 540];
        mPorW.margins = [10, 10, 10, 10];
        mPorW.spacing = 5;
        mPorW.onResizing = mPorW.onResize = function () { this.layout.resize(); }
            
        mPorW.mGpTops = mPorW.add("group { alignment :  [ 'fill','top' ] , margins : [0, 0, 0, 0]}");
        mPorW.mEtWord = mPorW.mGpTops.add("edittext { alignment :  [ 'left','top' ] ,preferredSize : [60,20] , text : '' }");
        //このmRenewLstのみ、mSaveAllFileObjsでのファイル更新は行わない。
        mPorW.mEtWord.addEventListener("changing", mRenewLst);
        mPorW.mEtWord.active = true;
        mPorW.mBtSorF = mPorW.mGpTops.add("button { alignment :  [ 'right','top' ] ,preferredSize : [60,20] , text : 'Script' }");
        mPorW.mBtStg = mPorW.mGpTops.add("button { alignment :  [ 'right','top' ] ,preferredSize : [20,20] , text : '?' }");

        mPorW.mLtNm = mPorW.add("listbox {  alignment :  [ 'fill','fill' ] }");

        //ファイルObj保存用配列。
        mPorW.mAllFiles = [];
        //フルパス保存用配列。
        mPorW.mFullPaths = [];

        return mPorW;
    }

    //mPnlという名でメインウインドウを作成。
    var mPnl = mCreateUI(aGbl);
    if (mPnl instanceof Window) {
        mPnl.center();
        mPnl.opacity = mOpc;
        //ウインドウサイズを保存したものに変更する。
        if (app.settings.haveSetting(mFileName, "windowSize")) {
            var mSize = app.settings.getSetting(mFileName, "windowSize");
            mSize = mSize.split(",");
            mPnl.size = [parseInt(mSize[0]), parseInt(mSize[1])];
         }
        mPnl.show();
    } else if (mPnl instanceof Panel) {
        //UIパネルの場合は以下をしないと自動レイアウトされない。
        mPnl.layout.layout(true);
    }
    //リストボックスにアイテムを追加する。
    mSaveAllFileObjs();
    mRenewLst();

    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //セッティングパート。パスとサブフォルダチェックの保存はセッティングウインドウで行う。
    //スクリプトorファイルボタンを押すとボタン名を変え、リストを更新する。
    mPnl.mBtSorF.onClick = function(){
        if( mPnl.mBtSorF.text === "Script" ){
            mPnl.mBtSorF.text = "File";
            mSaveAllFileObjs();
            mRenewLst();
            mPnl.mBtSorF.active = true;
            mPnl.mBtSorF.active = false;
            mPnl.mEtWord.active = true;
        }else{
            mPnl.mBtSorF.text = "Script";
            mSaveAllFileObjs();
            mRenewLst();
            mPnl.mBtSorF.active = true;
            mPnl.mBtSorF.active = false;
            mPnl.mEtWord.active = true;
        }
    }
    //ウインドウを閉じたときにサイズを保存する。
    mPnl.onClose = function(){
        var mSize = "" + mPnl.size[0] +"," + mPnl.size[1];
        app.settings.saveSetting(mFileName, "windowSize",mSize);
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
     //メイン処理パート。
    mPnl.mBtStg.onClick = function () {mMakeSettingWdw();}
    //----------------------------------------------------------------------   
    mPnl.mLtNm.onChange = function () {mExecuteListItem();}
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //選択しているリストアイテムを実行する関数。
    function mExecuteListItem(aItem) {
        if( aItem === undefined ){var mItem = mPnl.mLtNm.selection;}
        else{ var mItem = aItem;}
        if( mItem === null ){ return;}
        
        //app.activeViewer.setActive();
        
        //ネームリストとフルパス配列の順番は一緒なので、
        //選択ネームリストの番号からフルパスを得る（Objではなく文字列になっている）。
        var mFullPath = mPnl.mFullPaths[mItem.index];
        //分岐のために名前も得る。名前配列を持ってくることもできるが、
        //ファイルかffxならファイルObjが必要なので得ておいてよい。
        var mFobj = new File(mFullPath);
        var mNm = mFobj.name;
        
        var mRegixJsx = new RegExp(".*\\.jsx.*");
        var mRegixFfx = new RegExp(".*\\.ffx.*");
        //もしもフルパス名の最後がjsxかjsxbinならばスクリプトを起動する。
        if (mRegixJsx.test(mNm)){
            try{ $.evalFile(mFullPath);}
            catch(e){ mPnl.close();return;}
            //起動したらウインドウを消す。
            mPnl.close();
        //もしもフルパス名の最後がffxならばプリセットを適用する。
        }else if(mRegixFfx.test(mNm)){
            app.beginUndoGroup("Apply");
            var mAi = app.project.activeItem;
            if(mAi.layers.length === 0 ){
                var mSolid = mAi.layers.addSolid([0.6, 0.6, 0.6], "Solid", mAi.width, mAi.height, mAi.pixelAspect, mAi.duration);
                mSolid.selected = true;
            }
            var mFstLyr = mAi.layers[1];
            //どのレイヤーに適用しても、選択レイヤー（複数可）に適用される。
            mFstLyr.applyPreset(mFobj);
            mPnl.close();
            app.endUndoGroup();
        //それ以外ならば、ファイルを読み込む。
        } else {
            var mOptn = new ImportOptions(mFobj);
            app.project.importFile(mOptn);
            //読み込んだらウインドウを消す。
            mPnl.close();
        }
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //セッティングウインドウ出現関数。
    function mMakeSettingWdw() {
        var mWdw = new Window("palette", mFileName + "Settings", undefined, { resizeable: true });
        mWdw.preferredSize = [600, 200];
        mWdw.margins = [5, 5, 5, 5];
        mWdw.spacing = 0;
        mWdw.onResizing = mWdw.onResize = function () { this.layout.resize(); }

        mWdw.mPlMain = mWdw.add("panel { alignment :  [ 'fill','fill' ] , margins : [5, 5, 5, 5] , spacing : 5}");
        mWdw.mBtSave = mWdw.mPlMain.add("button {preferredSize : [60, 20], alignment :  [ 'left','top' ] , text:'Save'}");
        mWdw.mPlMain.add("statictext {preferredSize : [60, 20], alignment :  [ 'left','top' ] , text:'Path :'}");
        
        mWdw.mGpScr = mWdw.mPlMain.add("group { alignment :  [ 'fill','top' ] , margins : [0, 0, 0, 0] , spacing : 0}");
        mWdw.mGpScr.add("statictext { alignment :  [ 'left','top' ] ,preferredSize : [60, 20], text:'Script'}");
        mWdw.mEtPathScr = mWdw.mGpScr.add("edittext { alignment :  [ 'fill','top' ],preferredSize : [60, 20] }");
        
        mWdw.mGpFle1 = mWdw.mPlMain.add("group { alignment :  [ 'fill','top' ] , margins : [0, 0, 0, 0] , spacing : 0}");
        mWdw.mGpFle1.add("statictext { alignment :  [ 'left','top' ] ,preferredSize : [60, 20], text:'Flie'}");
        mWdw.mEtPathFle1 = mWdw.mGpFle1.add("edittext { alignment :  [ 'fill','top' ] ,preferredSize : [60, 20] }");
        
        mWdw.mGpFle2 = mWdw.mPlMain.add("group { alignment :  [ 'fill','top' ] , margins : [0, 0, 0, 0] , spacing : 0}");
        mWdw.mGpFle2.add("statictext { alignment :  [ 'left','top' ] ,preferredSize : [60, 20], text:'Flie'}");
        mWdw.mEtPathFle2 = mWdw.mGpFle2.add("edittext { alignment :  [ 'fill','top' ] ,preferredSize : [60, 20] }");
        
        mWdw.mGpFle3 = mWdw.mPlMain.add("group { alignment :  [ 'fill','top' ] , margins : [0, 0, 0, 0] , spacing : 0}");
        mWdw.mGpFle3.add("statictext { alignment :  [ 'left','top' ] ,preferredSize : [60, 20], text:'Flie'}");
        mWdw.mEtPathFle3 = mWdw.mGpFle3.add("edittext { alignment :  [ 'fill','top' ] ,preferredSize : [60, 20] }");
        
        mWdw.mPlMain.add("statictext {preferredSize : [120, 20], alignment :  [ 'left','top' ] , text:'SubFolders :'}");
        mWdw.mGpChk = mWdw.mPlMain.add("group { alignment :  [ 'fill','top' ] , margins : [0, 0, 0, 0] , spacing : 0}");   
        mWdw.mCbSubScr = mWdw.mGpChk.add("checkbox { alignment :  [ 'left','top' ] ,preferredSize : [60, 20], text:'Script'}");
        mWdw.mCbSubFle = mWdw.mGpChk.add("checkbox { alignment :  [ 'left','top' ] ,preferredSize : [60, 20], text:'Flie'}");  
        mWdw.mCbSubScr.value = true;
        mWdw.mCbSubFle.value = true;
        
        mWdw.mPlMain.add("statictext {preferredSize : [120, 20], alignment :  [ 'left','top' ] , text:'Match :'}");
        mWdw.mGpRbScr = mWdw.mPlMain.add("group { alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0] , spacing : 0}");
        mWdw.mGpRbScr.add("statictext { alignment :  [ 'left','top' ]  ,preferredSize : [60, 20],text:'Script'}");
        mWdw.mRbScrIntl = mWdw.mGpRbScr.add("radiobutton { alignment :  [ 'left','top' ] ,preferredSize : [80, 20], text:'Intellectual'}");
        mWdw.mRbScrFwd = mWdw.mGpRbScr.add("radiobutton { alignment :  [ 'left','top' ] ,preferredSize : [80, 20], text:'Forward'}");
        mWdw.mRbScrPtl = mWdw.mGpRbScr.add("radiobutton { alignment :  [ 'left','top' ] ,preferredSize : [80, 20], text:'Partial'}");
        mWdw.mGpRbFle= mWdw.mPlMain.add("group { alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0] , spacing : 0}");
        mWdw.mGpRbFle.add("statictext { alignment :  [ 'left','top' ],preferredSize : [60, 20] ,text:'File'}");
        mWdw.mRbFleIntl = mWdw.mGpRbFle.add("radiobutton { alignment :  [ 'left','top' ] ,preferredSize : [80, 20], text:'Intellectual'}");
        mWdw.mRbFleFwd = mWdw.mGpRbFle.add("radiobutton { alignment :  [ 'left','top' ] ,preferredSize : [80, 20], text:'Forward'}");
        mWdw.mRbFlePtl = mWdw.mGpRbFle.add("radiobutton { alignment :  [ 'left','top' ] ,preferredSize : [80, 20], text:'Partial'}");
        mWdw.mRbScrIntl.value = true;
        mWdw.mRbFleIntl.value = true;

        mWdw.onClose = function(){
            mSaveAllFileObjs();
            mRenewLst();
        }
   
        mWdw.mBtSave.onClick = function () {
            //パスを保存する。
            app.settings.saveSetting(mFileName, "mEtPathScr", mWdw.mEtPathScr.text);
            app.settings.saveSetting(mFileName, "mEtPathFle1", mWdw.mEtPathFle1.text);
            app.settings.saveSetting(mFileName, "mEtPathFle2", mWdw.mEtPathFle2.text);
            app.settings.saveSetting(mFileName, "mEtPathFle3", mWdw.mEtPathFle3.text);
        }
        mWdw.mCbSubScr.onClick = function () {
            app.settings.saveSetting(mFileName, "mCbSubScr", mWdw.mCbSubScr.value.toString());
        }
        mWdw.mCbSubFle.onClick = function () {
            app.settings.saveSetting(mFileName, "mCbSubFle", mWdw.mCbSubFle.value.toString());
        }
    
        mWdw.mRbScrIntl.onClick = mWdw.mRbScrFwd.onClick = mWdw.mRbScrPtl.onClick = function () {
            if( mWdw.mRbScrIntl.value){ app.settings.saveSetting(mFileName, "mRbScr", 0); }
            else if( mWdw.mRbScrFwd.value){ app.settings.saveSetting(mFileName, "mRbScr", 1); }
            else { app.settings.saveSetting(mFileName, "mRbScr", 2); }
        }
        mWdw.mRbFleIntl.onClick = mWdw.mRbFleFwd.onClick = mWdw.mRbFlePtl.onClick = function () {
            if( mWdw.mRbFleIntl.value){ app.settings.saveSetting(mFileName, "mRbFle", 0); }
            else if( mWdw.mRbFleFwd.value){ app.settings.saveSetting(mFileName, "mRbFle", 1); }
            else { app.settings.saveSetting(mFileName, "mRbFle", 2); }
        }

        //あれば設定を読み込んで上書きする。
        if (app.settings.haveSetting(mFileName, "mEtPathScr")) {
            mWdw.mEtPathScr.text = app.settings.getSetting(mFileName, "mEtPathScr");
        }
        if (app.settings.haveSetting(mFileName, "mEtPathFle1")) {
            mWdw.mEtPathFle1.text = app.settings.getSetting(mFileName, "mEtPathFle1");
        }
        if (app.settings.haveSetting(mFileName, "mEtPathFle2")) {
            mWdw.mEtPathFle2.text = app.settings.getSetting(mFileName, "mEtPathFle2");
        }
        if (app.settings.haveSetting(mFileName, "mEtPathFle3")) {
            mWdw.mEtPathFle3.text = app.settings.getSetting(mFileName, "mEtPathFle3");
        }
        if (app.settings.haveSetting(mFileName, "mCbSubScr")) {
            mWdw.mCbSubScr.value = (app.settings.getSetting(mFileName, "mCbSubScr") === "true");
        }
        if (app.settings.haveSetting(mFileName, "mCbSubFle")) {
            mWdw.mCbSubFle.value = (app.settings.getSetting(mFileName, "mCbSubFle") === "true");
        }
        if (app.settings.haveSetting(mFileName, "mRbScr")) {
            var mStgTp = app.settings.getSetting(mFileName, "mRbScr");
            if( mStgTp === "0" ){ mWdw.mRbScrIntl.value = true;}
            else if( mStgTp === "1" ){mWdw.mRbScrFwd.value = true;}
            else{mWdw.mRbScrPtl.value = true;}
        }
        if (app.settings.haveSetting(mFileName, "mRbFle")) {
            var mStgTp = app.settings.getSetting(mFileName, "mRbFle");
            if( mStgTp === "0" ){ mWdw.mRbFleIntl.value = true;}
            else if( mStgTp === "1" ){mWdw.mRbFleFwd.value = true;}
            else{mWdw.mRbFlePtl.value = true;}
        }
    
        mWdw.center();
        mWdw.show();

        return mWdw;
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //指定したファイルObjをグローバル的配列に保存する関数。
    function mSaveAllFileObjs() {
        //まずはセッティングからファイルObjsを得る。
        var mFpth = "";
        var mFpths = ["","",""];
        var mWithSub = true;
        var mIsScr =  (mPnl.mBtSorF.text === "Script");
        if(mIsScr){
            if (app.settings.haveSetting(mFileName, "mEtPathScr")) { mFpth = app.settings.getSetting(mFileName, "mEtPathScr"); }
            if (app.settings.haveSetting(mFileName, "mCbSubScr")) { mWithSub = (app.settings.getSetting(mFileName, "mCbSubScr")=== "true"); }
            //パスが空ならばリストを全削除する。
            if( mFpth === "" ){
                mPnl.mLtNm.removeAll();            
                return;
            }
            mFpths = [mFpth];
        }else{
            if (app.settings.haveSetting(mFileName, "mEtPathFle1")) { mFpths[0] = app.settings.getSetting(mFileName, "mEtPathFle1"); }
            if (app.settings.haveSetting(mFileName, "mEtPathFle2")) { mFpths[1] = app.settings.getSetting(mFileName, "mEtPathFle2"); }  
            if (app.settings.haveSetting(mFileName, "mEtPathFle3")) { mFpths[2] = app.settings.getSetting(mFileName, "mEtPathFle3"); }   
            if (app.settings.haveSetting(mFileName, "mCbSubFle")) { mWithSub = (app.settings.getSetting(mFileName, "mCbSubFle")=== "true"); }
            //パスが全て空ならばリストを全削除する。
            if( mFpths[0] === "" && mFpths[1] === "" && mFpths[2] === "" ){
                mPnl.mLtNm.removeAll(); 
                return;
            }
        }

        //パス内の全てのファイルを得る。
        //ファイルの場合は複数のパスなので、どちらもfor文で回す。
         var mFileObjs = [];
        for (var i = 0; i < mFpths.length; i++) {
            var mFpth =  mFpths[i];
            if( mFpth === ""){ continue;}
            var mFileObjsTp = mGetFileObjs(mFpth,mWithSub );
            //もしもタイムアウトしてnullが返ってきたら [ ] にする。
            if (mFileObjsTp === null) { mPnl.mAllFiles = []; }
            mFileObjs = mFileObjs.concat( mFileObjsTp );
        }
        if (mFileObjs.length === 0) { mPnl.mAllFiles = [];}
        
        //グローバル的配列に保存する。
        mPnl.mAllFiles = mFileObjs;
        
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //リストボックスの中身を更新する関数。
    function mRenewLst() {
        //メイン部分をTryしてエラーが出たら元に戻す。
        //mRenewLstMain();
        try {
            mRenewLstMain();
        } catch (e) {
            alert(e.message + "\n" + e.line);
            //+"\n" +e.fileName
        }
        //-------------------------------------------------------------------------
        function mRenewLstMain() {
            //最初（あるいはパス更新時、スクリプトorファイルボタン変更時）にグローバル的配列に保存した、ファイルObjsを使う。
            var mFileObjs = mPnl.mAllFiles;

            //スクリプトチェックがtrueならばjsxかjsxbinのみにする。
            var mIsScr =  (mPnl.mBtSorF.text === "Script");
            if (mIsScr) {
                var mRegix = new RegExp(".*\\.jsx.*");
                for (var i = mFileObjs.length - 1; i >= 0; i--) {
                    if (!(mRegix.test(mFileObjs[i].name))) {
                        mFileObjs.splice(i, 1);
                    }
                }
            }
            //ファイルObjsをフルパスと名前の配列に分ける。
            var mNms = [];
            var mFullPaths = [];
            for (var i = 0; i < mFileObjs.length; i++) {
                //日本語や空白部分をデコードしたものを入れる。
                mNms.push(decodeURIComponent(mFileObjs[i].name));
                mFullPaths.push(decodeURIComponent(mFileObjs[i].fullName));
            }

            //スクリプトチェックがtrueならば名前配列からドット以下を消す。
            if (mIsScr) {
                for (var i = 0; i < mNms.length; i++) {
                    var mRegix = new RegExp("\\..*");
                    mNms[i] = mNms[i].replace(mRegix, "");
                }
            }

            //現時点での検索ワードでソートする。
            //部分一致チェックで部分一致にする。
            var mWord = mPnl.mEtWord.text;
            //一応、日本語用にURIエンコードしておく。
            mWord = encodeURIComponent(mWord);
            //検索ワードが無い場合は更新だけしてリターンする。
            if (mWord === "") {
                //ネームのリストとフルパスの配列を更新する。
                mPnl.mLtNm.removeAll();
                for (var i = 0; i < mNms.length; i++) { mPnl.mLtNm.add("item", mNms[i]); }
                mPnl.mFullPaths = mFullPaths;
                //mPnl.layout.resize();
                return;
            }
        
        
            var mIsPtl = false;
             //セッティングからソートオーダーを得る。
             var mSortOrder = 0;
            if (mIsScr) {
                if (app.settings.haveSetting(mFileName, "mRbScr")){ mSortOrder = parseInt( app.settings.getSetting(mFileName, "mRbScr"));}
            }else{
                if( app.settings.haveSetting(mFileName, "mRbFle")) {mSortOrder = parseInt( app.settings.getSetting(mFileName, "mRbFle"));}
            }

            //Intlチェックがある場合。
            if( mSortOrder === 0 ){
                //１文字目は前方一致、２文字目以降は部分一致にする。
                //検索ワードの間に正規表現を挟む。
                var mRegixStr = "^" + mEcpStr(mWord[0]) +".*";
                for( var i = 1; i <mWord.length; i++ ){
                    //記号があればエスケープしておく。
                    mRegixStr = mRegixStr + mEcpStr(mWord[i]) + "+" +".*";
                }
                mRegixStr =mRegixStr +"$";
                var mRegixItltl = new RegExp( mRegixStr ,"i");
                for (var i = mNms.length - 1; i >= 0; i--) {
                    var mNm = mEcpStr(encodeURIComponent(mNms[i]));
                    if (!(mRegixItltl.test(mNm))) {
                        mNms.splice(i, 1);
                        mFullPaths.splice(i, 1);
                    }
                }
            //前方一致と部分一致の場合。
            }else{
                if( mSortOrder === 1 ){ var mRegix = new RegExp("^" + mEcpStr(mWord) + ".*","i");}
                else if( mSortOrder === 2 ){ var mRegix = new RegExp(".*" + mEcpStr(mWord) + ".*","i");}
                for (var i = mNms.length - 1; i >= 0; i--) {
                    if (!(mRegix.test(mEcpStr(encodeURIComponent(mNms[i]))))) {
                        mNms.splice(i, 1);
                        mFullPaths.splice(i, 1);
                    }
                }
            }
            
            //ネームのリストとフルパスの配列を更新する。
            mPnl.mLtNm.removeAll();
            for (var i = 0; i < mNms.length; i++) { mPnl.mLtNm.add("item", mNms[i]); }
            mPnl.mFullPaths = mFullPaths;
            
            //一致したもののうち、１番目を選択しておく。
            //if(mNms.length !== 0){ mPnl.mLtNm.selection = mPnl.mLtNm.items[0];}
            
            //選択アイテムが1つであればアイテムを発動させる。
            if(mNms.length === 1){ mExecuteListItem(mPnl.mLtNm.items[0]);}
            
            //mPnl.layout.resize();
        }
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //フォルダパスからファイルObjの配列を得る関数。
    //ファイルObjのプロパティは以下。
    //fullName　フルパス＆ファイル名。
    //path　フルパス。
    //name　ファイル名。
    function mGetFileObjs(aPth  ,aWithSub) {
        var mRst = [];
        var mStopOrNot = false;
        var mStdTime = Date.now();

        //サブフォルダチェックがtrueならば再帰処理版を使う。
        if (aWithSub) { mExecute2(aPth); }
        else { mExecute1(aPth); }

        //取得処理が終わり、mStopOrNotがtrueになっていれば１秒タイムアウトなのでnullを返す。
        if (mStopOrNot) { return null; }
        return mRst;

        //ファイルObj取得関数その１。指定フォルダのみを探す。
        function mExecute1(aPth) {
            //getFiles()で得られるものはフルパス名ではなくファイルObj。
            var mFls = new Folder(aPth).getFiles();
            for (var i = 0; i < mFls.length; i++) {
                //もしもファイルならば配列に入れる。
                if (mFls[i] instanceof File) {
                    mRst.push(mFls[i]);
                }
            }
        }
        //ファイルObj取得関数その２。再帰処理でサブフォルダも探す。
        function mExecute2(aPth) {
            //もしも指定ミリ秒を超えたら、ストップorNotチェックをtrueにして、リターンする。
            if (mTimeOut(mStdTime, 100)) {
                mStopOrNot = true;
                return;
            }
            //getFiles()で得られるものはフルパス名ではなくファイルObj。
            var mFls = new Folder(aPth).getFiles();
            //正規表現（カッコでくくられた文字列）。
            var mExt = ".*\\(.*\\)$";
            for (var i = 0; i < mFls.length; i++) {
                //もしもフルパス先がフォルダ、かつ名前にカッコがなく、シャットダウン、スタートアップフォルダでなければ、
                //再帰処理でmExecuteを行う。
                if (mFls[i] instanceof Folder
                    && RegExp(mExt).test(mFls[i].name) === false
                    && mFls[i].name !== "Shutdown" && mFls[i].name !== "Startup") {
                    mExecute2(mFls[i]);
                    //フルパス先がファイルならば配列に入れる。
                } else {
                    if (mFls[i] instanceof File) {
                        mRst.push(mFls[i]);
                    }
                }
            }
        }

        //使用関数。
        //タイムアウト関数。もしも経過時間（ 現在時間 - 引数の基準時間 )が指定ミリ秒を超えたらtrueを返す。
        function mTimeOut(aStdTime, aMilliSec) {
            var mNowTime = Date.now();
            if (mNowTime - aStdTime > aMilliSec) { return true; }
            else { return false; }
        }
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //正規表現記号をエスケープする関数。
    function mEcpStr(aStr) {
        return aStr.replace(/[.*+\-?^${}()|[\]\\]/g, "\\$&");
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
})(this);


















