﻿(function (aGbl) {
    //バージョン1.1。
    //----------------------------------------------------------------------------------------------------------------------
    function mCreateUI(aObj) {
        var mPorW = (aObj instanceof Panel) ? aObj : new Window("palette", "SpookieEffecter", [0, 0, 200, 200]);
        mPorW.mTbp = mPorW.add("panel { type : 'tabbedpanel' , bounds : [0,0,190,190] , location : [5,5] , \
    mTbEft : Panel{ type : 'tab' , text : 'effects' } \
    mTbTxt : Panel{ type : 'tab' , text : 'text' }  }");

        mPorW.mLbEft = mPorW.mTbp.mTbEft.add("listbox { bounds : [0,0,185,155] , location : [0,0] }");


        mPorW.mEtTxt = mPorW.mTbp.mTbTxt.add("editText", [0, 0, 185, 155], "", { multiline: true });

        return mPorW;
    }

    var mPnl = mCreateUI(aGbl);
    if (mPnl instanceof Window) {
        mPnl.center();
        //mPnl.opacity = 0.01;
        mPnl.show();

    }

    //保存された設定があればエディットテキストに入れる。
    //（このスクリプトに関しては、設定の日本語文字化けを防ぐために
    //ユニコード整数化して設定保存している。なので、それを文字に変換してから入れる）
    mPnl.mCodeTxtFromSetting = mGetSetting();
    mPnl.mEtTxt.text = mConvertCodesTxtToTxt(mPnl.mCodeTxtFromSetting);

    //リストを更新する。
    mTxtToList();

    //----------------------------------------------------------------------------------------------------------------------
    //リストをダブルクリックでエフェクトを追加。
    mPnl.mLbEft.onDoubleClick = function () {
        var mSls = app.project.activeItem.selectedLayers;

        //選択しているリストの文字。
        var mEftName = mPnl.mLbEft.selection.text;

        app.beginUndoGroup("SpookieEffecter");
        for (var i = 0; i < mSls.length; i++) {
            try {
                //選択している各レイヤーのエフェクトプロパティにエフェクト（文字名）を追加。
                mSls[i].effect.addProperty(mEftName);
            } catch (e) {
                //エラーが出るようなら指定エフェクトが存在しないのでアラートを出す。
                alert("The effect does not exist.")
                break;
            }
        }
        app.endUndoGroup();

        //エフェクトを適用したらパネルを閉じる。
        mPnl.close();
    }
    //----------------------------------------------------------------------------------------------------------------------
    //テキストタブパネルのテキストが変更されたらリスト更新。
    mPnl.mEtTxt.onChange = function () { mTxtToList(); }


    //----------------------------------------------------------------------------------------------------------------------
    //----------------------------------------------------------------------------------------------------------------------
    //リストの更新関数（一番最初と、テキストを書き換えたときに使う）。
    //外部変数をそのまま使っている、処理使いまわし用の関数。
    function mTxtToList() {
        //まずはエフェクトタブパネルのリストを削除。
        mPnl.mLbEft.removeAll();

        //テキストタブパネルのテキストを改行で分けて、リストに全て追加。
        var mTxt = mPnl.mEtTxt.text.split(/\r\n|\r|\n/);
        for (var i = 0; i < mTxt.length; i++) {
            mPnl.mLbEft.add("item", mTxt[i]);
        }

        //テキストタブパネルのテキスト（改行で分ける前の全体）をユニコード番号にして設定に保存する。
        var mCodeTxt = mConvertTxtToCodesTxt(mPnl.mEtTxt.text);
        mSaveSetting(mCodeTxt);
    }
    //----------------------------------------------------------------------------------------------------------------------
    //セッティング関連関数。
    function mSetName() {
        //保存される設定のセクション名とキー名を変えたい場合はここで変える。
        return ["SpookieEffecter", "effectName"];
    }
    //----------------------------------------------------------
    //設定があればそれを返す関数。
    function mGetSetting() {
        var mPref = mSetName();
        if (app.settings.haveSetting(mPref[0], mPref[1]) === false) {
            return "";
        } else {
            return app.settings.getSetting(mPref[0], mPref[1]);
        }
    }
    //----------------------------------------------------------
    //引数を設定に保存する関数。
    function mSaveSetting(aValue) {
        var mPref = mSetName();
        app.settings.saveSetting(mPref[0], mPref[1], aValue);
    }
    //----------------------------------------------------------------------------------------------------------------------
    //文字をコード（数字）の文字列にする関数。
    function mConvertTxtToCodesTxt(aTxt) {
        var mNameCodes = [];
        //文字を一つずつUnicode（数字）で取得して、配列に入れる。
        for (var i = 0; i < aTxt.length; i++) {
            var mCode = aTxt.charCodeAt(i);
            mNameCodes.push(mCode);
        }
        //コードの配列をコンマ区切りの文字列にする。
        //aTxtに””を入力すると、lengthゼロなので直接ここへ来て、空の配列mNameCodesを処理する。
        //join()は[]を””にするので、戻り値がコード文字列or””となるが、読み込み関数で処理する。
        var mNameCodesStr = mNameCodes.join(",");
        return mNameCodesStr;
    }
    //----------------------------------------------------------
    //コード（数字）の文字列を元の文字にする関数。
    function mConvertCodesTxtToTxt(aCodesTxt) {
        //空""にはコード番号はない。それに対し、
        //（本来コード番号数値を入れるはずの）fromCharCode()に空””（文字列）を入れると
        //なぜかコード番号0番目の空を取得してしまう。厳密には変換できていないので、その対策が以下。
        if(aCodesTxt ===""){ return ""}
        
        //まずは文字列を配列にする。
        var mNameCodesAry = aCodesTxt.split(",");
        var mNameLetterAry = [];
        //Unicode（数字）を文字にして１つずつ取得、配列に入れていく。
        for (var i = 0; i < mNameCodesAry.length; i++) {
            var mLetter = String.fromCharCode(mNameCodesAry[i]);
            mNameLetterAry.push(mLetter);
        }
        //１文字ずつ入った配列を１つの文字列にまとめる。
        var mNameRst = mNameLetterAry.join("");
        return mNameRst;
    }
    //----------------------------------------------------------------------------------------------------------------------
}(this));





