﻿(function (aGbl) {
    //（このスクリプト内での）グローバルObj。
    mTjs = {};
    mTjs.mScreen;
    mTjs.mCsrWdw;
    mTjs.mKeyWdw;
    mTjs.mQWdw;
    
    //始めにスクリプト＆ショートカット設定と全文を読み込む。
    mTjs.mAllStr = "" +
    "Up : SpookieEffecter.jsx" + "\n" +
    "Left : SpookieEffecter.jsx" + "\n" +
    "Right : SpookieEffecter.jsx" + "\n" +
    "Down : SpookieEffecter.jsx" + "\n" +
    "\n" +
    "A : SpookieEffecter.jsx" + "\n" +
    "B : SpookieEffecter.jsx";
    //あれば設定（全てのテキスト）を読み込んで上書きする。
    if (app.settings.haveSetting("SpookieDice", "mAllStr")) {
        mTjs.mAllStr = app.settings.getSetting("SpookieDice", "mAllStr");
    }    
    //----------------------------------------------------------------------------------------------------------------------
    //----------------------------------------------------------------------------------------------------------------------
    //～カーソル位置取得。
    //カーソル位置取得用ウインドウを作る関数。
    function mMakeCsrWdw(aScreen) {
        //大きさは仮で、上部分の帯を無くし、透明度を最小にして出現させる。
        var mWdw = new Window("palette", "SpookieDiceCsr", [0, 0, 100, 100], { borderless: true });
        mWdw.opacity = 0.01;
        mWdw.show();

        //まずは最大サイズをスクリーンサイズまで上げる。
        mWdw.maximumSize = [aScreen.right, aScreen.bottom];
        //それから実際にサイズを大きくする。
        mWdw.bounds = [aScreen.left, aScreen.top, aScreen.right, aScreen.bottom];

        //ウインドウ自体にはカーソル感知領域がないので、同サイズのパネルをウインドウ内に作る。
        mWdw.mP1 = mWdw.add("panel", [0, 0, 100, 100]);
        mWdw.mP1.maximumSize = [aScreen.right, aScreen.bottom];
        mWdw.mP1.bounds = [aScreen.left, aScreen.top, aScreen.right, aScreen.bottom];

        //イベントリスナーでカーソル感知機能と、検知後の操作を付ける。
        mWdw.addEventListener("mouseover", mMseOvr);

        return mWdw;

        //感知ウインドウがマウスオーバーしたら、カーソル座標を取得し、その後の処理を実行する。
        function mMseOvr(e) { mNextStep([e.screenX, e.screenY]); }
    }
    //-----------------------------------------------------------
    //スクリーンを取得。
    mTjs.mScreen = $.screens[0];
    //感知ウインドウを出現させる。マウスオーバーイベントで次のステップへ進む。
    mTjs.mCsrWdw = mMakeCsrWdw(mTjs.mScreen);

    //----------------------------------------------------------------------------------------------------------------------
    //----------------------------------------------------------------------------------------------------------------------
    //カーソル位置取得後の処理。
    function mNextStep(aCsrPos) {
        //まずは感知ウインドウを消す。
        mTjs.mCsrWdw.close();
        //----------------------------------------------------------------- 
        //キー＆マウスアウト検知ウインドウ作成関数。
        function mMakeKeyWdw() {
            var mWdw = new Window("palette", "SpookieDice", undefined, { borderless: true });
            mWdw.preferredSize = [200, 200];
            mWdw.margins = [0, 0, 0, 0];
            mWdw.spacing = 0;
            mWdw.orientation = "stack";

            //ボタンはアクティブにし、隠しておく。
            mWdw.mBt = mWdw.add("button { alignment :  [ 'fill','fill' ] , margins : [0, 0, 0, 0]}");
            mWdw.mBt.active = true;
            mWdw.mBt.hide();

            mWdw.mPl = mWdw.add("panel { preferredSize : [-1, -1], alignment :  [ 'fill','fill' ] , margins : [0, 0, 0, 0]}");
            mWdw.mPlTgt = mWdw.add("panel { preferredSize : [120, 120], alignment :  [ 'center','center' ] , margins : [0, 0, 0, 0]}");
            mWdw.mPlU = mWdw.add("group { preferredSize : [40, 40], alignment :  [ 'fill','top' ] , margins :  [0, 0, 0, 0]}");
            mWdw.mPlL = mWdw.add("group { preferredSize : [40, 40], alignment :  [ 'left','fill' ] , margins :  [0, 0, 0, 0]}");
            mWdw.mPlR = mWdw.add("group { preferredSize : [40, 40], alignment :  [ 'right','fill' ] , margins :  [0, 0, 0, 0]}");
            mWdw.mPlB = mWdw.add("group { preferredSize : [40, 40], alignment :  [ 'fill','bottom' ] , margins :  [0, 0, 0, 0]}");
            //--------------------
            //キーが押されたらキー名を取得して次の処理をする。
            mWdw.addEventListener("keydown", mKeyDwn);
            function mKeyDwn(e) { mNextStepKey(e.keyName); }
            //--------------------
            //マウスアウトしたらイベントを取得してリ次の処理をする。
            mWdw.addEventListener("mouseover", mMseOvrTBLR);
            function mMseOvrTBLR(e) { mNextStepOut(e); }
            //--------------------
            //ウインドウをクリックすると消える仕様にする。
            mWdw.addEventListener("mousedown", mMsedwn);
            function mMsedwn(e) { mWdw.close(); mTjs.mQWdw.close(); }
            //チェックがあれば透明にする。
            var mIsInv = true; 
            if (app.settings.haveSetting("SpookieDice", "mCbInv")) {
                mIsInv = (app.settings.getSetting("SpookieDice", "mCbInv") === "true");
            }
            if(mIsInv){ mWdw.opacity = 0.01;}
            else{ mWdw.opacity = 1;}

            return mWdw;
        }
        //----------------------------------------------------------------- 
        //？ウインドウ表示関数。
        function mMakeQWdw() {
            var mWdw = new Window("palette", "Q", undefined, { borderless: true });
            mWdw.preferredSize = [20, 20];
            mWdw.margins = [0, 0, 0, 0];
            mWdw.spacing = 0;
            mWdw.orientation = "stack";

            //ボタンはアクティブにし、隠しておく。
            mWdw.mBt = mWdw.add("button { preferredSize : [20, 20],alignment :  [ 'center','center' ] , margins : [0, 0, 0, 0]}");
            mWdw.mBt.active = true;
            mWdw.mBt.hide();

            mWdw.mBtnCtr = mWdw.add("button { text:'?', preferredSize : [20, 20],alignment :  [ 'center','center' ] }");
            //--------------------
            //キーが押されたらキー名を取得して次の処理をする。
            mWdw.addEventListener("keydown", mKeyDwn);
            function mKeyDwn(e) { mNextStepKey(e.keyName); }
            //--------------------
            //ウインドウをクリックすると消える仕様にする。
            mWdw.addEventListener("mousedown", mMsedwn);
            function mMsedwn(e) { mWdw.close(); mTjs.mKeyWdw.close(); }
            //--------------------
            //セッティングボタンのオンクリックを付ける。
            mWdw.mBtnCtr.onClick = function () {mMakeSettingWdw(); }
            //--------------------
            return mWdw;
        }
        //-----------------------------------------------------------------
        //ウインドウを出現させ、内部イベントリスナーによってキーを取得＆ウインドウを消す＆その後の処理をする。
        mTjs.mKeyWdw = mMakeKeyWdw();
        mTjs.mQWdw = mMakeQWdw();
        //showしないとサイズが決まらないのでshowする。
        mTjs.mKeyWdw.show();
        mTjs.mQWdw.show();
        var mKeyWdwSize = mTjs.mKeyWdw.size;
        var mQWdwSize = mTjs.mQWdw.size;
        mTjs.mKeyWdw.location = [aCsrPos[0] - mKeyWdwSize[0] / 2, aCsrPos[1] - mKeyWdwSize[1] / 2];
        mTjs.mQWdw.location = [aCsrPos[0] - mQWdwSize[0] / 2, aCsrPos[1] - mQWdwSize[1] / 2];

    }
    //----------------------------------------------------------------------------------------------------------------------
    //----------------------------------------------------------------------------------------------------------------------
    //キー取得後の処理。キー検知イベント内で実行される。
    function mNextStepKey(aKeyName) {
        //キー＆アウト感知ウインドウの位置を出現位置として使う。
        var mKeyWdw = mTjs.mKeyWdw;
        var mRstPos = [mKeyWdw.location[0], mKeyWdw.location[1]];
        
        //キー＆アウト感知と？ウインドウを消す。
        mTjs.mKeyWdw.close();
        mTjs.mQWdw.close();
                
        //取得したキー名。
        var mKeyName = aKeyName;
        //実行する。
        mExecScrOrMenu(mKeyName, mRstPos);
    }
    //----------------------------------------------------------------------------------------------------------------------
    //----------------------------------------------------------------------------------------------------------------------
    //アウト位置取得後の処理。アウト位置検知イベント内で実行される。
    function mNextStepOut(aEventObj) {
        var mEventObj = aEventObj;
        var mTgtPart = mEventObj.target;
        var mKeyWdw = mTjs.mKeyWdw;

        //キー検知ウインドウの位置と大きさを取っておく。
        var mKeyWdwPos = [mKeyWdw.location[0], mKeyWdw.location[1]];
        var mKeyWdwSize = [mKeyWdw.size[0], mKeyWdw.size[1]];

        //どの方向から出たかを得る。四方パネル以外の要素でイベントが起こった場合はリターンする。
        //四方パネル以外とはベースパネルで、それにイベントが起こり得るのは？から出たときで、？から出てもまた四方パネルはあるので
        //ウインドウ２つを残したままリターンして問題ない。
        var mDir = 0;
        if (mTgtPart === mKeyWdw.mPlU) { mDir = 0; }
        else if (mTgtPart === mKeyWdw.mPlL) { mDir = 1; }
        else if (mTgtPart === mKeyWdw.mPlR) { mDir = 2; }
        else if (mTgtPart === mKeyWdw.mPlB) { mDir = 3; }
        else { return; }

        //キー＆アウト感知と？ウインドウを消す。
        mTjs.mKeyWdw.close();
        mTjs.mQWdw.close();

        var mRstPos = [];
        var mKeyName = null;
        if (mDir === 0) {
            mRstPos = mKeyWdwPos + [mKeyWdwSize[0] / 2, 0];
            mKeyName = "Up";
        } else if (mDir === 1) {
            mRstPos = mKeyWdwPos + [0, mKeyWdwSize[1] / 2];
            mKeyName = "Left";
        } else if (mDir === 2) {
            mRstPos = mKeyWdwPos + [mKeyWdwSize[0], mKeyWdwSize[1] / 2];
            mKeyName = "Right";
        } else if (mDir === 3) {
            mRstPos = mKeyWdwPos + [mKeyWdwSize[0] / 2, mKeyWdwSize[1]];
            mKeyName = "Down";
        }

        //実行する。
        mExecScrOrMenu(mKeyName, mRstPos);
    }
    //----------------------------------------------------------------------------------------------------------------------
    //----------------------------------------------------------------------------------------------------------------------
    //----------------------------------------------------------------------------------------------------------------------
    //----------------------------------------------------------------------------------------------------------------------
    //スクリプト（あるいはメニュー）実行関数。
    function mExecScrOrMenu(aKeyName ,aRstPos) {
        var mKeyName = aKeyName;
            
        //mTjs.mAllStrにキー名に対応する名前があるか探す（キー自体の名前ではない）。
        var mKeyScrNmSets = mGetKeyScrNmSets(mTjs.mAllStr);
        var mScrName = "";
        for (var i = 0; i < mKeyScrNmSets.length; i++) {
            var mSet = mKeyScrNmSets[i];
            if( mKeyName === mSet[0] ){
                mScrName = mSet[1];
                break;
            }
        }

        if (mScrName === "" ) { return; }
        
        //あればパスを得る。
        var mPath = "";
        if (app.settings.haveSetting("SpookieDice", "mEtPath")) {
            mPath = app.settings.getSetting("SpookieDice", "mEtPath");
        }
        //スクリプトリストがゼロの場合メニューを試したいので、パスが""でもリターンしない。

        //パスから全スクリプトを得る。
        var mAllScrs = mGetScr(mPath);
        //パスでのスクリプト実行を試み、無いならメニュー実行する。
        var mRegix = new RegExp(".+\.jsx.*");
        //ショートカットやjsxbinもあるので前方一致にしておく。
        var mRegixScr = new RegExp("^" + mScrName + ".*");

        var mNoEvlFleChk = true;
        if (mRegix.test(mScrName)) {
            for (var i = 0; i < mAllScrs.length; i++) {
                var mTgtScr = mAllScrs[i];
                if (mRegixScr.test(decodeURIComponent(mTgtScr.name))) {
                    //エラーが出たらリターンする。
                    try { $.evalFile(mTgtScr.fullName); }
                    catch (e) { return; }
                    mNoEvlFleChk = false;
                    break;
                }
            }
        }

        
        //スクリプトアラートを一時消し、キー名スクリプトを実行する。
        //こちらはエラーではなくAEのアラートが出るのでダイアログを消しておく。
        if( mNoEvlFleChk ){
            app.beginSuppressDialogs();
            app.executeCommand(app.findMenuCommandId(mScrName));
            app.endSuppressDialogs(false);
        }

        //---------------------------------------------
        //UIスクリプトを実行した場合は出現したスクリプトを移動させる。
        //UIスクリプトの前に最後に出現したのはmQWdwなので、ラストスクリプトがmQWdwではければUIスクリプトを実行したこととなる。
        var mHasMove = true;
        if (app.settings.haveSetting("SpookieDice", "mCbCur")) {
            mHasMove = (app.settings.getSetting("SpookieDice", "mCbCur") === "true");
            
        }
        if (mHasMove) {
            var mRstPos = aRstPos;
            var mLastWdw = Window.children[Window.children.length - 1];
            if (mLastWdw !== mTjs.mQWdw) {
                //画面外に出ないように調整する。
                var mSize = [mLastWdw.size[0], mLastWdw.size[1]];
                var mScrLocRD = mRstPos + mSize;
                var mScreen = mTjs.mScreen;
                //左右。
                if (mScrLocRD[0] > mScreen.right) { mRstPos[0] = mScreen.right - mSize[0]; }
                else if (mRstPos[0] < mScreen.left) { mRstPos[0] = mScreen.left; }
                //上下。
                if (mScrLocRD[1] > mScreen.bottom) {
                    mRstPos[1] = mScreen.bottom - mSize[1];
                } else if (mRstPos[1] + mSize[1] - mLastWdw.frameSize[1] < mScreen.top) {
                    mRstPos[1] = mScreen.top + mLastWdw.frameSize[1] - mSize[1];
                }
                mLastWdw.location = mRstPos;
            }
        }
    }

    //---------------------------------------------------------------------------------------------------------------------- 
    //パスから全スクリプトを得る関数。
   function mGetScr(aPath) {
       var mFold = new Folder(aPath);
       var mRstScrs = [];
       var mFiles = mFold.getFiles();
       var mFolders = [];
       var mFilesInfolders = [];
       
       var mRegix = new RegExp(".+\.jsx.*");
       //フォルダ階層100まで調べる。
       labelI:
       for (var i = 0; i < 100; i++) {
            for (var j = 0; j < mFiles.length; j++) {
                var mFile = mFiles[j];
                //ショートカットかどうかチェックする。
                if (mFile.alias) { mFile = mFile.resolve();}  
                if(mFile instanceof  Folder ){
                    mFolders.push(mFile);
                }else{
                    if( mRegix.test( mFile.name ) ){
                        mRstScrs.push(mFile);
                    }
                }
            }
            //フォルダが無くなればリターンする。
            if(mFolders.length === 0 ){break labelI;}
        
            //フォルダ配列をフォルダ内仮配列に展開する。
            for (var j = 0; j < mFolders.length; j++) {
                var mFoldTp = mFolders[j];
                var mFilesInF = mFoldTp.getFiles();
                mFilesInfolders = mFilesInfolders.concat(mFilesInF);
            }
            //フォルダ配列を空にし、次ループ処理用ファイル配列をフォルダ内仮配列にし、フォルダ内仮配列を空にする。
            mFolders = [];
            mFiles = mFilesInfolders;
            mFilesInfolders = [];
        }
    
        return mRstScrs;
    }
    //----------------------------------------------------------------------------------------------------------------------
    //セッティングウインドウ出現関数。
    function mMakeSettingWdw() {
        var mWdw = new Window("palette", "SpookieDiceSettings", undefined, { resizeable: true });
        mWdw.preferredSize = [400, 400];
        mWdw.margins = [5, 5, 5, 5];
        mWdw.spacing = 0;

        mWdw.mPlMain = mWdw.add("Panel { alignment :  [ 'fill','fill' ] , margins : [5, 5, 5, 5] , spacing : 10}");
        mWdw.mGpBt = mWdw.mPlMain.add("group { alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0] , spacing : 4}");
        mWdw.mBtSave = mWdw.mGpBt.add("button {preferredSize : [60, 20], alignment :  [ 'left','top' ] , text:'Save'}");
        mWdw.mCbInv = mWdw.mPlMain.add("checkbox {preferredSize : [120, 20], alignment :  [ 'left','top' ] , text:'Invisible'}");
        mWdw.mCbInv.value = true;
        mWdw.mCbCur = mWdw.mPlMain.add("checkbox {preferredSize : [120, 20], alignment :  [ 'left','top' ] , text:'Move UI to cursor'}");
        mWdw.mCbCur.value = true;
        mWdw.mPlMain.add("statictext { alignment :  [ 'left','top' ],text:'Script Path :'} }");
        mWdw.mEtPath = mWdw.mPlMain.add("editText { alignment :  [ 'fill','top' ]} }");
        mWdw.mEtData = mWdw.mPlMain.add("editText { alignment :  [ 'fill','fill' ], properties:{multiline : true} }");

        mWdw.onResizing = mWdw.onResize = function () { this.layout.resize(); }
        
        //設定を保存する。
        mWdw.mCbInv.onClick = function () {
            app.settings.saveSetting("SpookieDice", "mCbInv", mWdw.mCbInv.value.toString());
        }
        mWdw.mCbCur.onClick = function () {
            app.settings.saveSetting("SpookieDice", "mCbCur", mWdw.mCbCur.value.toString());
        }
        mWdw.mBtSave.onClick = function () {
            //テキスト欄とパスを設定に保存し、現状のグローバルテキストも変える。
            app.settings.saveSetting("SpookieDice", "mAllStr", mWdw.mEtData.text);
            mTjs.mAllStr = mWdw.mEtData.text;
            app.settings.saveSetting("SpookieDice", "mEtPath", mWdw.mEtPath.text);
        }
        
        //あれば設定を読み込んで上書きする。
        //テキストには、最初に読み込んだ、あるいはSaveで変更されたグローバル値を入れる。
        mWdw.mEtData.text = mTjs.mAllStr;
        if (app.settings.haveSetting("SpookieDice", "mEtPath")) {
            mWdw.mEtPath.text = app.settings.getSetting("SpookieDice", "mEtPath");
        }
        if (app.settings.haveSetting("SpookieDice", "mCbInv")) {
            mWdw.mCbInv.value = (app.settings.getSetting("SpookieDice", "mCbInv") === "true");
        }    
        if (app.settings.haveSetting("SpookieDice", "mCbCur")) {
            mWdw.mCbCur.value = (app.settings.getSetting("SpookieDice", "mCbCur") === "true");
        }

        mWdw.center();
        mWdw.show();

        return mWdw;
    }
    //----------------------------------------------------------------------------------------------------------------------
    //mAllStrから[ キー名,スクリプト名] の配列を作る関数。
    function mGetKeyScrNmSets(aAllStr) {
        //文字列を要素 [ キー名 , スクリプト名 ] の配列にする。
        var mStrAry = aAllStr.split("\n");
        for (var i = mStrAry.length-1; i >=0 ; i--) {
           var mKeyScrs = mStrAry[i];
            mKeyScrs = mKeyScrs.split(":");
            if( mKeyScrs.length !== 2 ){ mStrAry.splice(i,1);continue;}
            //一応、前後の空白文字を消しておく。
            var mKey =  mKeyScrs[0];
            var mScrNm = mKeyScrs[1];
            mKey = mKey.replace(/[ |　]+$/, "");
            mScrNm = mScrNm.replace(/^[ |　]+/, "");
             //キーは（アルファベット１文字であれば）大文字にして保存する。
            mKey = mKey.replace(/^[a-z]$/, function (a) { return a.toUpperCase(); });
            mKeyScrs[0] =mKey;
            mKeyScrs[1] = mScrNm;
            mStrAry[i] = mKeyScrs;
        }
        return mStrAry;
    }
    //----------------------------------------------------------------------------------------------------------------------  
}(this));


















