﻿(function (aGbl) {
    //バージョン1.1。
    //----------------------------------------------------------------------------------------------------------------------
    //カーソル位置取得用ウインドウを作る関数。
    function mMakeCursorChkWdw(aScreen) {
        //大きさは仮で、上部分の帯を無くし、透明度を最小にして出現させる。
        var mWdw = new Window("palette", "Spookie", [0, 0, 100, 100], { borderless: true });
        mWdw.opacity = 0.01;
        mWdw.show();

        //AEスクリプトではデフォルトでウインドウの最大サイズ上限がある。
        //（AEのメニューや×ボタンを隠してしまい操作不能になるのを防ぐため？）
        //位置取得範囲は全面にしたいので、上限を無くして全面表示できるようにする。
        //まずは最大サイズをスクリーンサイズまで上げる。
        mWdw.maximumSize = [aScreen.right, aScreen.bottom];
        //それから実際にサイズを大きくする。
        mWdw.bounds = [aScreen.left, aScreen.top, aScreen.right, aScreen.bottom];

        //ウインドウ自体にはカーソル感知領域がないので、同サイズのパネルをウインドウ内に作る。
        mWdw.mP1 = mWdw.add("panel", [0, 0, 100, 100]);
        mWdw.mP1.maximumSize = [aScreen.right, aScreen.bottom];
        mWdw.mP1.bounds = [aScreen.left, aScreen.top, aScreen.right, aScreen.bottom];

        //イベントリスナ―でカーソル感知機能と、検知後の操作を付ける。
        mWdw.addEventListener("mouseover", mApr);

        //という以上のようなウインドウを勝手に作る関数だが、後でウインドウを消す作業があるので
        //この関数を好きな変数に入れてウインドウ自体を操作できるよう、戻り値をウインドウ自体にする。
        return mWdw;
    }
    //----------------------------------------------------------------------------------------------------------------------
    //スクリーンを取得。
    //１画面対応なので配列のゼロ番目だけでよい。
    //（ここを全ての配列要素にすれば、たぶんマルチスクリーン対応になる。その場合は
    //消す作業についても、今はカーソルが感知されたウインドウのみを消しているので、処理の追加が必要）
    var mScreen = $.screens[0];

    //ウインドウ出現処理を、そのウインドウを変数に入れつつ実行。

    var mWdw1 = mMakeCursorChkWdw(mScreen);

    //全画面ウインドウなのでどこかに必ずカーソルが当たり、即、以下の検知後関数が実行される。
    //----------------------------------------------------------------------------------------------------------------------
    //----------------------------------------------------------------------------------------------------------------------
    //カーソル感知後の処理用関数。
    //イベントリスナーの引数として使うので、eでマウス情報が得られる。
    function mApr(e) {
        //この関数はウインドウ出現関数内に入るもので、その時点で『mWdw1』という変数はないが、
        //実際にこの関数が処理されるのはカーソル感知後、つまり『mWdw1』にウインドウを代入した後なので
        //代入した変数名で処理しても問題ない。
        //まずはカーソル感知用ウインドウを消す。
        mWdw1.close();

        //カーソル座標を取得。
        var mCoord = [e.screenX, e.screenY];

        //出現させるスクリプトがあるフォルダを取得。
        var mPath = new File($.fileName);
        var mPath = mPath.parent.fullName + "/(forSpookie)";
        
        var mFile = mGetFile(mPath);
        //ファイルが見つからなければ何もせずリターンする。
        if (mFile === null) { return };

        //スクリプトを実行。　　
        //だいたいのスクリプトは真ん中に出現する。
        $.evalFile(mFile.fullName);

        //AE自体を閉じるまで、一度開いたスクリプトウインドウが保持されるため、
        //開いたことのあるスクリプト一覧を『Window.children』で得られる。
        //（一度閉じたウインドウを操作することはできないみたい）
        //スクリプト実行直後なので、そのスクリプトは配列の一番最後を指定すれば取得できる。
        //なので、ウインドウを閉じずに、それを移動させる。
        Window.children[Window.children.length - 1].location = mCoord;
        
        //付属のSpookieEffecterは移動が目立たないように不透明度を下げているので、上げる。
        //元々上がっているものに指し変わっても、上げる分には問題ない。
        Window.children[Window.children.length - 1].opacity = 1;

    }
    //----------------------------------------------------------------------------------------------------------------------
    //----------------------------------------------------------------------------------------------------------------------
    //フォルダパスからファイルObjを再帰処理で得る関数。
    //ファイルObjのプロパティは以下。
    //fsName　フルパス＆ファイル名。
    //path　フルパス。
    //name　ファイル名。
    function mGetFile(aPth) {
        var mRst = null;
        var mStopOrNot = false;
        var mStdTime = Date.now();

        mExecute(aPth);

        //取得処理が終わり、mStopOrNotがtrueになっていれば１秒タイムアウトなのでnullを返す。
        if (mStopOrNot === true) { return null; }
        return mRst;

        //ファイルObj取得関数。再帰処理で()付き以外のサブフォルダも探す。
        function mExecute(aPth) {
            //もしも指定ミリ秒を超えたら、ストップorNotチェックをtrueにして、リターンする。
            if (mTimeOut(mStdTime, 100) === true) {
                mStopOrNot = true;
                return;
            }
            //getFiles()で得られるものはフルパス名ではなくファイルObj。
            var mFls = new Folder(aPth).getFiles();
            //正規表現（カッコでくくられた文字列）。
            var mExt = ".*\\(.*\\)$";
            //正規表現（jsxを含む）。
            var mExtJsx = ".*\\.jsx.*$";
            for (var i = 0; i < mFls.length; i++) {
                //もしもフルパス先がフォルダ、かつ名前にカッコがなければ、再帰処理でmExecuteを行う。
                if (mFls[i] instanceof Folder
                    && RegExp(mExt).test(mFls[i].name) === false ) {
                    mExecute(mFls[i]);
                    //ファイルの形式が『ファイル』で、『.jsx』が含まれるならば変数に代入する。
                } else {
                    if (mFls[i] instanceof File === true
                        && RegExp(mExtJsx).test(mFls[i].name) === true) {
                        mRst = mFls[i];
                        break;
                    }
                }
            }
        }

        //使用関数。
        //タイムアウト関数。もしも経過時間（ 現在時間 - 引数の基準時間 )が指定ミリ秒を超えたらtrueを返す。
        function mTimeOut(aStdTime, aMilliSec) {
            var mNowTime = Date.now();
            if (mNowTime - aStdTime > aMilliSec) {
                return true;
            }
        }
    }
    //----------------------------------------------------------------------------------------------------------------------
}(this));


















