﻿(function (aGbl) {
    //重いのはmAllEftssの作成時と参照時。ただし、ウインドウ起動時以外は問題ない。
    //mAllEftssが必要なのはeffectsにショートカットを加えるためと、検索でそれを使うため。
    //お気に入りアイテム表示時にはテキスト更新時に保存しておいた設定（あるいは初期設定）のNm,Mn,Scを使えば問題ない。
    //ウインドウ起動時にはmAllEftssを作らず、検索で１文字打った段階で作る。それ以降は作ったものを使う。
    //検索をせずにお気に入りテキストをクリックした場合は、mAllEftssを参照せずにテキスト内容で処理する。
    //ただし、お気に入りテキスト更新時にはmAllEftssを作成＆参照してScのテキストを作る。
    //このときにわざわざmAllEftssを作成するのは、起動して検索せずにテキスト更新しようとしたとき、mAllEftssは作成されていないから。
    
    var mFileName = "FxSpook";
    var mOpc = 0.01;
    var mClose = true;
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    function mCreateUI(aObj) {
        var mPorW = (aObj instanceof Panel) ? aObj : new Window("palette", mFileName, undefined,{ resizeable: true });
        mPorW.preferredSize = [200, 200];
        mPorW.margins = [0, 0, 0, 0];
        mPorW.spacing = 0;
        
        mPorW.mTbp = mPorW.add("panel { type : 'tabbedpanel' , alignment :  [ 'fill','fill' ] , margins : [0, 0, 0, 0],spacing : 0} ");
        mPorW.mTbEft = mPorW.mTbp.add("panel { type : 'tab' , alignment :  [ 'fill','fill' ] , margins : [8, 5, 0, 5], spacing :10, text : 'Effects'} ");
        mPorW.mTbFbl = mPorW.mTbp.add("panel { type : 'tab' , alignment :  [ 'fill','fill' ] , margins : [8, 5, 0, 5], spacing :10, text : 'Favorites'} ");
        
        mPorW.mEtFbl = mPorW.mTbFbl.add("edittext { alignment :  [ 'fill','fill' ],properties:{multiline:true}}");
        
        mPorW.mGpTops = mPorW.mTbEft.add("group { alignment :  [ 'fill','top' ] , margins : [0, 0, 0, 0]}");
        mPorW.mEtWord = mPorW.mGpTops.add("edittext { alignment :  [ 'left','top' ] ,preferredSize : [60,20] , text : '' }");
        mPorW.mEtWord.active = true;
        mPorW.mCbScMch = mPorW.mGpTops.add("checkbox { alignment :  [ 'left','top' ] ,preferredSize : [40,20] , text : 'Sc' }");
        mPorW.mCbScMch.value = true;

        mPorW.mLtNm = mPorW.mTbEft.add("listbox {  alignment :  [ 'fill','fill' ] ,properties:{numberOfColumns: 3 , }}");
        //showHeaders: true,columnTitles: ['', '', '']

        //ショートカット付きエフェクト配列。
        mPorW.mAllEftss = [];
        
        return mPorW;
    }

    //mPnlという名でメインウインドウを作成。
    var mPnl = mCreateUI(aGbl);
    if (mPnl instanceof Window) {
        mPnl.center();
        mPnl.opacity = mOpc;
        mPnl.show();
    } else if (mPnl instanceof Panel) {
        //UIパネルの場合は以下をしないと自動レイアウトされない。
        mPnl.layout.layout(true);
    }

    mPnl.onResizing = mPnl.onResize = function () {
        this.layout.resize();
        //ウインドウサイズを設定に保存する。
        app.settings.saveSetting(mFileName, "mWdwSize", mPnl.size[0].toString() + "," + mPnl.size[1].toString() );
        //app.settings.saveSetting(mFileName, "mWdwSize", "200" + "," + "200" );
    }

    //あれば設定を読み込んで上書きする。
    if (app.settings.haveSetting(mFileName, "mWdwSize")) {
        var mSize = app.settings.getSetting(mFileName, "mWdwSize").split(",");
        mPnl.size = [parseInt(mSize[0]),parseInt(mSize[1])];
    }
    if (app.settings.haveSetting(mFileName, "mCbScMch")) {
        mPnl.mCbScMch.value = (app.settings.getSetting(mFileName, "mCbScMch") === "true");
    }

    //初回ソートをする。検索ワードが無いのでmAllEftssは作成されない。
    //お気に入りテキストの読み込み＆上書きも含む。
    mSortItems();

    //--------------------------------------------------------------------------------------------------------------------------------------------------
    mPnl.mCbScMch.onClick = function (){
        //設定に保存する。
        app.settings.saveSetting(mFileName, "mCbScMch", mPnl.mCbScMch.value.toString() );
        
        mSortItems();
        
        mPnl.mCbScMch.active = true;
        mPnl.mCbScMch.active = false;
        mPnl.mEtWord.active = true;
        
    }
    
    
    mPnl.mTbp.addEventListener ("mousedown", mMd);
    function mMd(e){
        if(e.target === mPnl.mTbp ){
            if(mClose){ mPnl.close();}
        }
    }

    mPnl.mEtFbl.onChange = function (){
        if(mPnl.mTbp.selection.text === "Effects" ){
            mPnl.mEtFbl.active = true;
            mPnl.mEtFbl.active = false;
            mPnl.mEtWord.active = true;
        }
    }
    
    //ウインドウを閉じたら、お気に入りテキストと名前、オリジナルショートカットを設定に保存する。
    /*
    mPnl.onClose = function (){
        app.settings.saveSetting(mFileName, "mEtFbl", mPnl.mEtFbl.text);
        var mItms = mPnl.mLtNm.items;
        var mDisps = [];
        var mOglScs = [];
        for(var i= 0; i<mItms .length; i++){
            var mItm = mItms[i];
            mDisps.push( mItm.text );
            var mSc = mItm.subItems[0];
            if( mSc === undefined ){ mSc = "";}
            mOglScs.push( mSc );
        }
        var mDispsStr = mDisps.join(",");
        var mOglScsStr = mOglScs.join(",");
        app.settings.saveSetting(mFileName, "mDisps", mDispsStr);
        app.settings.saveSetting(mFileName, "mOglScs",mOglScsStr);
    }
    */
    
    //タブを変更したら、お気に入り名とオリジナルショートカットを設定に保存してリスト更新する。
    mPnl.mTbp.onChange = mPnl.onClose = function (){
        i//f(mPnl.mTbp.selection.text !== "Effects" ){ return;}
            
        var mStr = mPnl.mEtFbl.text;
        //テキストはそのまま保存する。
        app.settings.saveSetting(mFileName, "mEtFbl", mStr);
        
        //お気に入り名とオリジナルショートカットも保存する。
        //まずはテキストを改行で分ける。
        var mDisps = [];
        var mOglScs = [];
        var mStrSplts = mStr.split("\n");
        for(var i= 0; i<mStrSplts.length; i++){
            var mStrTp = mStrSplts[i];
            if( mStrTp === "" || (/^( |　)+$/.test(mStrTp) ) ){ continue;}
            //１行をコロンで分け、コロン前後の空白を無くす。
            var mStrNmScs = mStrTp.split(":");
             for(var j= 0; j<mStrNmScs.length; j++){
                 var mStrNm =mStrNmScs[j];
                 if( j === 0 ){ mStrNmScs[j] = mStrNm.replace (/( |　)+$/, "");}
                 else{ mStrNmScs[j] = mStrNm.replace (/( |　)+/g, "");}
             }
            //２つあればそれぞれお気に入り名とオリジナルショートカット配列に入れる。
            //１つならばオリジナルショートカット配列には” * ”を入れておく。
            if( mStrNmScs.length === 1 ){ mStrNmScs.push("");}
            mDisps.push(mStrNmScs[0]);
            mOglScs.push(mStrNmScs[1]);
        }

        var mDispsStr = mDisps.join(",");
        var mOglScsStr = mOglScs.join(",");
        app.settings.saveSetting(mFileName, "mDisps", mDispsStr);
        app.settings.saveSetting(mFileName, "mOglScs",mOglScsStr);
        
        //更新を設定からのものにするため、検索ワードを空にしておく。
        mPnl.mEtWord.text = "";
        mSortItems();
        
        mPnl.mEtFbl.active = true;
        mPnl.mEtFbl.active = false;
        mPnl.mEtWord.active = true;
    }

    mPnl.mEtWord.onChanging = function(){
        mSortItems();
    }

    mPnl.mLtNm.onChange = function (){
        mAddEft();
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    function mAddEft( aItemTxt ) {
        app.beginUndoGroup("AddEffect");
       
       var mEftNm = "";
        if(aItemTxt === undefined){ mEftNm = mPnl.mLtNm.selection.text;}
        else{var mEftNm = aItemTxt;}
        
        if( mEftNm === "" ){
            if(mClose){ mPnl.close();}
             app.endUndoGroup();
            return;
        }
    
        app.activeViewer.setActive();
        var mAi = app.project.activeItem;
        if( mAi === null ){
              if(mClose){ mPnl.close();}
            app.endUndoGroup();
            return;
        }
        var mSls = mAi.selectedLayers;
        if(mSls.length === 0){
            if(mClose){ mPnl.close();}
            app.endUndoGroup();
            return;
        }

        for(var i= 0;i<mSls.length; i++){
            //app.executeCommand(app.findMenuCommandId(mItem.text));
            mSls[i].effect.addProperty(mEftNm);
        }
        
        //ウインドウを閉じる。
        if(mClose){ mPnl.close();}
        
        app.endUndoGroup();
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------  
    function mSortItems() {
        //メイン部分をTryしてエラーが出たらアラートを出す。
        //mSortMain();
        try {
            mSortMain();
        } catch (err) {
            alert(err.message + "\n" + err.line);
            //+"\n" +err.fileName
        }
        //-------------------------------------------------------------------------
        function mSortMain() {
            var mWord = mPnl.mEtWord.text;
            //初期設定。
            mPnl.mEtFbl.text = "フラクタルノイズ : Z";
            var mOglNms = ["フラクタルノイズ"];
            var mOglScs = ["Z"];
            //あれば設定を読み込む。
            if (app.settings.haveSetting(mFileName, "mEtFbl")) {
                mPnl.mEtFbl.text = app.settings.getSetting(mFileName, "mEtFbl");
                var mOglNms = app.settings.getSetting(mFileName, "mDisps" ).split(",");
                var mOglScs = app.settings.getSetting(mFileName, "mOglScs").split(",");
            }

            //検索ワードが無いときは設定からディスプレイネームとオリジナルショートカットを取得する。
            if(mWord.length === 0){
                mPnl.mLtNm.removeAll();
                for(var i= 0; i<mOglNms.length; i++){
                    var mItm = mPnl.mLtNm.add("item",mOglNms[i]);
                    mItm.subItems[0].text = mOglScs[i];
                }
                return;
            }
            //-------------------------------------------------------------------
            //検索ワードがある場合。
            //ショートカット検索チェックの有り無しで分岐させる。
            if( mPnl.mCbScMch.value ){
                //デフォルトショートカットを見ていく前に、オリジナルショートカットにマッチするかを見て、合えば適用する。
                //オリジナルショートカットが長い場合、その前にデフォルトショートカットにマッチしたらそれが適用されることに注意。
                for(var i= 0; i<mOglNms.length; i++){
                    var mOglSc =  mOglScs[i];
                    if(  mOglSc === "" ){ continue;}
                    var mRegixSc = new RegExp(mOglSc,"i");
                    if( mRegixSc.test( mWord ) ){
                        mAddEft( mOglNms[i] );
                        return;
                    }
                }

                //ここで初めて（無ければ）ショートカット付きエフェクト配列を作る。
                if( mPnl.mAllEftss.length === 0 ){
                    var mAllEftss = mEffectSortAddSc();
                    mPnl.mAllEftss = mAllEftss;
                }else{
                    var mAllEftss = mPnl.mAllEftss;
                }
                var mWordF = mWord[0];
                var mPartEfts = [];
                if( mWordF === " "){
                    mPartEfts = mAllEftss[ 26 ];
                }else{
                    //aは97。
                    var mCharCodeZero = mWordF.charCodeAt(0) - 97;
                    if( 0 <= mCharCodeZero && mCharCodeZero <= 25 ){
                        mPartEfts = mAllEftss[mCharCodeZero];
                    //もしもアルファベットかスペース以外ならば最後の配列にする。
                    }else{
                         mPartEfts = mAllEftss[ 27 ];
                     }
                 }
                if(mPartEfts.length === 0){ return;}

                //1文字目の場合はアルファベットGpを全て表示し、2文字目以降は正規表現でソートする。
                var mRstEfts = [];
                if( mWord.length === 1 ){
                    mRstEfts = mPartEfts.slice();
                }else{
                    var mRegix = new RegExp( "^" + mEcpStr(mWord )+ ".*");
                    for(var i= 0; i <mPartEfts.length ; i++ ){
                        var mEft = mPartEfts[i];
                         if(mRegix.test( mEft.mSc ) ){
                            mRstEfts.push( mEft );
                        }
                    }
                }
            }else{
                //名前検索、前方一致でエフェクトを得る。ここで初めて（無ければ）ショートカット付きエフェクト配列を作る（関数に含まれている）。
                var mRstEfts = mGetEfts(mWord ,true);
            }
            //-------------------------------------------------------------------
            //更新する。
            mPnl.mLtNm.removeAll();
            for(var i= 0;i<mRstEfts.length; i++){
                var mEft = mRstEfts[i];
                var mItem = mPnl.mLtNm.add("item",mEft.displayName);//mDisp "mSc"
                mItem.subItems[0].text = mEft.mSc.toUpperCase();
                //名前検索の場合はマッチネームも表示する。
                if( !(mPnl.mCbScMch.value) ){
                    mItem.subItems[1].text = mEft.matchName;
                }
            }
            mPnl.layout.layout(true);
        
            //SC検索の場合は表示アイテムが１つになったらエフェクト適用する。
            if( mPnl.mCbScMch.value ){ 
                if( mPnl.mLtNm.items.length === 1 ){ mAddEft( mPnl.mLtNm.items[0].text );}
            }
        }
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //正規表現記号をエスケープする関数。
    function mEcpStr(aStr) {
        return aStr.replace(/[.*+\-?^${}()|[\]\\]/g, "\\$&");
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    function mEffectSortAddSc(){
        //app.effectsは代入した時点でコピーになるのでそのまま使ってよい。
        var mEftsSort = app.effects;
        //var mEftsSort = [];
        //まずはカテゴリーの無いもの、_Obsoleteのものを無くす。
        //表示名にobsoleteが付いているものはカテゴリー_Obsoleteなので、表示名処理はいらない。
        for(var i= mEftsSort.length-1; i >=0 ; i--){
            var mEft = mEftsSort[i];
            if(mEft.category === "" || mEft.category === "_Obsolete" ){
                mEftsSort.splice(i,1);
            }
        }

        //マッチネームから先頭の認識子を無くしたものを要素として加える。
        //以下はプラグイン判別用の正規表現。その次のリプレイスとは別。
        var mRegixExtStr = "^(ADBE |APC |VISINF |CC |CS |CS|Mettle SkyBox |"+
        "CINEMA 4D Effect|Cryptomatte|EXtractoR|IDentifier|ISL MochaShapeImporter|Keylight|mochaAECC|Red Giant GrowBounds).*";
        var mRegixExt = new RegExp(mRegixExtStr);
        var mRegixExtDel =  new RegExp("^ADBE |^APC |^VISINF |^CC |^CS |^CS");

        for(var i= 0; i < mEftsSort.length; i++){
            var mEft = mEftsSort[i];
            var mEftMn = mEft.matchName;
            //プラグインにはスペースを付けておく。
            if( !(mRegixExt.test( mEftMn ))){
                mEftMn = " " + mEftMn;
            }else{
                mEftMn =mEftMn.replace(mRegixExtDel,"");
            }
            //もともと認識子抜きのマッチネームが2文字しかない場合、3文字目省略処理の時用にスペースを入れておく。
            if(mEftMn.length === 2 ){ mEftMn = mEftMn + " ";}
            //全て小文字にする。
            mEft.mMnWoExt = mEftMn.toLowerCase();
        }  

        //ショートカット名を加える。
        //まずはアルファベット別で分ける。配列個数は26 + スペース用 + その他（数字）用。
         var mEftss = [[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[]];
         for(var i= 0; i < mEftsSort.length; i++){
             var mEft = mEftsSort[i];
            var mEftMnF = mEft.mMnWoExt[0];
            if(mEftMnF === " "){
                mEftss[ 26 ].push( mEft );
            }else{
                //aは97。
                var mCharCodeZero = mEftMnF.charCodeAt(0) - 97;
                if( 0 <= mCharCodeZero && mCharCodeZero <= 25 ){
                    mEftss[ mCharCodeZero ].push( mEft );
                //もしもアルファベットとスペース以外があれば最後に入れる。
                }else{
                    mEftss[ 27 ].push( mEft );
                }
            }
        }

        //アルファベットGpごとに処理する。
        for(var i= 0; i < mEftss.length; i++){
            var mEfts = mEftss[i];
            if( mEfts.length === 0 ){ continue;}
            
            //まずは3文字にする。
             for(var j= 0; j < mEfts.length; j++){
                var mEft = mEfts[j];
                mEft.mSc = mEft.mMnWoExt.slice(0,3);
            }
           
            //識別子無しマッチネームでソートしておく。
            function mSort (a,b){
                if (a.mMnWoExt < b.mMnWoExt) {return -1;}
                else if (a.mMnWoExt > b.mMnWoExt) {return 1;}
                else {return 0}
            }
            mEfts.sort( mSort );
            
            //ナンバリングで最新版があるものは旧バージョンを消す。
            for(var j= 0; j < mEfts.length-1; j++){
                var mEftMnNow = mEfts[j].matchName;
                var mEftMnNex = mEfts[j+1].matchName;
                if( isNaN(mEftMnNow[mEftMnNow.length-1]) ){ continue ;}
                if( isNaN(mEftMnNex[mEftMnNex.length-1]) ){ continue ;}
                if( mEftMnNow.slice(0, mEftMnNow.length-1) === mEftMnNex.slice(0, mEftMnNex.length-1) ){
                    mEfts[j] = null;
                }
            }
            for(var j= mEfts.length-1; j >=0 ; j--){
                if( mEfts[j] === null){ mEfts.splice(j,1);}
            }
            
            //SCがかぶっているものへの処理。
            //同アルファベットGpに1つしかない場合はショートカットが３文字のままになるが、表示されないので問題なしとする。
            if( mEfts.length >= 2 ){
                //まずはかぶっているものを集める。
                //同アルファベットGp内で、3文字ショートカットがかぶっているものの要素配列を作り、１つの配列に集める。
                function mIfFunc( a,b ){ return( a.mSc === b.mSc );}
                var mSamess = mSortAryToArys(mEfts, mIfFunc);
     
                //2文字目が他とかぶっていないものは２文字にする。
                //2文字目がかぶっているGp配列を得る。[Gps,Gps...]という3重配列となる。
                function mIfFunc2( a,b ){ return( a[0].mSc[1] === b[0].mSc[1] );}
                var mSecCharSamesss = mSortAryToArys(mSamess, mIfFunc2);
                for(var j= 0; j < mSecCharSamesss.length; j++){
                    var mSecCharSamess = mSecCharSamesss[j];
                    if( mSecCharSamess.length === 1 ){
                        for(var k= 0; k < mSecCharSamess.length; k++){
                            var mSecCharSames = mSecCharSamess[k];
                            for(var l= 0; l < mSecCharSames.length; l++){
                                var mEft = mSecCharSames[l];
                                mEft.mSc = mEft.mSc.slice(0,mEft.mSc.length-1);
                            }
                        }
                    }
                }

                //配列内の要素配列について、入っているものが１つならば何もせず、２つ以上ならば番号を付ける。
                //番号が10以上あると1ケタが自動発動しなくなるので、10以降はアルファベットにする。
                for(var j= 0; j < mSamess.length; j++){
                    var mSames = mSamess[ j ];
                    if( mSames.length >= 2 ){
                        for(var k= 0; k < mSames.length; k++){
                            var mNum = k + 1;
                            //aは97。
                            if( mNum >=10 ){ mNum = String.fromCharCode(87 + mNum )};
                            mSames[k].mSc = mSames[k].mSc + mNum;
                        }
                    }
                }
            }
        }
        return mEftss;
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //ディスプレイネームからエフェクト（ショートカット付き）を得る関数。名前検索時に使う。
    function mGetEfts(aDispNm){
        //どちらも起動時には行わないのと、検索ワードを入れずにエフェクト検索したりテキスト更新するとmAllEftssが無いので作る。
        if( mPnl.mAllEftss.length === 0 ){
            var mEftss = mEffectSortAddSc();
            mPnl.mAllEftss = mEftss;
        }else{
            var mEftss = mPnl.mAllEftss;
        }

        //mEftssを１つの配列にまとめる。
        var mAllEfts = [];
        for(var i= 0; i<mEftss.length; i++){
            var mEfts = mEftss[i];
            for(var j= 0; j<mEfts.length; j++){
                var mEft = mEfts[j];
                mAllEfts.push( mEft );
            }
        }
    
        var mWord = aDispNm;
        var mRstEfts = [];
        var mRegixSch = new RegExp("^" + mWord + ".*","i");
        for(var i= 0; i<mAllEfts.length; i++){
            var mEft = mAllEfts[i];
            if( mRegixSch.test( mEft.displayName )){ mRstEfts.push( mEft );}
        }
        return mRstEfts;
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //順番ソートされている配列を、条件関数で振り分けした要素配列を持つ配列返す関数。
    function mSortAryToArys(aAry, aIfFunc){
        var mAry = aAry;
        var mIfFunc = aIfFunc;

        var mRstArys = [ [mAry[0]] ];
        for(var i= 1; i < mAry.length; i++){
            var mEmt = mAry[i];
            var mTgtAry = mRstArys[mRstArys.length-1];
            if( mIfFunc( mTgtAry[mTgtAry.length-1] , mEmt ) ){
                mTgtAry.push( mEmt );
            }else{
                mRstArys.push([mEmt]);
            }
        }
        return mRstArys;
    }
    //---------------------------------------------------------------
    //上記関数に使う条件関数のひな型。
    function mIfFuncTp(a,b){
        if( a === b ){ return true;}
        else{ return false;}
    }
    //-------------------------------------------------------------------------------------------------------------------------------------------------- 
})(this);


















