﻿(function (aGbl) {
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    function mCreateUI(aObj) {
        var mPorW = (aObj instanceof Panel) ? aObj : new Window("palette", "Sequwise", undefined);
        mPorW.preferredSize = [200, 200];
        mPorW.margins = [10, 10, 10, 10];
        mPorW.spacing = 30;
        mPorW.orientation = "row";
        
        mPorW.mGpBt = mPorW.add("group { alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0]}");
        mPorW.mBt1 = mPorW.mGpBt.add("button { preferredSize : [60,20]  , text : 'Sequence' ,alignment :  [ 'left','top' ] }");

        mPorW.mGpOpt = mPorW.add("group { orientation : 'column' , alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0]}");
        mPorW.mGpOpt.spacing = 5;

        mPorW.mGpOptNums = mPorW.mGpOpt.add("group { orientation : 'column' , alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0]}");
        mPorW.mGpOptNums.spacing = 0;

        mPorW.mGpSec1 = mPorW.mGpOptNums.add("group {alignment :  [ 'left','top' ], margins : [0, 0, 0, 0]}");
        mPorW.mGpSec1.spacing = 0;
        mPorW.mSt1 = mPorW.mGpSec1.add("staticText { preferredSize : [-1,20] , text : 'Frame :' , alignment :  [ 'left','top' ] }");
        mPorW.mEt1 = mPorW.mGpSec1.add("EditText { preferredSize : [60,20] , text : '3' , alignment :  [ 'left','top' ] }");

        mPorW.mGpSec2 = mPorW.mGpOptNums.add("group {alignment :  [ 'left','top' ] ,margins : [0, 0, 0, 0]}");
        mPorW.mGpSec2.spacing = 0;
        mPorW.mSt2 = mPorW.mGpSec2.add("staticText { preferredSize : [-1,20] , text : 'Layers :' , alignment :  [ 'left','top' ] }");
        mPorW.mEt2 = mPorW.mGpSec2.add("EditText { preferredSize : [60,20] , text : '1' , alignment :  [ 'left','top' ] }");

        mPorW.mGpOpt.add("panel { alignment :  [ 'fill','top' ] }");

        mPorW.mCb1 = mPorW.mGpOpt.add("checkbox { preferredSize : [-1,20] , text : 'At Indicator' ,alignment : [ 'left','top' ] }");
        mPorW.mChkSfl = mPorW.mGpOpt.add("checkbox { preferredSize : [-1,20] , text : 'Shuffle' ,alignment : [ 'left','top' ] }");  
        mPorW.mChkRng = mPorW.mGpOpt.add("checkbox { preferredSize : [-1,20] , text : 'Frame is Range' ,alignment : [ 'left','top' ] }");  
        
        return mPorW;
    }

    //mPnlという名でメインウインドウを作成。
    var mPnl = mCreateUI(aGbl);
    if (mPnl instanceof Window) {
        mPnl.center();
        mPnl.show();
    } else if (mPnl instanceof Panel) {
        //UIパネルの場合は以下をしないと自動レイアウトされない。
        mPnl.layout.layout(true);
    }

    //-------------------------------------------------------------------------
    //セッティングパート。

    //セクション名。一括読み書き関数がインデックス管理しているので、
    //バージョンアップのときにパーツ数が変わったら手動で設定を消すor違う名前を付ける。
    mPnl.mSecName = "Sequwise";

    //全てのパーツの配列を得る＆パーツの要素にインデックス文字列を加える。
    mPnl.mEmts = mGetElementsAndAddKeyIdx(mPnl);

    //（もしもあれば）全ての設定を読み込む。対象はチェックボックス、ラジオボタン、エディットテキスト。
    mGetAllSettings(mPnl.mEmts, mPnl.mSecName);

    //全てのパーツに、変化したらセーブするイベントを加える。対象はチェックボックス、ラジオボタン、エディットテキスト。
    //ListenerではなくOnイベントのため、この関数の行の前に書いてあるOnイベントを上書きすることに注意。
    mAddSaveEventOn(mPnl.mEmts, mPnl.mSecName);

    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //メイン処理パート。
    mPnl.mBt1.onClick = function () {
        var mAi = app.project.activeItem;
        var mSls = mAi.selectedLayers;

        var mOfs = parseInt(mPnl.mEt1.text);
        var mMas = parseInt(mPnl.mEt2.text);
        if (isNaN(mOfs) || isNaN(mMas)){ return ;}
        
        //全選択レイヤー数をまとまり数で割った数。余りのぶんもレイヤーがあるので切り上げにする。
        var mTtlNum = Math.ceil( mSls.length / mMas );
        
        //フレームを範囲とするチェックがあれば、mOfsを変える。
        if( mPnl.mChkRng.value ){
            mOfs = mOfs / (mTtlNum-1);
        }


        //-------------------------------------------------------------------------
        //startTime はレイヤー頭の絶対時間。
        //inPointは時間調整した頭の絶対時間。
        //inPointを変えると内容がズレないで頭だけ変わるのでstartTimeを移動する。
        app.beginUndoGroup("Sequence");

        //レイヤー数がゼロならば結果が何も起きないので、単純にリターンする。
        if (mMas === 0) { return; }

        //インジケータチェックがあれば現在時間を基準にし、そうでなければ最初に選択したレイヤーのインポイントを基準とする。
        if( mPnl.mCb1.value ){ var mInitT = mAi.time;}
        else{var mInitT = mSls[0].inPoint;}

        //まずは各レイヤーのスタートタイムを揃える。
        for (var i = 0; i < mSls.length; i++) {
            var mSl = mSls[i];
            mSl.startTime = mInitT;
        }

        //インポイントがズレていた場合用に、スタートタイムを移動させてインポイントを揃える。
        //これで各レイヤーの開始時点が揃う。
        for (var i = 0; i < mSls.length; i++) {
            var mSl = mSls[i];
            var mInP = mSl.inPoint;
            var mSttT = mSl.startTime;
            var mDifT = mInP - mSttT;
            mSl.startTime = mSttT - mDifT;
        }

        //ずらす用時間の配列を作る。
        var mOfss = [];
        for (var i = 0; i < mTtlNum; i++) {
            mOfss.push( mOfs * i );
        }
    
        //シャッフルチェックがあればシャッフルする。
        if( mPnl.mChkSfl.value ){ mShuffle( mOfss );}

        //実際に値を適用する。
        var mDur = mAi.frameDuration;
        for (var i = 0; i < mSls.length; i++) {
            var mSl = mSls[i];
            var mSttT = mSl.startTime;
            var mOfs = mOfss[ Math.floor(i / mMas) ] * mDur;
            mSl.startTime = mSttT + mOfs;
        }

        //---------------------------------------------------------------
        app.activeViewer.setActive();
        
        app.endUndoGroup();
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //セッティング関連関数。各パーツのパネルorウインドウ内でのインデックスで管理する。
    //パネルの全てのパーツを再帰処理で抜き出し、各パーツに.mKeyという番号要素を加える関数。
    function mGetElementsAndAddKeyIdx(aPnl) {
        //再帰処理で全パーツを抜き出す。
        var mAllElmt = [];
        mGet(aPnl);
        function mGet(aObj) {
            //childrenにはパーツ以外含まれないので分岐処理はいらない。
            for (var i = 0; i < aObj.children.length; i++) {
                //タブドパネルもタブも元コンストラクタはパネルなので、この記述のみでよい。
                if (aObj.children[i] instanceof Group === true
                    || aObj.children[i] instanceof Panel === true) {
                    mGet(aObj.children[i]);
                } else {
                    mAllElmt.push(aObj.children[i]);
                }
            }
        }

        //抜き出したパーツに番号を付ける。
        for (var i = 0; i < mAllElmt.length; i++) {
            mAllElmt[i].mKey = i.toString();
        }

        return mAllElmt;

    }
    //-------------------------------------------------------------------------
    //全てのパーツに、変化したらセーブするイベントを加える関数。対象はチェックボックス、ラジオボタン、エディットテキスト。
    //ListenerではなくOnイベントのため、この関数の行の前に書いてあるOnイベントを上書きすることに注意。
    //逆に、この関数を上書きしたい場合はこの関数の後にOnイベントを書く。
    function mAddSaveEventOn(aElmts, aSecName) {
        var mElmts = aElmts;
        var mSecName = aSecName;
        for (var i = 0; i < mElmts.length; i++) {
            var mElmt = mElmts[i];
            if (mElmt instanceof Checkbox || mElmt instanceof RadioButton) {
                mElmt.onClick = function () { app.settings.saveSetting(mSecName, this.mKey, this.value); }
            } else if (mElmt instanceof EditText) {
                mElmt.onChange = function () { app.settings.saveSetting(mSecName, this.mKey, this.text); }
            }
        }
    }

    //-------------------------------------------------------------------------
    //（もしもあれば）全ての設定を読み込む関数。対象はチェックボックス、ラジオボタン、エディットテキスト。 
    function mGetAllSettings(aElmts, aSecName) {
        var mElmts = aElmts;
        var mSecName = aSecName;
        for (var i = 0; i < mElmts.length; i++) {
            var mElmt = mElmts[i];
            if (app.settings.haveSetting(mSecName, mElmt.mKey) === true) {
                var mSetting = app.settings.getSetting(mSecName, mElmt.mKey);
                //チェックボックスとラジオボタンの場合は、設定には文字列が入っているので真偽値に変換する。
                if (mElmt instanceof Checkbox || mElmt instanceof RadioButton) {
                    mElmt.value = (mSetting === "true");
                    //エディットテキストはそのまま文字列を入れる。
                } else if (mElmt instanceof EditText) {
                    mElmt.text = mSetting;
                }
            }
        }
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //シャッフル関数。
    //後ろから、その前のもののどれかと入れ替えていく。
    function mShuffle( aAry ) {
        for ( var  i = aAry.length-1; i >=1 ; i-- ) {
            //0 ～ i （ i は含まない）のランダムな番号。+1してあるので 0 ～ i となる。 
            var mRdmIdx = Math.floor( (i+1) * Math.random());
            //ループナンバー i  の前にある、ランダム番号にある要素。
             var mRdItm = aAry[mRdmIdx];
             //ループナンバー i  の要素。
             var mTgtItm = aAry[i];
             //２つを入れ替える。
             aAry[i] = mRdItm;
             aAry[mRdmIdx] = mTgtItm;
        }
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
})(this);