﻿(function (aGbl) {
    //----------------------------------------------------------------------------------------------------------------------
    function mCreateUI(aObj) {
        var mPorW = (aObj instanceof Panel) ? aObj : new Window("palette", "Renamus", undefined);
        mPorW.preferredSize = [200, 200];
        mPorW.margins = [10, 10, 10, 10];
        mPorW.spacing = 5;
        
        mPorW.mGpMain = mPorW.add("group {orientation : 'row', alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0], spacing : 10}");  
        
        mPorW.mGpBts = mPorW.mGpMain.add("group {orientation : 'column', alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0], spacing : 0}");
        mPorW.mBtRename = mPorW.mGpBts.add("button { preferredSize : [60,20] , alignment :  [ 'left','top' ],  text : 'Rename' }");
        
        mPorW.mGpChk = mPorW.mGpMain.add("group {orientation : 'column', alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0], spacing : 0}");
        mPorW.mGpStr = mPorW.mGpChk.add("group {orientation : 'row', alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0], spacing : 0}");
        mPorW.mEtName = mPorW.mGpStr.add("edittext { preferredSize : [50,20] , alignment :  [ 'left','top' ],text : 'name'}");
        mPorW.mEtNum = mPorW.mGpStr.add("edittext { preferredSize : [50,20] ,  alignment :  [ 'left','top' ],text : '01'}");
        
        mPorW.mGpSpc = mPorW.mGpChk.add("group {orientation : 'stack', alignment :  [ 'left','center' ] , margins : [0, 0, 0, 0], spacing : 0}");
        mPorW.mGpSpc.add("statictext { preferredSize : [20,20] , alignment :  [ 'left','top' ],text : ''}");
        mPorW.mGpSpc.add("panel { preferredSize : [100,1] , alignment :  [ 'left','center' ]}");
        
        
        mPorW.mCbLrN = mPorW.mGpChk.add("checkbox { preferredSize : [-1,20] , alignment :  [ 'left','top' ], text : 'Layer Name' }");
        mPorW.mCbLrN.value = true;
        mPorW.mCbScN = mPorW.mGpChk.add("checkbox { preferredSize : [-1,20] , alignment :  [ 'left','top' ], text : 'Source Name'}");
        mPorW.mCbLrN.value = true;
        
        return mPorW;
    }

    //mPnlという名でメインウインドウを作成。
    var mPnl = mCreateUI(aGbl);
    if (mPnl instanceof Window) {
        mPnl.center();
        mPnl.show();
    } else if (mPnl instanceof Panel) {
        //UIパネルの場合は以下をしないと自動レイアウトされない。
        mPnl.layout.layout(true);
    }
    //----------------------------------------------------------------------------------------------------------------------
    //メインパート。
    mPnl.mBtRename.onClick = function () {
        app.beginUndoGroup("Rename");
        
        var mIsLyrCulc = null;
        //アクティブアイテムがヌルでない場合、パネルアイテム1つ選択状態なのかアクティブコンポ選択状態なのか分からないので、
        //いったんアクティブアイテムのselectedを外して再取得する。
        //パネルアイテム1つ選択状態ならば、再取得アクティブアイテムはヌルとなり、ノットイコールとなる。
        //アクティブコンポ選択状態ならば、selectedとは無関係で再取得できるので、イコールとなる。
        //結果、パネルアイテム1つ選択状態であればアイテム処理、アクティブコンポ選択状態ならばレイヤー処理する。
        var mAi = app.project.activeItem;
        if( mAi !== null ){
            var mIsSel = mAi.selected;
            mAi.selected = false;
            var mAiTp = app.project.activeItem;
            mIsLyrCulc = (mAi === mAiTp);
            mAi.selected = mIsSel;
        //アクティブアイテムがヌルならば、パネルアイテム複数選択（あるいは何も選択していない）なのでアイテム処理をする。
        }else{
            mIsLyrCulc = false;
        }

        var mNameStr = mPnl.mEtName.text;
        var mNumStr = mPnl.mEtNum.text;
        //ケタ数。
        var mDgt = mNumStr.length;
        //数字を入れるか否か。ケタ数ゼロなら入れない。
        var mHasNum = ( mDgt !== 0 );
        
        //パディング数。先頭がゼロかつ１ケタでなければ、そのケタにする。
        var mPdNum = null;
        if( mNumStr[0] === "0" && mDgt >= 2 ){ mPdNum = mDgt;}

        //パディング抜きの最初の数字。先頭のゼロを抜いていく。
        var mFstNum = "0";
        var mRegExp = new RegExp("[^0]+.*$");
        var mMth = mNumStr.match( mRegExp );
        if( mMth !== null ){ mFstNum = mMth[0];}
        //見つからなかった場合（ゼロ１つが入っている、欄に文字が入っていない、ゼロが複数入っている）、ゼロが入る。
        //欄に文字が入っていない場合、mHasNumでチェックしてあるのでこの数字は使わない。
        //ゼロが１つ入っている、あるいは複数入っている場合、パディング数も最初の数字も合っているので問題ない。
        mFstNum = Number(mFstNum);
        
        //プロジェクトパネルの場合。
        if (!(mIsLyrCulc)) {
            mSetStrs(app.project.selection);
        //アクティブアイテム（コンポを想定）の場合。
        } else {
            //レイヤーネームチェックがtrueであれば（ソースネームチェックがどちらであれ）レイヤーネームを変える。
            if (mPnl.mCbLrN.value) { mSetStrs(app.project.activeItem.selectedLayers);}
            //ソースネームチェックがtrueであれば（レイヤーネームチェックがどちらであれ）ソースネームを変える。
            if (mPnl.mCbScN.value) { mSetStrsSrc(app.project.activeItem.selectedLayers);}
        }
        app.endUndoGroup();
        
        //以下、使用関数。
        //-------------------------------------------------------------
        //-------------------------------------------------------------
        //リネーム用関数。
        function mSetStrs(aAry){
            var mSel = aAry;
            //ケタ数ゼロの場合、数字を入れない。
            if (!(mHasNum)) {
                for (var i = 0; i < mSel.length; i++) { mSel[i].name = mNameStr; }
            //パディング用ケタ数がヌルの場合、パディングせずに数字を増やしていく。
            } else if (mPdNum === null) {
                for (var i = 0; i < mSel.length; i++) { mSel[i].name = mNameStr + (mFstNum + i); }
            //ケタ数1以外の場合。選択アイテム（ナンバーi）の名前を『文字列』＋『最初の番号+ i をパディングしたもの』にする。
            } else {
                for (var i = 0; i < mSel.length; i++) { mSel[i].name = mNameStr + mPd(mFstNum + i, mPdNum); }
            }
        }
        //---------------------------------------------------------------
        function mSetStrsSrc(aAry){
            var mSel = aAry;
            if (!(mHasNum)) {
                for (var i = 0; i < mSel.length; i++) {
                    //ソースが無い場合は処理を飛ばす。
                    if (mSel[i].source === null) { continue; }
                    mSel[i].source.name = mNameStr;
                }
            } else if (mPdNum === null) {
                for (var i = 0; i < mSel.length; i++) {
                    if (mSel[i].source === null) { continue; }
                    mSel[i].source.name = mNameStr + (mFstNum + i);
                }
            } else {
                for (var i = 0; i < mSel.length; i++) {
                    if (mSel[i].source === null) { continue; }
                    mSel[i].source.name = mNameStr + mPd(mFstNum + i, mPdNum);
                }
            }
        }
        //---------------------------------------------------------------
        //パディング用関数。
        function mPd(aNum, aLgt) {
            return ("0000000000" + aNum).slice(-aLgt);
        }
    }
    //----------------------------------------------------------------------------------------------------------------------
}(this));