﻿(function (aGbl) {
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    function mCreateUI(aObj) {
        var mPorW = (aObj instanceof Panel) ? aObj : new Window("palette", "QuartzJump", undefined);
        mPorW.preferredSize = [300, 40];
        mPorW.margins = [10, 10, 10, 10];
        mPorW.spacing = 5;
        mPorW.orientation = "row";

        mPorW.mBtBack = mPorW.add("button { preferredSize : [80,20]  , text : '<' }");
        mPorW.mBtFor = mPorW.add("button { preferredSize : [80,20], text : '>' }");

        mPorW.mGpFrm = mPorW.add("group { alignment :  [ 'fill','top' ] , margins : [0, 0, 0, 0]}");
        mPorW.mGpFrm.spacing = 0;
        mPorW.mEtFrm = mPorW.mGpFrm.add("EditText { preferredSize : [80,20] , text : '' }");
        mPorW.mInitF = "0:00:00:24";
        mPorW.mEtFrm.text = mPorW.mInitF;
        mPorW.mBtFrm = mPorW.mGpFrm.add("button { preferredSize : [20,20] , text : 'TC' }");

        return mPorW;
    }

    //mPnlという名でメインウインドウを作成。
    var mPnl = mCreateUI(aGbl);
    if (mPnl instanceof Window) {
        mPnl.center();
        mPnl.show();
    } else if (mPnl instanceof Panel) {
        //UIパネルの場合は以下をしないと自動レイアウトされない。
        mPnl.layout.layout(true);
    }
    //-------------------------------------------------------------------------
    //セッティングパート。

    //設定のキーを作る。
    mPnl.mPref1 = {};
    mPnl.mPref1.mSec = "QuartzJump";
    mPnl.mPref1.mKey = "frame";
    mPnl.mPref2 = {};
    mPnl.mPref2.mSec = "QuartzJump";
    mPnl.mPref2.mKey = "TCorF";

    //もしも設定があれば読み込む。
    mPnl.Setting1 = mGetSetting(mPnl.mPref1);
    if (mPnl.Setting1 !== null) { mPnl.mEtFrm.text = mPnl.Setting1; }
    mPnl.Setting2 = mGetSetting(mPnl.mPref2);
    if (mPnl.Setting2 !== null) { mPnl.mBtFrm.text = mPnl.Setting2; }

    //テキストが変化したら設定に保存する。
    //ボタンについてはonClickに入れ込む。
    mPnl.mEtFrm.onChange = function () {
        mSaveSetting(mPnl.mPref1, mPnl.mEtFrm.text);
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //メイン処理パート。
    mPnl.mBtBack.onClick = function () { ForAndBack(-1, "Backward"); }
    mPnl.mBtFor.onClick = function () { ForAndBack(1, "Forward"); }

    //forとbackの処理はほぼ変わらないので、関数にまとめる。
    function ForAndBack(aPoM, aUndoTitle) {
        var mAi = app.project.activeItem;

        app.beginUndoGroup(aUndoTitle);

        var mTxt = mPnl.mEtFrm.text;
        //もしもボタンがT（TC）ならばテキストはTC表示なので、TCチェックtrueのTime尺を得る。
        if (mPnl.mBtFrm.text == "TC") {
            var mTimeTmp = mGetTimeFromEtStr(mTxt, mAi, true);
            //もしもボタンがFならばテキストはF表示なので、、TCチェックfalseのTime尺を得る。
        } else if (mPnl.mBtFrm.text == "F") {
            var mTimeTmp = mGetTimeFromEtStr(mTxt, mAi, false);
        }
        var mLR = aPoM;
        //現在の時間からテキスト表示タイムを引く（マイナスの値になったとき用にabsしておく）。
        var mRst = Math.abs(mAi.time + (mLR * mTimeTmp));
        //値を適用する。
        app.project.activeItem.time = mRst;

        app.endUndoGroup();

    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //TCとFの変換ボタン。
    mPnl.mBtFrm.onClick = function () {
        var mAi = app.project.activeItem;

        app.beginUndoGroup("ConvertTime");

        var mTxt = mPnl.mEtFrm.text;

        //もしもボタンがTCならばテキストはTC表示なので、mConvertTime関数でFに変換する。
        if (mPnl.mBtFrm.text == "TC") {
            var mTimeTmp = mConvertTime(mTxt, mAi, true);
            mPnl.mEtFrm.text = mTimeTmp;
            //ボタン自身の文字も変える。
            mPnl.mBtFrm.text = "F";
            //もしもボタンがFならばテキストはF表示なので、mConvertTime関数でTCに変換する。    
        } else if (mPnl.mBtFrm.text == "F") {
            var mTimeTmp = mConvertTime(mTxt, mAi, false);
            mPnl.mEtFrm.text = mTimeTmp;
            //ボタン自身の文字も変える。
            mPnl.mBtFrm.text = "TC";
        }

        app.endUndoGroup();
        //------------------------------------------------------------------------- 
        //セッティングブロック。変更した要素をセーブする。
        mSaveSetting(mPnl.mPref1, mPnl.mEtFrm.text);
        mSaveSetting(mPnl.mPref2, mPnl.mBtFrm.text);
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //セッティング関連関数（オブジェクト引数版）。
    //mSecとmKeyという要素を持つObjを作って、それを入れて使う。
    //----------------------------------------------------------
    //設定があればそれを返す関数。
    function mGetSetting(aPrefObj) {
        var mPrefObj = aPrefObj;
        if (app.settings.haveSetting(mPrefObj.mSec, mPrefObj.mKey) === false) {
            return null;
        } else {
            return app.settings.getSetting(mPrefObj.mSec, mPrefObj.mKey);
        }
    }
    //----------------------------------------------------------
    //引数を設定に保存する関数。
    function mSaveSetting(aPrefObj, aValue) {
        var mPrefObj = aPrefObj;
        app.settings.saveSetting(mPrefObj.mSec, mPrefObj.mKey, aValue);
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //TC関連関数。

    //文字列（エディットテキスト）からTime尺を得る。
    //aTCorFは文字列をTCとするか、Fとするか。
    function mGetTimeFromEtStr(aStr, aAi, aTCorF) {
        var mAi = aAi;
        var mTxt = aStr;
        var mTCorF = aTCorF;

        //もしも表示形式がフレームであれば、一時的にタイムコードにしておく。
        var mTdtFRAMESorNot = false;
        if (app.project.timeDisplayType === TimeDisplayType.FRAMES) {
            app.project.timeDisplayType = TimeDisplayType.TIMECODE;
            mTdtFRAMESorNot = true;
        }

        //もしもチェックがTCならばテキストはTC表示なので、Timeに変換する。
        if (mTCorF === true) {
            var mTimeTmp = mTCtoT(mTxt, mAi);
            //もしもチェックがFならばテキストはF表示なので、Timeに変換する。
        } else {
            var mTimeTmp = mFtoT(mTxt, mAi);
        }

        //もしも元の表示形式がフレームであったならば、元に戻す。
        if (mTdtFRAMESorNot === true) {
            app.project.timeDisplayType = TimeDisplayType.FRAMES;
        }

        return mTimeTmp;
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //TCとFを変換する（Time経由）。
    //aTCorFは、引数aStrがTCかFかで、戻り値は引数とは逆のフォーマットとなる。
    function mConvertTime(aStr, aAi, aTCorF) {
        var mAi = aAi;
        var mTxt = aStr;
        var mTCorF = aTCorF;

        //もしも表示形式がフレームであれば、一時的にタイムコードにしておく。
        var mTdtFRAMESorNot = false;
        if (app.project.timeDisplayType == TimeDisplayType.FRAMES) {
            app.project.timeDisplayType = TimeDisplayType.TIMECODE;
            mTdtFRAMESorNot = true;
        }

        //もしもチェックがTCならばテキストはTC表示なので、Time経由でFに変換する。
        if (mTCorF === true) {
            var mTimeTmp = mTCtoT(mTxt, mAi);
            mTimeTmp = mTtoF(mTimeTmp, mAi);
            //もしもチェックがFならばテキストはF表示なので、Time経由でTCに変換する。    
        } else {
            var mTimeTmp = mFtoT(mTxt, mAi);
            mTimeTmp = mTtoTC(mTimeTmp, mAi);
        }

        //もしも元の表示形式がフレームであったならば、元に戻す。
        if (mTdtFRAMESorNot === true) {
            app.project.timeDisplayType = TimeDisplayType.FRAMES;
        }

        return mTimeTmp;
    }
    //-----------------------------------------------------------------------
    //-----------------------------------------------------------------------
    //タイム                     秒基準の10進数
    //タイムコードTC       各単位の各進数
    //フレームF                 フレーム基準の10進数

    //カレントフォーマットをタイムに変換。
    //currentFormatToTimeに、フォーマットになっていない文字列（aとかbとか）を入れると0が返るので、エラー対策はしなくてよい。
    function mTCtoT(aTC, aAi) {
        var mAi = aAi;
        //フレームレート（１秒が何フレームあるか。29.97とか）。
        var mFps = mAi.frameRate;
        //1フレーム分の秒数（小数点）。
        var mFdtn = mAi.frameDuration;

        //カレントフォーマットをタイムに変換。
        var RstT = currentFormatToTime(aTC, mFps);

        return RstT;
    }
    //-----------------------------------------------------------------------
    //タイムをカレントフォーマットに変換。
    //中間経由関数で、入力するタイムが数字以外になることはないのでエラー対策はしない。
    function mTtoTC(aT, aAi) {
        var mAi = aAi;
        //フレームレート（１秒が何フレームあるか。29.97とか）。
        var mFps = mAi.frameRate;
        //1フレーム分の秒数（小数点）。
        var mFdtn = mAi.frameDuration;

        //タイムをカレントフォーマットに変換。
        var RstTC = timeToCurrentFormat(aT, mFps);

        return RstTC;
    }
    //-----------------------------------------------------------------------
    //フレームをタイムに変換。
    //文字列を入れ、文字列のまま処理すると戻り値がNaNになってしまうので、引数を数値に変換する。
    //数値変換の結果がNaNであれば、変化させないために戻り値をゼロにしておく。
    function mFtoT(aF, aAi) {
        var mAi = aAi;
        //フレームレート（１秒にフレームが何個あるか。29.97とか）。
        var mFps = mAi.frameRate;
        //1フレームの秒数（小数点）。
        var mFdtn = mAi.frameDuration;

        //引数の変換ブロック。
        var mF = parseFloat(aF);
        if (isNaN(mF) === true) { mF = 0; }

        //フレームをタイムに変換。１フレームの秒数＊フレーム個数で出る。
        var RstT = mFdtn * mF;

        return RstT;
    }
    //-----------------------------------------------------------------------
    //タイムをフレームに変換。
    //中間経由関数で、入力するタイムが数字以外になることはないのでエラー対策はしない。
    function mTtoF(aT, aAi) {
        var mAi = aAi;
        //フレームレート（１秒にフレームが何個あるか。29.97とか）。
        var mFps = mAi.frameRate;
        //1フレームの秒数（小数点）。
        var mFdtn = mAi.frameDuration;

        //フレームをタイムに変換。タイムの中に”１フレームの秒数”が何個あるか、で出る。割り切れない場合があるのでラウンドする。
        var RstF = Math.round(aT / mFdtn);

        return RstF;
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
}(this));

