﻿function mGetInfo() {
    try {
        app.beginUndoGroup("PropDriveGet");
        mGetInfoMain();
        app.endUndoGroup();
    } catch (e) {
        app.endUndoGroup();
        //app.executeCommand(16);
        alert(e.message + "\n" + e.line + "\n" + e.fileName);
    }
    //-------------------------------------------------------------------------
    function mGetInfoMain() {
        var mAi = app.project.activeItem;
        var mSls = mAi.selectedLayers;
        var mSl = mSls[0];
        var mSps = mSl.selectedProperties;
        var mSp = mSps[mSps.length - 1];
        
        //もしも選択プロップがパラメータであれば、情報を得てから、対象をその１つ上のプロップに変える。
        if( mSp.propertyType === PropertyType.PROPERTY ){
            mPnl.mEtPrm.text = mSp.name;
            //値を得る。選択キーがある場合は最後のキー値を得る。パネルObjに一応キー番号を保存しておく。
            if( mSp.selectedKeys.length !== 0 ){
                mPnl.mEtVal.text = mSp.keyValue(mSp.selectedKeys[mSp.selectedKeys.length-1]);
                mPnl.mSelKeyIdx = mSp.selectedKeys[mSp.selectedKeys.length-1];
            }else{
                mPnl.mEtVal.text = mSp.value;
                mPnl.mSelKeyIdx = 1;
            }
            //値がオブジェクトならばパネル内変数に入れておく。
            if (mSp.value instanceof Object) {mPnl.mValObj = mSp.value;}
            else{ mPnl.mValObj = null;}
            mSp = mSp.propertyGroup(1);
        }else{
            mPnl.mEtPrm.text = "";
            mPnl.mEtVal.text = "";
        }

        //ルートプロップを得る。
        var mDpt = mSp.propertyDepth - 1;
        if (mDpt === 0) { var mRootProp = mSp; }
        else { var mRootProp = mSp.propertyGroup(mSp.propertyDepth - 1); }
        mPnl.mEtRt.text = mRootProp.name;

        //ネームを得る。
        //名前の番号を省き、「～を含む」の正規表現にする。
        if (mPnl.mCbRgxIncl.value) { mPnl.mEtNm.text = ".*" + mSp.name.replace(/( |_|-)*[0-9]+/g, "") + ".*"; }
        else { mPnl.mEtNm.text = mSp.name; }

        //各種情報を得る。
        mPnl.mEtMn.text = mSp.matchName;
        mPnl.mEtIdx.text = "index : " + mSp.propertyIndex;
        mPnl.mEtDpt.text = "depth : " + mSp.propertyDepth;
        
        //クリップボードにコピー。
        if (mPnl.mCbCpy.value) { app.executeCommand(19); }

        //Regixチェックをオンオフしたとき用に、一応名前の番号を得ておく。
        var mMchStrs = mPnl.mEtNm.text.match(/( |_|-)*[0-9]+/g);
        if (mMchStrs !== null) { mPnl.mDelNumStr = mMchStrs[0]; }
        else { mPnl.mDelNumStr = ""; }

        //全レイヤーの選択を外す。
        for (var i = 0; i < mSls.length; i++) {mSls[i].selected = false;}
        
    }
}

//--------------------------------------------------------------------------------------------------------------------------------------------------
function mAplyJsx() {
    try {
        app.beginUndoGroup("PropDriveApply");
        mAplyJsxMain();
        app.endUndoGroup();
    } catch (e) {
        app.endUndoGroup();
        //app.executeCommand(16);
        alert(e.message + "\n" + e.line + "\n" + e.fileName);
    }    
    //-------------------------------------------------------------------------
    function mAplyJsxMain() {
        //パネル項目類。
        var mRtStr = mPnl.mEtRt.text;
        var mMnStr = mPnl.mEtMn.text;
        var mNmStr = mPnl.mEtNm.text;
        var mIdxStr =mPnl.mEtIdx.text;
        var mDptStr =mPnl.mEtDpt.text;
        var mPrmStr =mPnl.mEtPrm.text;     
        var mIsNm = mPnl.mCbNm.value;
        var mIsIdx =mPnl.mCbIdx.value;
        var mIsDpt =mPnl.mCbDpt.value;
        
        var mAi = app.project.activeItem;
        var mSls = mAi.selectedLayers;
        //全てのレイヤーとプロパティの選択を外す。のちのセレクト操作で対象外のレイヤーを含まないため。
        for (var i = 0; i < mSls.length; i++) {mSls[i].selected = false;}
        //レイヤーの選択を外せばプロップの選択も外れるはずだが、一応外す。
        var mSps = mAi.selectedProperties;
        for (var i = 0; i < mSps.length; i++) {mSps[i].selected = false;}
        
        //レイヤーを集める。
        //元々の選択レイヤーが無ければ全レイヤーを対象にする。あれば選択レイヤーにする。
        if( mSls.length === 0 ){
            for (var i = 1; i <= mAi.numLayers; i++) {mSls.push(mAi.layer(i));}
        }

        //ルートプロップを集める。空欄ならルートプロップをレイヤーs自身にする。
        var mRootProps = mSls;
        if (mRtStr !== "") {
            mRootProps = [];
            for (var i = 0; i < mSls.length; i++) {
                var mPropTp = mSls[i].property(mRtStr);
                if (mPropTp !== null){ mRootProps.push(mPropTp);}
            }
        }
        //-----------------------------------------
        //マッチネームでプロップを収集する。
        var mAllProps = [];
        var mIfFuncs = [];
        //マッチネームがあればそれを条件とする。なければ全てのプロップが入る。
        if (mMnStr !== "") {
            var mIfFuncMn = function(aProp) { return (aProp.matchName === mMnStr);}
            mIfFuncs.push( mIfFuncMn );
        }
        for (var i = 0; i < mRootProps.length; i++) {
            var mRootProp = mRootProps[i];
            var mAllProp = mGetAllPropsFromOgl(mRootProp, mIfFuncs);
            //配列の連結、concatより速い。
            Array.prototype.push.apply(mAllProps, mAllProp);
        } 
        //-----------------------------------------
        //ネームソート。
        if (mIsNm) {
            var mRegex = new RegExp("^" + mNmStr + "$");
            for (var i = 0; i < mAllProps.length; i++) {
                if( !( mRegex.test( mAllProps[i].name ))){ mAllProps[i] = null;}
            }
        }
        //インデックスソート。
        if (mIsIdx) {
            var mIdxStrs = mIdxStr.match( /[0-9]+/g );
            if( mIdxStrs === null ){ var mIdx = 0;}
            else{ var mIdx = parseInt( mIdxStrs[mIdxStrs.length-1] ); }
            for (var i = 0; i < mAllProps.length; i++) {
                if (mAllProps[i] === null){ continue;}
                if (mAllProps[i].propertyIndex !== mIdx ) {mAllProps[i] = null;}
            }
        }
        //デプスソート。
        if (mIsDpt) {
            var mDptStrs = mDptStr.match( /[0-9]+/g );
            if( mDptStrs === null ){ var mDpt = 0;}
            else{ var mDpt = parseInt( mDptStrs[mDptStrs.length-1]);}
            for (var i = 0; i < mAllProps.length; i++) {
                if (mAllProps[i] === null){ continue;}
                if (mAllProps[i].propertyDepth !== mDpt) {mAllProps[i] = null;}
            }
        }

        //上記ソートで入ったヌルを削除する。hiddenチェックにはヌルが使えないため。
        for (var i = mAllProps.length - 1; i >= 0; i--) {
            if (mAllProps[i] === null) { mAllProps.splice(i, 1); }
        }
        if(mAllProps.length === 0 ){ return;}

        //パラムがある場合はパラムにする。
        if( mPrmStr !== "" ){
            //現状で全て同種のプロップが入っているので、それにパラムプロップがあるかチェックは１回だけでよい。
            var mPropTp = mAllProps[0].property( mPrmStr );
            if( mPropTp === null ){ return;}
            for (var i = 0; i < mAllProps.length; i++) {
                mAllProps[i] = mAllProps[i].property( mPrmStr );
            }
        }

        //hiddenプロップかどうか調べる。
        //例えば次元分割したPosX情報を得て、次元分割していないレイヤーから収集すると、その「扱えないPosX」がmAllPropsに含まれることになる。
        //hiddenプロップは別で分け、ユーザー的にOKであればhiddenではないものだけを処理する。
        var mHdns = [];
        for (var i = 0; i < mAllProps.length; i++) {
            if (mIsHidden(mAllProps[i])) {
                mAllProps[i] = null;
                mHdns.push(mProp);
            }
        }
        //ソートでnullを入れたものを削除する。
        for (var i = mAllProps.length - 1; i >= 0; i--) {
            if (mAllProps[i] === null) { mAllProps.splice(i, 1); }
        }
    
        //「hiddenプロパティは扱えないが続けるか？」というメッセージを出す。
        if (mHdns.length !==0 ) {
            var mCfm = confirm("Some of the properties are hidden.\nThe script can't handle the hidden properties.\n\nContinue?");
            //Noを押したならばリターンする。
            if (!mCfm) { return; }
        }

        //最終処理前に、タイムラインコンポが選択されるようビューワーをアクティブにしておく。
        app.activeViewer.setActive();

        //---------------------------------------------------------------
        //最終パート。
        //各コードjsxで使用できる変数。
        var props = mAllProps;
        var valueTxt = mPnl.mEtVal.text;
        var valueObj = mPnl.mValObj;
        var hiddenProps = mHdns;
        var keyIdx = mPnl.mSelKeyIdx;

        //selectionは選択されていないとundefinedとなるが、ダブルクリック用関数なので問題ない。
        var mLstSelIdx = mPnl.mLstJsx.selection.index;
        var mCodePath = mPnl.mPnNObj.mFullPaths[mLstSelIdx];
        if (/\.jsx.*/.test(mCodePath)) { $.evalFile(mCodePath); }
        
        //infoタブに移動する。
        mPnl.mTbMtr.selection = mPnl.mTbI;
        
    }
}