﻿//特定のプロパティ（レイヤーでも可）から始めて、条件合致した全てを配列に入れる関数。
//引数２には、引数にプロパティを入れたら真偽値を返す関数群の配列を入れる。
function mGetAllPropsFromOgl(aOglProp, aIfFuncs) {
    var mOglProp = aOglProp;
    var mIfFuncs = aIfFuncs;

    //この空配列に、再帰関数内で要素が全て入る。
    var mRst = [];
    //最初の引数を入れて再帰関数を発動、終わったらmRstをリターン。
    mExecute(mOglProp);
    return mRst;

    //再帰関数。
    //最初の引数以外は上記関数内にある外部引数を使っていることに注意。
    function mExecute(aProp) {
        //まずは自身を条件合致でmRstへ入れる。
        if (mSortAndTorF(aProp, mIfFuncs)) { mRst.push(aProp); }

        //プロパティタイプが子要素ありタイプならば、子要素について処理する。
        var mPropType = aProp.propertyType;
        if (mPropType === PropertyType.INDEXED_GROUP
            || mPropType === PropertyType.NAMED_GROUP) {
            for (var i = 1; i <= aProp.numProperties; i++) {
                mExecute(aProp(i));
            }
        }
    }

    function mSortAndTorF(aPropTmp, aIfFuncs) {
        var mPropTmp = aPropTmp;
        var mIfFuncs = aIfFuncs;
        //プロパティを、真偽値を返す関数群が入った配列ループで回し、
        //関数ごとにプロパティを引数に入れて真偽値を更新していく。
        //一度でもfalseであればfalseをリターンする。
        //最後までたどり着いたら全てtrueなのでtrueをリターンする。
        for (var i = 0; i < mIfFuncs.length; i++) {
            if (mIfFuncs[i](mPropTmp) !== true) { return false; }
        }
        return true;
    }
}
//----------------------------------------------------------------------------------------------------------------------
//プロパティがhiddenかどうかを返す関数（tryCatchを使用）。
function mIsHidden(aProp) {
    //canSetExpressionはproperty("レイヤースタイル")("境界線")("位置")などはhiddenでもtrueとなってしまう。
    //エラーを起こして調べる。
    try {
        //一部キーを選択していた場合、キーが全選択になることに注意。
        aProp.selected = aProp.selected;
        //エラーが起こらなければhiddenではない。
        return false;
    } catch (e) {
        var mErrStr = e.message;
        //エラー文字列にhiddenが含まれていればhiddenである。
        return ( /hidden/.test( mErrStr ));
    }
}
//----------------------------------------------------------------------------------------------------------------------
//現在パスから使用コードjsxのフルパス、名前を取得する関数。
function mGetPathsAndNames() {
    var mNowFld = new File($.fileName).parent;
    var mNowFLdPath = mNowFld.fsName;
    mNowFLdPath = mNowFLdPath + "/(forPropDrive)";
    //getFiles()で得られるものはフルパス名ではなくファイルObj。
    var mFiles = new Folder(mNowFLdPath).getFiles();

    //フォルダを取り除く。
    for (var i = mFiles.length - 1; i >= 0; i--) {
        var mFile = mFiles[i];
        if (mFile instanceof Folder) { mFiles.splice(i, 1); }
    }

    //URIデコードしたフルパス群を得る。
    var mFullPaths = [];
    for (var i = 0; i < mFiles.length; i++) {
        mFullPaths.push(decodeURIComponent(mFiles[i].fsName));
    }
    //URIデコードしたネーム群を得る。
    var mCodeNames = [];
    for (var i = 0; i < mFiles.length; i++) {
        //拡張子を抜く。
        var mCodeName = decodeURIComponent(mFiles[i].name);
        var mMch = mCodeName.match(/^.*(?=\.)/);
        if (mMch !== null) { mCodeName = mMch[0]; }
        mCodeNames.push(mCodeName);
    }
    var mPathObj = {};
    mPathObj.mFullPaths = mFullPaths;
    mPathObj.mCodeNames = mCodeNames;
    return mPathObj;
}









