﻿//~ //テスト用。
//~ (function(aGbl){
//~ var mPnl = mCreateUI(aGbl);
//~ if (mPnl instanceof Window) {
//~     mPnl.center();
//~     mPnl.show();
//~ } else if (mPnl instanceof Panel) {
//~     //UIパネルの場合は以下をしないと自動レイアウトされない。
//~     mPnl.layout.layout(true);
//~ }
//~ })(this);
//--------------------------------------------------------------
//メインウィンドウ作成関数。
function mCreateUI(aObj) {
    var mPW = (aObj instanceof Panel) ? aObj : new Window("palette", "PropDrive", undefined);
    mPW.preferredSize = [200, 200];
    mPW.margins = [0, 0, 0, 0];
    mPW.spacing = 10;
    mPW.alignment = ["fill", "fill"];
    
    //タブ。
    mPW.mTbMtr = mPW.add("panel { type: 'tabbedpanel', preferredSize : [190, 270], margins : [0, 0, 0, 0], spacing : 0 }");
    var mTbMtr = mPW.mTbMtr;
    mPW.mTbI = mTbMtr.add("panel{ type: 'tab', text : 'I', alignment : ['left', 'top'], margins : [8, 8, 0, 8], spacing : 0 }");
    mPW.mTbA = mTbMtr.add("panel{ type: 'tab', text : 'A', alignment : ['left', 'top'], margins : [8, 8, 0, 8], spacing : 0 }");
    var mTbI = mPW.mTbI;
    var mTbA = mPW.mTbA;
    //--------------------------------------------------------------
    var mGpI = mTbI.add("group {orientation : 'column' , alignment :  [ 'fill','fill' ] , margins : [0, 0, 0, 0],spacing :0}");
    var mGpT = mGpI.add("group {orientation : 'row' , alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing :8}");
    var mGpTL = mGpT.add("group {orientation : 'column' , alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing :0}");
    mPW.mBtGet = mGpTL.add("button { text : 'Get Info', preferredSize: [60, 20], alignment :  [ 'left','top' ] }");
    var mGpTR = mGpT.add("group {orientation : 'column' , alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing :0}"); 
    mPW.mCbCpy = mGpTR.add("checkbox { text : '& Copy to Clipbrd',alignment :  [ 'left','top' ] }");
    mPW.mCbCpy.value = true;
    mPW.mCbRgxIncl = mGpTR.add("checkbox { text : 'Regex for Incl',alignment :  [ 'left','top' ] }");

    var mGpSpcI1 = mGpI.add("group {orientation : 'stack' , alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing :0}");
    mGpSpcI1.add("group { preferredSize : [20,20]}");
    mGpSpcI1.add("Panel { preferredSize : [180, 0] }");

    mGpI.add("StaticText  { text : 'Root', preferredSize: [-1, 20],alignment :  [ 'left','top' ]}");
    mPW.mEtRt = mGpI.add("EditText { text : 'name', preferredSize: [160, 20] , alignment :  [ 'left','top' ] }");
    
    mGpI.add("StaticText  { text : 'Prop', preferredSize: [-1, 20],alignment :  [ 'left','top' ]}");
    var mGpMn = mGpI.add("group {orientation : 'row' , alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing :0}");
    mPW.mEtMn = mGpMn.add("EditText  { text : 'matchName', preferredSize: [160, 20],alignment :  [ 'left','top' ] }");
    //mPW.mCbMn = mGpMn.add("checkbox { text : '',alignment :  [ 'left','top' ] }");
    //mPW.mCbMn.value = true;    
    var mGpNm = mGpI.add("group {orientation : 'row' , alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing :0}");
    mPW.mEtNm = mGpNm.add("EditText  { text : 'name', preferredSize: [160, 20],alignment :  [ 'left','top' ] }");
    mPW.mCbNm = mGpNm.add("checkbox { text : '',alignment :  [ 'left','top' ] }");
    mPW.mCbNm.value = true;
    var mGpIdx = mGpI.add("group {orientation : 'row' , alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing :0}");
    mPW.mEtIdx = mGpIdx.add("EditText  { text : 'index', preferredSize: [160, 20],alignment :  [ 'left','top' ] }");
    mPW.mCbIdx = mGpIdx.add("checkbox { text : '',alignment :  [ 'left','top' ] }");
    mPW.mCbIdx.value = false;
    mPW.mEtIdx.enabled = false;
    var mGpDpt = mGpI.add("group {orientation : 'row' , alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing :0}");
    mPW.mEtDpt = mGpDpt.add("EditText  { text : 'depth', preferredSize: [160, 20],alignment :  [ 'left','top' ] }");
    mPW.mCbDpt = mGpDpt.add("checkbox { text : '',alignment :  [ 'left','top' ] }");
    mPW.mCbDpt.value = false;
    mPW.mEtDpt.enabled = false;
    
    mGpI.add("StaticText  { text : 'Param', preferredSize: [-1, 20],alignment :  [ 'left','top' ]}");
    mPW.mEtPrm = mGpI.add("EditText  { text : 'name' ,preferredSize: [160, 20] , alignment :  [ 'left','top' ] }");
    //--------------------------------------------------------------
    var mGpA= mTbA.add("group {orientation : 'column' , alignment :  [ 'fill','fill' ] , margins : [0, 0, 0, 0],spacing :0}");
    mGpA.add("StaticText  { text : 'Custom Value', preferredSize: [-1, 20],alignment :  [ 'left','top' ]}");
    mPW.mEtVal = mGpA.add("EditText  { text : 'value' ,preferredSize: [180, 20] , alignment :  [ 'left','top' ] }");

    var mGpSpcA1 = mGpA.add("group {orientation : 'stack' , alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing :0}");
    mGpSpcA1.add("group { preferredSize : [20,20]}");
    mGpSpcA1.add("Panel { preferredSize : [180, 0] }");

    mPW.mLstJsx = mGpA.add("listbox {preferredSize: [180, 260] }");

    var mGpSpcA2 = mGpA.add("group {orientation : 'stack' , alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing :0}");
    mGpSpcA2.add("group { preferredSize : [20,20]}");
    //mGpSpcA2.add("Panel { preferredSize : [180, 0] }");
    
    //--------------------------------------------------------------
    //チェックボックスとエディットテキストを連動させる。
    mPW.mCbNm.onClick = function () {mPW.mEtNm.enabled = mPW.mCbNm.value;}
    //mPW.mCbMn.onClick = function () {mPW.mEtMn.enabled = mPW.mCbMn.value;}  
    mPW.mCbDpt.onClick = function () {mPW.mEtDpt.enabled = mPW.mCbDpt.value;}
    mPW.mCbIdx.onClick = function () {mPW.mEtIdx.enabled = mPW.mCbIdx.value;}
    //--------------------------------------------------------------
    //Inclチェックボックスのオンオフで正規表現の有り無しを変える。
    mPW.mCbRgxIncl.onClick = function () {
        var mNtxt = mPW.mEtNm.text;
        if (mNtxt === "") { return; }

        //すでに正規表現があるか否か。
        var mRgxExst = /\.\*.*\.\*/.test(mNtxt);
        //チェックがオンの場合。
        if (mPW.mCbRgxIncl.value) {
            //正規表現がないならば加え、数字を消す。
            if (!mRgxExst) { mPW.mEtNm.text = ".*" + mNtxt.replace(/( |_|-)*[0-9]+/g, "") + ".*"; }
            //チェックがオフの場合。 
        } else {
            //正規表現があるならば削除し、数字を加える。
            //数字はGetInfoで得たものを使うので、数字が無いinfoなら””が入る。
            if (mRgxExst) { mPW.mEtNm.text = mNtxt.replace(/\.\*/g, "") + mPW.mDelNumStr; }
        }
    }
    //--------------------------------------------------------------
    //フリック操作の実装。
    mPW.mMsePtX = null;
    mPW.mIsMseDwn = false;
    mPW.mMoveLgt = 10;
    mGpI.addEventListener( "mousedown" , mEvtMseDwn);
    mGpA.addEventListener( "mousedown" , mEvtMseDwn);
    mGpI.addEventListener( "mouseup" , mEvtMseUpI);
    mGpA.addEventListener( "mouseup" , mEvtMseUpA);
    //ボタンやチェックボックスを押すとマウスアップイベントリスナーのみが無効となり、mIsMseDwnがtrueのままとなる。
    //逆にエディットテキストはマウスアップのみ有効となるため、組み合わさるとフリックが起こってしまう。
    //なので、e.target != e.currentTargetでパーツ類に関するマウスダウンを無効にする。
    function mEvtMseDwn(e){
        if (e.target != e.currentTarget){return;}
        mPW.mMsePtX = e.screenX;
        mPW.mIsMseDwn = true;
    }
    function mEvtMseUpI(e){
        if( !mPW.mIsMseDwn){return;}
        if( Math.abs(e.screenX - mPW.mMsePtX) > mPW.mMoveLgt ){
            mTbMtr.selection = mTbA;
        }
        mPW.mIsMseDwn = false;
    }
    function mEvtMseUpA(e){
        if( !mPW.mIsMseDwn){ return;}
        if( Math.abs(e.screenX - mPW.mMsePtX) > mPW.mMoveLgt ){
            mTbMtr.selection = mTbI;
        }
        mPW.mIsMseDwn = false;
    }
    //--------------------------------------------------------------
    //オブジェクト保存用の変数。
    mPW.mValObj = null;
    //パス＆名前用の変数。
    mPW.mPnNObj = {};
    //GetInfo後に、Regixチェックをオンオフしたとき用に一応番号を保存しておく変数。
    mPW.mDelNumStr = "";
    //キーありで情報を得たときにキー番号を一応とっておく変数。
    mPW.mSelKeyIdx =1;

    return mPW;
}