﻿(function (aGbl) {
    //----------------------------------------------------------------------------------------------------------------------
    function mCreateUI(aObj) {
        var mPorW = (aObj instanceof Panel) ? aObj : new Window("palette", "PathRev", [0, 0, 200, 220]);
        
        var mPorW = (aObj instanceof Panel) ? aObj : new Window("palette", "PathRev", undefined);
        mPorW.preferredSize = [200, 220];
        mPorW.margins = [5, 5, 5, 5];
        mPorW.spacing = 10;
        
        mPorW.mGpRb = mPorW.add("group { orientation : 'row', alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 0}");
        mPorW.mGpRb.add("radiobutton { preferredSize : [-1,20], text : 'Shape' ,alignment :  [ 'left','top' ] ,properties:{name:'mRbShp'} }");
        mPorW.mGpRb.add("radiobutton { preferredSize : [-1,20], text : 'Mask' ,alignment :  [ 'left','top' ] ,properties:{name:'mRbMsk'} }");

        mPorW.mGpRev = mPorW.add("group { orientation : 'row', alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 20}");
        mPorW.mGpRev.add("button { preferredSize : [60,20], text : 'Reverse' ,alignment :  [ 'left','top' ] ,properties:{name:'mBtRev'} }");
        mPorW.mGpRev.add("checkbox { preferredSize : [-1,20], text : 'Lock Start Point' ,alignment :  [ 'left','top' ] ,properties:{name:'mCbSame'} }");
        
        mPorW.mGpTtl = mPorW.add("group { orientation : 'stack', alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 0}");
        mPorW.mGpTtl.add("panel { preferredSize : [60,0] }");
        mPorW.mGpTtl.add("statictext { preferredSize : [-1,20], text : 'Clockwise' ,justify : 'center' }");
     
        mPorW.mGpAnti = mPorW.add("group { orientation : 'row', alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 0}");
        mPorW.mGpAnti.add("button { preferredSize : [60,20], text : 'Check' ,alignment :  [ 'left','top' ] ,properties:{name:'mBtAnti'} }");

        mPorW.mRbShp =mPorW.mGpRb.mRbShp;
        mPorW.mRbMsk =mPorW.mGpRb.mRbMsk;
        mPorW.mBtRev = mPorW.mGpRev.mBtRev;
        mPorW.mCbSame = mPorW.mGpRev.mCbSame;
        mPorW.mBtAnti = mPorW.mGpAnti.mBtAnti;
        
        return mPorW;

    }

    var mPnl = mCreateUI(aGbl);
    if (mPnl instanceof Window) {
        mPnl.center();
        mPnl.show();
    }
    //----------------------------------------------------------------------------------------------------------------------
    //セーブ関連。
    var mSecName = "PathRev";
    var mKeyName1 = "IsSame";
    var mKeyName2 = "IsShape";
    
    //読み込み。
    var mIsSame = false;
    if( app.settings.haveSetting( mSecName,mKeyName1 ) ){
        mIsSame = (app.settings.getSetting(mSecName,mKeyName1) === "true");
    }
    mPnl.mCbSame.value = mIsSame;

    var mIsShape = true;
    if( app.settings.haveSetting( mSecName,mKeyName2 ) ){
        mIsShape = (app.settings.getSetting(mSecName,mKeyName2) === "true");
    }
    mPnl.mRbShp.value = mIsShape;
    mPnl.mRbMsk.value = !mIsShape;
    
    //保存用関数。
    mPnl.mCbSame.onClick = function () {
        var mVal = mPnl.mCbSame.value;
        app.settings.saveSetting(mSecName, mKeyName1, mVal.toString());
    }
    
    mPnl.mRbShp.onClick = function () {
        var mVal = mPnl.mRbShp.value;
        app.settings.saveSetting(mSecName, mKeyName2, mVal.toString());
    }
    mPnl.mRbMsk.onClick = function () {
        var mVal = mPnl.mRbShp.value;
        app.settings.saveSetting(mSecName, mKeyName2, mVal.toString());
    }

    //----------------------------------------------------------------------------------------------------------------------
    //メイン処理。
    mPnl.mBtRev.onClick = function () {
        app.beginUndoGroup("Reverse");
        
        var mAi = app.project.activeItem;
        var mSls = mAi.selectedLayers;
        
        var mPathInfos = mGetAllPathInfos(mSls);
        var mPathVals = mPathInfos[0];
        var mPaths = mPathInfos[1];
        var mPathIdxs = mPathInfos[2];
     
        for (var i = 0; i < mPathVals.length; i++) {
            var mPathVal = mPathVals[i];
            var mPath = mPaths[i];
            var mPathIdx = mPathIdxs[i];
            //オリジナルで作った関数でパスを反転させる。
            mReversePath(mPathVal,mPath,mPathIdx);
        }
        app.endUndoGroup();
    }
    //----------------------------------------------------------------------------------------------------------------------
    mPnl.mBtAnti.onClick = function () {
        app.beginUndoGroup("Check");
        
        var mAi = app.project.activeItem;
        var mSls = mAi.selectedLayers;
        
        var mPathInfos = mGetAllPathInfos(mSls);
        var mPathVals = mPathInfos[0];
        var mPaths = mPathInfos[1];
        var mPathIdxs = mPathInfos[2];
        
        var mStrs = [];
        for (var i = 0; i < mPathVals.length; i++) {
            var mPathVal = mPathVals[i];
            var mPath = mPaths[i];
            var mPathIdx = mPathIdxs[i];
            //担当レイヤーとパスプロップの名前、キー番号。
            var mLyrName = mPath.propertyGroup(mPath.propertyDepth).name;
            var mPathPropName = mPath.propertyGroup(1).name;
            if( mPathIdx === null ){ var mKeyName = "KeyX";}
            else{ var mKeyName =  "Key"+mPathIdx.toString();}
            
            var mVtxs = mPathVal.vertices;
            //反時計回りチェック関数を使う。
            var mAnti = mGetAreaAndAntiClock(mVtxs).mAnti;
            if (mAnti) {var mAntiStr = "Anti-clockwise"; }
            else { var mAntiStr ="Clockwise"; }
            
            var mRstStr = mLyrName + " / " + mPathPropName +" / " + mKeyName + " : " + mAntiStr;
            mStrs.push( mRstStr );
        }
    
        mStrs = mStrs.join("\n");
        alert(mStrs  );
        
        app.endUndoGroup();

    }
    //----------------------------------------------------------------------------------------------------------------------
    //----------------------------------------------------------------------------------------------------------------------
    //以下、使用関数。
    //全選択プロップからパスVal配列、パス配列、パスキーインデックス配列の３つを集める関数。
    //パスキーインデックス配列とパスValの数に対応させるため、パスは配列内で重複している箇所がある。
    //キー無しパスの箇所には、パスValにはkeyValueではなくvalue、インデックスにはnullが入る。
    //パスを選択せずパスプロップのみの場合も、そのパスValを集める。
    function mGetAllPathInfos(aSls){
        //チェックによってマッチネームをシェイプパスかマスクパスにする。
        if(mPnl.mRbShp.value){
            var mPathPropMN = "ADBE Vector Shape - Group";
            var mPathMN = "ADBE Vector Shape";
        }else{
            var mPathPropMN = "ADBE Mask Atom";
            var mPathMN = "ADBE Mask Shape";
        }
        
        var mSls = aSls;
        var mPathVals = [];
        var mPaths = [];
        var mPathIdxs = [];
        
        var mPathsTp = [];
        for (var i = 0; i < mSls.length; i++) {
            var mSl = mSls[i];
            var mSps = mSl.selectedProperties;
            for (var j = 0; j < mSps.length; j++) {
                var mSp = mSps[j];
                if(mSp.matchName === mPathPropMN){
                    mPathsTp.push( mSp.property(mPathMN) );
                //もしもパスプロップではなくパスで、かつ（あまりない状況だが）１個上のパスプロップが選択されていなければ
                //上記処理だけではこのパスは得られないので、入れておく。
                }else if(mSp.matchName === mPathMN){
                    if( mSp.propertyGroup(1).selected === false ){ mPathsTp.push( mSp );}
                }
            }
        }
    
        for (var i = 0; i < mPathsTp.length; i++) {
            var mPath = mPathsTp[i];
            var mNumKeys = mPath.numKeys;
            //キーがない場合はvalueを処理する。
            //キーがあって選択していない場合はkeyValueを全て処理する。
            //キーがあって選択している場合はそのkeyValueのみを処理する。
            if( mNumKeys === 0 ){
                mPathVals.push( mPath.value );
                mPaths.push( mPath );
                mPathIdxs.push( null );
            }else{
                //selectedKeysで得られるのはキー自体ではなくキーナンバーの配列。
                var mSelKeys = mPath.selectedKeys;
                //選択キー配列がゼロならば、むしろ全てのナンバーを入れる。
                if( mSelKeys.length === 0 ){
                    mSelKeys = [];
                    for (var k = 1; k <= mNumKeys; k++) { mSelKeys.push(k);}
                }
                //選択キーナンバーのキーValを入れる。
                for (var k = 0; k < mSelKeys.length; k++) {
                    var mKeyIdx = mSelKeys[k];
                     mPathVals.push( mPath.keyValue(mKeyIdx));
                     mPaths.push( mPath);
                     mPathIdxs.push(mKeyIdx );
                 }
             }
         }
        return [ mPathVals, mPaths,mPathIdxs];
    }
    //----------------------------------------------------------------------------------------------------------------------
    //パスを反転させる関数。
    //パスを反転するには、バーテックス、イン、アウトタンジェントの全てを反転させるだけではダメで、
    //インにはアウト、アウトにはインを入れる、という入れ替え作業が必要。
    function mReversePath(aPathVal,aPath,aPathIdx){
        var mPath = aPath;
        var mPathVal = aPathVal;
        var mPathIdx = aPathIdx;
        
        //各情報を得る。
        var mVtxs = mPathVal.vertices;
        var mIns = mPathVal.inTangents;
        var mOuts = mPathVal.outTangents;
        //反転する。
        mVtxs.reverse();
        mIns.reverse();
        mOuts.reverse();

        //始点を変えないチェックがついていたとき用の処理。
        //（引数経由で渡すのもめんどうなので外部のチェック変数をそのまま使用）。
        //一番後ろのポイントを頭に持ってくると始点が変わらないことになる。
        if (mPnl.mCbSame.value) {
            var mVtxLast = mVtxs[mVtxs.length - 1];
            mVtxs.pop();
            mVtxs.unshift(mVtxLast);
            var mInLast = mIns[mIns.length - 1];
            mIns.pop();
            mIns.unshift(mInLast);
            var mOutLast = mOuts[mOuts.length - 1];
            mOuts.pop();
            mOuts.unshift(mOutLast);
        }

        //各情報を反転したものに書き換える。インとアウトは入れ替えて入れる。
        mPathVal.vertices = mVtxs;
        mPathVal.inTangents = mOuts;
        mPathVal.outTangents = mIns;

        //パス自体orキーに、できたValを差し戻す。
        //mPathIdxがヌルの場合はキー無しなのでsetValue、ある場合はsetValueAtKey。
        if( mPathIdx === null ){ mPath.setValue( mPathVal );}
        else{ mPath.setValueAtKey( mPathIdx, mPathVal );}
    }
    //----------------------------------------------------------------------------------------------------------------------
    //多角形の面積と、反時計回りか否かを算出する関数。
    //戻り値はオブジェクトで、mAreaは面積、mAntiは反時計回りか否か。
    function mGetAreaAndAntiClock(aVtxs) {
        //原点&２点の３点面積（符号付き）を足せば、面積（符号付き）が出る。
        var mAreaSum = 0;
        for (var i = 0; i < aVtxs.length; i++) {
            var mIdxNex = (i + 1 + aVtxs.length) % aVtxs.length;

            var mTriArea = mGetTriArea(0, aVtxs[i], aVtxs[mIdxNex]);
            mAreaSum += mTriArea;
        }

        //符号がゼロより大きければ反時計回りではない（座標系による）。
        if (mAreaSum > 0) { var mAnti = false; }
        else { var mAnti = true; }
        //面積は符号を外してリターンする。
        mAreaSum = Math.abs(mAreaSum);

        var mRst = {};
        mRst.mArea = mAreaSum;
        mRst.mAnti = mAnti;
        return mRst;

        //外積のZ（ひし形の面積）/２で三角形の面積を出す。
        function mGetTriArea(aStd, aDir1, aDir2) {
            var Vec1 = (aDir1 - aStd);
            var Vec2 = (aDir2 - aStd);

            var crossZ = (Vec1[0] * Vec2[1]) - (Vec2[0] * Vec1[1]);
            return crossZ / 2;
        }
    }
    //----------------------------------------------------------------------------------------------------------------------
}(this));



