﻿(function (aGbl) {
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    function mCreateUI(aObj) {
        var mPorW = (aObj instanceof Panel) ? aObj : new Window("palette", "Pathp", undefined);
        mPorW.preferredSize = [200, 50];
        mPorW.margins = [10, 10, 10, 10];
        mPorW.spacing = 10;

        //デフォルト設定保存用の変数。
        mPorW.mDefPref = "";
        //スタティックテキストの初期値。
        mPorW.mDefTxt = "Path Point and Handle Radius = ";
        mPorW.mSt = mPorW.add("staticText { text : 'txt' , alignment :  [ 'fill','top' ] }");

        mPorW.mSl1 = mPorW.add("slider", undefined, 7, 4, 15);
        mPorW.mSl1.preferredSize = [180, 20];

        return mPorW;
    }
    //-----------------------------------------------------------------------
    //mPnlという名でメインウインドウを作成。
    var mPnl = mCreateUI(aGbl);
    if (mPnl instanceof Window) {
        mPnl.center();
        mPnl.show();
    } else if (mPnl instanceof Panel) {
        //UIパネルの場合は以下をしないと自動レイアウトされない。
        mPnl.layout.layout(true);
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //スタティックテキストとスライダーの初期位置を、AE設定から読み込んだ値にする。
    mPnl.mDefPref =
        app.preferences.getPrefAsString("General Section", "Path Point and Handle Radius (pixels)"
            , PREFType.PREF_Type_MACHINE_INDEPENDENT);

    mPnl.mSt.text = mPnl.mDefTxt + mPnl.mDefPref;
    mPnl.mSl1.value = mPnl.mDefPref;

    //--------------------------------------------------------------------------------------------------------------------------------------------------
    mPnl.mSl1.onChange = function () {
        //スライダーの値を四捨五入して文字列にする。
        var mSldVal = Math.round(mPnl.mSl1.value);
        mSldVal = mSldVal.toString();

        //設定できる数値は4~15の整数値のみ。場所は以下の通り。
        //Adobe After Effects 17.5 環境設定-indep-general.txt
        //["General Section"]　、　"Path Point and Handle Radius (pixels)" = "数値"。
        //環境設定に入っている"Path Point and Handle Radius Extra Selection (pixels)" = "7"ではない。
        app.preferences.savePrefAsString("General Section", "Path Point and Handle Radius (pixels)",
            mSldVal, PREFType.PREF_Type_MACHINE_INDEPENDENT);
        //app.preferences.reload;
        //app.preferences.saveToDisk;

        //画面更新させないと変化が反映されないので、インジケータを『移動＆元に戻す』で更新させる。
        //ビューワーをアクティブにすれば、アクティブアイテムが高確率でアクティブコンポになる。
        var mActV = app.activeViewer;
        mActV.setActive();
        var mAi = app.project.activeItem;
        var mTime = mAi.time;
        mAi.time = 1;
        mAi.time = mTime;

    }
    //-----------------------------------------------------------------------
    //数字はリアルタイム更新する。
    mPnl.mSl1.onChanging = function () {
        var mSldVal = Math.round(mPnl.mSl1.value);
        mSldVal = mSldVal.toString();
        mPnl.mSt.text = mPnl.mDefTxt + mSldVal;
    }

    //--------------------------------------------------------------------------------------------------------------------------------------------------
})(this);
