﻿(function (aGbl) {
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    function mCreateUI(aObj) {
        var mPorW = (aObj instanceof Panel) ? aObj : new Window("palette", "MassivePaste", undefined);
        mPorW.preferredSize = [200, 120];
        mPorW.margins = [5, 5, 5, 5];
        mPorW.spacing = 5;

        mPorW.add("staticText { preferredSize : [60,20] , alignment :  [ 'left','top' ] , text : 'Lock' }");

        mPorW.mGpIdx = mPorW.add("group { alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 0}");
        mPorW.mCbWithIdx = mPorW.mGpIdx.add("checkbox { preferredSize : [-1,20] , text : '' ,helpTip:'Lock'}"); 
        mPorW.mGpIdx.add("staticText { preferredSize : [60,20] , alignment :  [ 'left','top' ] , text : 'Index' }");
        mPorW.mEtIdx = mPorW.mGpIdx.add("editText { preferredSize : [120,20] , alignment :  [ 'left','top' ] , text : '1' }");

        mPorW.mGpFrm = mPorW.add("group { alignment :  [ 'fill','top' ] , margins : [0, 0, 0, 0],spacing : 0}");
        mPorW.mCbWithT = mPorW.mGpFrm.add("checkbox { preferredSize : [-1,20] , text : '' ,helpTip:'Lock'}"); 
        mPorW.mGpFrm.add("staticText { preferredSize : [60,20] , alignment :  [ 'left','top' ] , text : 'Time' }"); 
        mPorW.mEtFrm = mPorW.mGpFrm.add("EditText { preferredSize : [100,20] , text : '' }");
        mPorW.mInitF = "0:00:00:00";
        mPorW.mEtFrm.text = mPorW.mInitF;
        mPorW.mBtFrm = mPorW.mGpFrm.add("button { preferredSize : [20,20] , text : 'TC' }");

        mPorW.mCbWithIdx.value = false;
        mPorW.mCbWithT.value = false;

        mPorW.mGpSft = mPorW.add("group { alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 0}");
        mPorW.mGpSft.add("staticText { preferredSize : [80,20] , alignment :  [ 'left','top' ] , text : 'Shift frame' }");
        mPorW.mEtISft = mPorW.mGpSft.add("editText { preferredSize : [120,20] , alignment :  [ 'left','top' ] , text : '0' }");
        
        mPorW.mCbClose = mPorW.add("checkbox { preferredSize : [-1,20] , alignment :  [ 'left','top' ] ,text : 'Close Comp' }"); 
        

        //マスターウインドウ。
        mPorW.mTbp = mPorW.add("panel { type : 'tabbedpanel' ,margins : [0, 0, 0, 0], spacing : 0,preferredSize : [190, 250]\
        mTb1 : Panel{ type : 'tab' , text : 'S' ,margins : [5, 5, 5, 5], spacing : 5, alignment :  [ 'left','top' ] , properties:{name:'S'} , }\
        mTb2 : Panel{ type : 'tab' , text : 'A' ,margins : [5, 5, 5, 5], spacing : 5, alignment :  [ 'left','top' ] , properties:{name:'A'} , }\
        mTb3 : Panel{ type : 'tab' , text : 'D' ,margins : [5, 5, 5, 5], spacing : 5, alignment :  [ 'left','top' ] , properties:{name:'D'} , }\
        mTb4 : Panel{ type : 'tab' , text : 'P' ,margins : [5, 5, 5, 5], spacing : 5, alignment :  [ 'left','top' ] , properties:{name:'P'} , }\
        mTb5 : Panel{ type : 'tab' , text : 'R' ,margins : [5, 5, 5, 5], spacing : 5, alignment :  [ 'left','top' ] , properties:{name:'R'} , }}");
        
        
        //Sタブ。
        mPorW.mGpCps1 = mPorW.mTbp.mTb1.add("group { orientation : 'row', alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 20}");
        mPorW.mGpBts1 = mPorW.mGpCps1.add("group { orientation : 'column',alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 0}");
        mPorW.mBtCpy = mPorW.mGpBts1.add("button { preferredSize : [60,20] ,  text : 'Copy' }");
        mPorW.mBtCpyExp = mPorW.mGpBts1.add("button { preferredSize : [60,20] ,  text : 'Copy Exp' }");
        mPorW.mTbp.mTb1.add("panel { preferredSize : [180,0] }");
        mPorW.mBtPst = mPorW.mTbp.mTb1.add("button { preferredSize : [60,20] , alignment :  [ 'left','top' ] , text : 'Paste' }");
        
        //Aタブ。
        mPorW.mGpCps2 = mPorW.mTbp.mTb2.add("group { orientation : 'row', alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 20}");
        mPorW.mGpBts2 = mPorW.mGpCps2.add("group { orientation : 'column',alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 0}");
        mPorW.mBtCpyAtr = mPorW.mGpBts2.add("button { preferredSize : [60,20] ,  text : 'Copy Attr' }");
        mPorW.mTbp.mTb2.add("panel { preferredSize : [180,0] }"); 
        mPorW.mBtPstAtr = mPorW.mTbp.mTb2.add("button { preferredSize : [60,20] , alignment :  [ 'left','top' ] , text : 'Paste Atrr' }");
        mPorW.mGpCbs1 = mPorW.mTbp.mTb2.add("group { alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 0}");
        mPorW.mCbMd = mPorW.mGpCbs1.add("checkbox { preferredSize : [60,20] , text : 'Mode' }");
        mPorW.mCbMt = mPorW.mGpCbs1.add("checkbox { preferredSize : [60,20] , text : 'Matte' }");
        mPorW.mCbClp = mPorW.mGpCbs1.add("checkbox { preferredSize : [60,20] , text : 'Collapse' }");
        mPorW.mGpCbs2 = mPorW.mTbp.mTb2.add("group { alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 0}");
        mPorW.mCbEft = mPorW.mGpCbs2.add("checkbox { preferredSize : [60,20] , text : 'EffectsA' }");
        mPorW.mCbFb = mPorW.mGpCbs2.add("checkbox { preferredSize : [60,20] , text : 'FBlend' }");
        mPorW.mCbMb = mPorW.mGpCbs2.add("checkbox { preferredSize : [60,20] , text : 'MBlur' }");
        mPorW.mGpCbs3 = mPorW.mTbp.mTb2.add("group { alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 0}");
        mPorW.mCbALyr = mPorW.mGpCbs3.add("checkbox { preferredSize : [60,20] , text : 'Adjust' }");   
        mPorW.mCb3D = mPorW.mGpCbs3.add("checkbox { preferredSize : [60,20] , text : '3D' }");    
        mPorW.mCbPrt = mPorW.mGpCbs3.add("checkbox { preferredSize : [60,20] , text : 'Parent' }");
        
        //Dタブ。
        mPorW.mGpCps3 = mPorW.mTbp.mTb3.add("group { orientation : 'row', alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 20}");
        mPorW.mGpBts3 = mPorW.mGpCps3.add("group { orientation : 'column',alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 0}");
        mPorW.mBtDel = mPorW.mGpBts3.add("button { preferredSize : [60,20] , alignment :  [ 'left','top' ] , text : 'Del Layer' }");
        
        //Pタブ。
        mPorW.mGpCps4 = mPorW.mTbp.mTb4.add("group { orientation : 'row', alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 20}");
        mPorW.mGpBts4 = mPorW.mGpCps4.add("group { orientation : 'column',alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 5}");
        mPorW.mBtCpyPrp = mPorW.mGpBts4.add("button { preferredSize : [80,20] ,alignment :  [ 'left','top' ] ,   text : 'Get Prop' }");
        mPorW.mGpPrp = mPorW.mGpBts4.add("group { orientation : 'column',alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 0}");
        mPorW.mGpPrp.add("staticText { preferredSize : [120,20] , alignment :  [ 'left','top' ] , text : 'Enabled'}");
        mPorW.mGpPrp1 = mPorW.mGpBts4.add("group { orientation : 'row',alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 0}");        
        mPorW.mCbPrp = mPorW.mGpPrp1.add("checkbox { preferredSize : [-1,20] , text : '' ,helpTip:'Enabled'}"); 
        mPorW.mEtPrp = mPorW.mGpPrp1.add("editText { preferredSize : [160,20] , alignment :  [ 'left','top' ] , text : 'matchName', helpTip: 'matchName' }");
        mPorW.mGpPrp2 = mPorW.mGpBts4.add("group { orientation : 'row',alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 0}"); 
        mPorW.mCbPrpN = mPorW.mGpPrp2.add("checkbox { preferredSize : [-1,20] , text : '' ,helpTip:'Enabled'}"); 
        mPorW.mEtPrpN = mPorW.mGpPrp2.add("editText { preferredSize : [160,20] , alignment :  [ 'left','top' ] , text : 'name' , helpTip: 'name' }");
        //mPorW.mCbPrpNIncl = mPorW.mGpPrp2.add("checkbox { preferredSize : [-1,20] , text : 'Incl' ,helpTip:'Incl'}");      
        mPorW.mGpPrp3 = mPorW.mGpBts4.add("group { orientation : 'row',alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 0}"); 
        mPorW.mCbPrpIdx = mPorW.mGpPrp3.add("checkbox { preferredSize : [-1,20] , text : '' ,helpTip:'Enabled'}"); 
        mPorW.mEtPrpIdx = mPorW.mGpPrp3.add("editText { preferredSize : [160,20] , alignment :  [ 'left','top' ] , text : 'prop Index' , helpTip: 'prop Index' }");
        mPorW.mGpPrp4 = mPorW.mGpBts4.add("group { orientation : 'row',alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 0}"); 
        mPorW.mCbPrpDpt = mPorW.mGpPrp4.add("checkbox { preferredSize : [-1,20] , text : '' ,helpTip:'Enabled'}"); 
        mPorW.mEtPrpDpt = mPorW.mGpPrp4.add("editText { preferredSize : [160,20] , alignment :  [ 'left','top' ] , text : 'prop Depth' , helpTip: 'prop Depth' }");
        mPorW.mTbp.mTb4.add("panel { preferredSize : [180,0] }"); 
        mPorW.mBtDelPrp = mPorW.mTbp.mTb4.add("button { preferredSize : [80,20] , alignment :  [ 'left','top' ] , text : 'Del Prop' }");  
        mPorW.mBtDelKey = mPorW.mTbp.mTb4.add("button { preferredSize : [80,20] , alignment :  [ 'left','top' ] , text : 'Del Time Key' }");    
        mPorW.mBtDelKeyAll= mPorW.mTbp.mTb4.add("button { preferredSize : [80,20] , alignment :  [ 'left','top' ] , text : 'Del All Key' }");
        mPorW.mCbPrp.value = true
        mPorW.mCbPrpN.value = true;
        mPorW.mEtPrpIdx.enabled = false;
        mPorW.mEtPrpDpt.enabled = false;
        
        //Rタブ。
        mPorW.mGpCps5 = mPorW.mTbp.mTb5.add("group { orientation : 'row', alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 20}");
        mPorW.mGpBts5 = mPorW.mGpCps5.add("group { orientation : 'column',alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 5}");
        mPorW.mBtCpySrc = mPorW.mGpBts5.add("button { preferredSize : [80,20] ,alignment :  [ 'left','top' ],  text : 'Get Source ID' }");
        mPorW.mGpRpc = mPorW.mGpBts5.add("group { alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0],spacing : 0}");
        mPorW.mEtRpc = mPorW.mGpRpc.add("editText { preferredSize : [180,20] , alignment :  [ 'left','top' ] , text : '' }");
        mPorW.mTbp.mTb5.add("panel { preferredSize : [180,0] }"); 
        mPorW.mBtRpcSrc = mPorW.mTbp.mTb5.add("button { preferredSize : [80,20] , alignment :  [ 'left','top' ] , text : 'Replace' }");  
        
        
        //属性コピペ用変数群。
        mPorW.mIdcTime = 0;
        mPorW.mMode = BlendingMode.NORMAL;
        mPorW.mMatte = TrackMatteType.NO_TRACK_MATTE;
        mPorW.mClps = false;
        mPorW.mEftAct = true;
        mPorW.mFrmBrnd = FrameBlendingType.NO_FRAME_BLEND;
        mPorW.mMBlur = false;
        mPorW.mAjstLyr = false;
        mPorW.m3D = false;
        mPorW.mPrt = null;
            
        //タブとエディットテキストの連動用関数。
        mPorW.mTbp.onChange =function(){
            if( mPorW.mTbp.selection !== null ){
                if( mPorW.mTbp.selection.properties.name === "S" ){
                    mPorW.mGpIdx.enabled = true;
                    mPorW.mGpFrm.enabled = true;
                    mPorW.mGpSft.enabled = true;
                }else if( mPorW.mTbp.selection.properties.name === "A" ){
                    mPorW.mGpIdx.enabled = true;
                    mPorW.mGpFrm.enabled = false;
                    mPorW.mGpSft.enabled = false;
                }else if( mPorW.mTbp.selection.properties.name === "D" ){
                    mPorW.mGpIdx.enabled = true;
                    mPorW.mGpFrm.enabled = false;
                    mPorW.mGpSft.enabled = false;
                }else if( mPorW.mTbp.selection.properties.name === "P" ){
                    mPorW.mGpIdx.enabled = true;
                    mPorW.mGpFrm.enabled = true;
                    mPorW.mGpSft.enabled = true;
                }else if( mPorW.mTbp.selection.properties.name === "R" ){
                    mPorW.mGpIdx.enabled = true;
                    mPorW.mGpFrm.enabled = false;
                    mPorW.mGpSft.enabled = false;
                }
            }
        }

        //PタブのEnabled連動用関数。
        mPorW.mCbPrp.onClick = function (){
            mPorW.mEtPrp.enabled = mPorW.mCbPrp.value;
            if( mPorW.mCbPrpN.value === false && mPorW.mCbPrp.value === false ){
                mPorW.mCbPrpN.value = true;
                mPorW.mEtPrpN.enabled = true;
            }
        }
        mPorW.mCbPrpN.onClick = function (){
            mPorW.mEtPrpN.enabled = mPorW.mCbPrpN.value;
            //mPorW.mCbPrpNIncl.enabled = mPorW.mCbPrpN.value;
            if( mPorW.mCbPrpN.value === false && mPorW.mCbPrp.value === false ){
                mPorW.mCbPrp.value = true;
                mPorW.mEtPrp.enabled = true;
            }    
        }
        mPorW.mCbPrpIdx.onClick = function (){ mPorW.mEtPrpIdx.enabled = mPorW.mCbPrpIdx.value;}
        mPorW.mCbPrpDpt.onClick = function (){ mPorW.mEtPrpDpt.enabled = mPorW.mCbPrpDpt.value;}
        
        
        return mPorW;

    }
    //------------------------------------------------------------------------
    //mPnlという名でメインウインドウを作成。
    var mPnl = mCreateUI(aGbl);
    if (mPnl instanceof Window) {
        mPnl.center();
        mPnl.show();
    } else if (mPnl instanceof Panel) {
        //UIパネルの場合は以下をしないと自動レイアウトされない。
        mPnl.layout.layout(true);
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    mPnl.mBtCpy.onClick = function () {
        app.executeCommand(19);
        var mAi = app.project.activeItem;
        var mSl = mAi.selectedLayers[0];
        if(mPnl.mCbWithIdx.value=== false){ mPnl.mEtIdx.text = mSl.index.toString();}
        if(mPnl.mCbWithT.value=== false){
             if(mPnl.mBtFrm.text === "TC"){
                 mPnl.mEtFrm.text = mTtoTC(mAi.time, mAi);
             }else if(mPnl.mBtFrm.text === "F"){
                 mPnl.mEtFrm.text = mTtoF(mAi.time, mAi);
            }
        }
    }
    mPnl.mBtCpyExp.onClick = function () {
        app.executeCommand(53);
        var mAi = app.project.activeItem;
        var mSl = mAi.selectedLayers[0];
        if(mPnl.mCbWithIdx.value=== false){ mPnl.mEtIdx.text = mSl.index.toString();}
        if(mPnl.mCbWithT.value=== false){
             if(mPnl.mBtFrm.text === "TC"){
                 mPnl.mEtFrm.text = mTtoTC(mAi.time, mAi);
             }else if(mPnl.mBtFrm.text === "F"){
                 mPnl.mEtFrm.text = mTtoF(mAi.time, mAi);
            }
        }
    }
    mPnl.mBtCpyAtr.onClick = function () {
        app.beginUndoGroup("Copy Attr");
        var mAi = app.project.activeItem;
        var mSl = mAi.selectedLayers[0];
        if(mPnl.mCbWithIdx.value=== false){ mPnl.mEtIdx.text = mSl.index.toString();}
        if(mPnl.mCbWithT.value=== false){
             if(mPnl.mBtFrm.text === "TC"){
                 mPnl.mEtFrm.text = mTtoTC(mAi.time, mAi);
             }else if(mPnl.mBtFrm.text === "F"){
                 mPnl.mEtFrm.text = mTtoF(mAi.time, mAi);
            }
        }
        
        mPnl.mMode = mSl.blendingMode;
        mPnl.mMatte = mSl.trackMatteType;
        mPnl.mClps = mSl.collapseTransformation;
        mPnl.mEftAct = mSl.effectsActive;
        mPnl.mFrmBrnd = mSl.frameBlendingType;
        mPnl.mMBlur = mSl.motionBlur;
        mPnl.mAjstLyr = mSl.adjustmentLayer;
        mPnl.m3D = mSl.threeDLayer ;
        //親子については、インデックスで処理する仕様にする。
        if( mSl.parent !== null ){ mPnl.mPrt = mSl.parent.index;}
        else{mPnl.mPrt = null;}
        
        app.endUndoGroup();
    }

    mPnl.mBtCpyPrp.onClick = function () {
        app.beginUndoGroup("Copy DelKeyProp");
        
        var mAi = app.project.activeItem;
        var mSl = mAi.selectedLayers[0];
        if(mPnl.mCbWithIdx.value=== false){ mPnl.mEtIdx.text = mSl.index.toString();}
        if(mPnl.mCbWithT.value=== false){
             if(mPnl.mBtFrm.text === "TC"){
                 mPnl.mEtFrm.text = mTtoTC(mAi.time, mAi);
             }else if(mPnl.mBtFrm.text === "F"){
                 mPnl.mEtFrm.text = mTtoF(mAi.time, mAi);
            }
        }
        var mSps = mSl.selectedProperties;
        //選択プロップが２つ以上ある場合は最後のものにする。
        var mSp = mSps[mSps.length-1];
        mPnl.mEtPrp.text = mSp.matchName;
        mPnl.mEtPrpN.text = mSp.name;
        mPnl.mEtPrpIdx.text = mSp.propertyIndex;
        mPnl.mEtPrpDpt.text = mSp.propertyDepth;

        app.endUndoGroup();
    }

    mPnl.mBtCpySrc.onClick = function () {
        app.beginUndoGroup("Copy Source");
        var mAi = app.project.activeItem;
        mPnl.mEtRpc.text = mAi.id;
        
        //ビューワーによってアクティブアイテムをタイムラインコンポに切り替える。
        app.activeViewer.setActive();
        var mAi = app.project.activeItem;
        var mSl = mAi.selectedLayers[0];
        if(mPnl.mCbWithIdx.value=== false){ mPnl.mEtIdx.text = mSl.index.toString();}
        if(mPnl.mCbWithT.value=== false){
             if(mPnl.mBtFrm.text === "TC"){
                 mPnl.mEtFrm.text = mTtoTC(mAi.time, mAi);
             }else if(mPnl.mBtFrm.text === "F"){
                 mPnl.mEtFrm.text = mTtoF(mAi.time, mAi);
            }
        }
        app.endUndoGroup();
    }


    //--------------------------------------------------------------------------------------------------------------------------------------------------
    mPnl.mBtPst.onClick = function () { mPaste(false);}
    mPnl.mBtPstAtr.onClick = function () { mPaste(true);} 
    function mPaste(aAttrOrNot){
        app.beginUndoGroup("Paste");
        
        var mLyrIdx = parseInt(mPnl.mEtIdx.text);
        var mSel = app.project.selection;
        var mTimeTxt = mPnl.mEtFrm.text;

        //選択した複数コンポについて、全レイヤーの選択を外す。
        for (var i = 0; i < mSel.length; i++) {
            var mCmp = mSel[i];
            for (var j = 1; j <= mCmp.numLayers; j++) {
                var mLyr = mCmp.layer(j);
                mLyr.selected = false;
            }
        }

        for (var i = 0; i < mSel.length; i++) {
            var mCmp = mSel[i];
            mCmp.openInViewer();
            
            //各コンポ内の時間を設定する。
            //もしもボタンがT（TC）ならばテキストはTC表示なので、TCチェックtrueのTime尺を得る。
            if (mPnl.mBtFrm.text == "TC") {
                var mIdcTime = mGetTimeFromEtStr(mTimeTxt, mCmp, true);
                //もしもボタンがFならばテキストはF表示なので、、TCチェックfalseのTime尺を得る。
            } else if (mPnl.mBtFrm.text == "F") {
                var mIdcTime = mGetTimeFromEtStr(mTimeTxt, mCmp, false);
            }
            //シフト尺（フレーム）からシフト尺（秒）を得る。
            var mSftT = mGetTimeFromEtStr( mPnl.mEtISft.text, mCmp, false);
            //シフト時間に応じてずらす。
            //ずらしてペーストする場合、たいがいコピー元は含まないので最初から１単位ずらす仕様にする。
            mCmp.time = mIdcTime + mSftT * (i+1) ;

            //もしも指定番号がレイヤー総数よりも大きな数の場合、
            //ラスト番号にヌルを追加、それを選択してペースト、ヌルを消す。
            //パラメータのペーストだった場合、消す予定のヌルにペーストなので無意味なこととなる。
            if( mCmp.layers.length < mLyrIdx ){
                var mTgtLyr = mCmp.layers.addNull();
                mTgtLyr.moveToEnd();
                mTgtLyr.selected = true;
                if( aAttrOrNot ){ mPasteAttr(mTgtLyr);}
                else{ app.executeCommand(20);}
                mTgtLyr.source.remove();
            }else{
                var mTgtLyr = mCmp.layer(mLyrIdx);
                mTgtLyr.selected = true;
                if( aAttrOrNot ){ mPasteAttr(mTgtLyr);}
                else{ app.executeCommand(20);}
            }
            //チェックがあればコンポを閉じる。
            mCloseCmp();
        }
        app.endUndoGroup();
        
        function mPasteAttr(aSl){
            var mSl = aSl;
            var mUdfd = void 0;
            //チェックがあり、変数に入っているものがundefinedではなく、mSl.xxがある場合は代入する。
            if( mPnl.mCbMd.value && mPnl.mMode !== mUdfd && mSl.blendingMode !== mUdfd ){mSl.blendingMode = mPnl.mMode;}
            if( mPnl.mCbMt.value && mPnl.mMatte !== mUdfd && mSl.trackMatteType !== mUdfd  ){mSl.trackMatteType = mPnl.mMatte;}
            //コラップスは可能かどうかを判定して入れる。
            if( mPnl.mCbClp.value && mPnl.mClps!== mUdfd && mSl.collapseTransformation !== mUdfd ){
                 if( mSl.canSetCollapseTransformation){ mSl.collapseTransformation = mPnl.mClps;}
            }
            if( mPnl.mCbEft.value && mPnl.mEftAct !== mUdfd && mSl.effectsActive !== mUdfd ){mSl.effectsActive = mPnl.mEftAct;}
            if( mPnl.mCbFb.value && mPnl.mFrmBrnd !== mUdfd && mSl.frameBlendingType !== mUdfd ){mSl.frameBlendingType = mPnl.mFrmBrnd;}
            if( mPnl.mCbMb.value && mPnl.mMBlur !== mUdfd && mSl.motionBlur !== mUdfd ){mSl.motionBlur = mPnl.mMBlur;}
            if( mPnl.mCbALyr.value && mPnl.mAjstLyr !== mUdfd && mSl.adjustmentLayer !== mUdfd ){mSl.adjustmentLayer = mPnl.mAjstLyr;}
            if( mPnl.mCb3D.value && mPnl.m3D !== mUdfd && mSl.threeDLayer !== mUdfd ){mSl.threeDLayer = mPnl.m3D;}
            if( mPnl.mCbPrt.value && mPnl.mPrt !== mUdfd && mSl.parent !== mUdfd ){
                if( mPnl.mPrt !== null ){ mSl.parent = mCmp.layer(parseInt( mPnl.mPrt) );}
            }
        }
    }
    //------------------------------------------------------------------------
    mPnl.mBtDel.onClick = function () {
        app.beginUndoGroup("Del");
        var mLyrIdx = parseInt(mPnl.mEtIdx.text);
        var mSel = app.project.selection;
        for (var i = 0; i < mSel.length; i++) {
            var mCmp = mSel[i];
            mCmp.openInViewer();
            //もしも番号がレイヤー総数以上であればこのコンポについては何もしない。
            if( mCmp.layers.length < mLyrIdx ){ mCloseCmp(); continue;}
            var mTgtLyr = mCmp.layer(mLyrIdx);
            mTgtLyr.remove();
            //チェックがあればコンポを閉じる。
            mCloseCmp();
        }
        app.endUndoGroup();
    }
    //------------------------------------------------------------------------
    mPnl.mBtDelKey.onClick = function () {
        app.beginUndoGroup("DelKey");
        var mLyrIdx = parseInt(mPnl.mEtIdx.text);
        var mSel = app.project.selection;
        var mTimeTxt = mPnl.mEtFrm.text;
        
        //マッチネームと、マッチするかの関数を作っておく。
        var mFuncs = mToMakeFuncs();
   
        for (var i = 0; i < mSel.length; i++) {
            var mCmp = mSel[i];
            mCmp.openInViewer();
            
            //各コンポ内の時間を設定する。
            //もしもボタンがT（TC）ならばテキストはTC表示なので、TCチェックtrueのTime尺を得る。
            if (mPnl.mBtFrm.text == "TC") {
                var mIdcTime = mGetTimeFromEtStr(mTimeTxt, mCmp, true);
                //もしもボタンがFならばテキストはF表示なので、、TCチェックfalseのTime尺を得る。
            } else if (mPnl.mBtFrm.text == "F") {
                var mIdcTime = mGetTimeFromEtStr(mTimeTxt, mCmp, false);
            }
            //シフト尺（フレーム）からシフト尺（秒）を得る。
            var mSftT = mGetTimeFromEtStr( mPnl.mEtISft.text, mCmp, false);
            //シフト時間に応じてずらす。
            //ずらしてペーストする場合、たいがいコピー元は含まないので最初から１単位ずらす仕様にする。
            mCmp.time = mIdcTime + mSftT * (i+1) ;       

            //もしも番号がレイヤー総数以上であればこのコンポについては何もしない。
            if( mCmp.layers.length < mLyrIdx ){mCloseCmp(); continue;}
            var mTgtLyr = mCmp.layer(mLyrIdx);
            
            //該当レイヤーからプロパティを探す。
            var mMchPropAry = mGetAllPropsFromOgl( mTgtLyr, mFuncs );
            if(mMchPropAry.length === 0){ mCloseCmp(); continue;}
            var mProp = mMchPropAry[0];
            //キーが無ければ何もしない。
            if(mProp.numKeys === 0){mCloseCmp(); continue;}
            var mKeyIdx = mProp.nearestKeyIndex(mCmp.time);
            if( mProp.keyTime(mKeyIdx) === mCmp.time ){
               mProp.removeKey(mKeyIdx);
            }
            //チェックがあればコンポを閉じる。
            mCloseCmp();
        }
        app.endUndoGroup();
    }
    //------------------------------------------------------------------------
    mPnl.mBtDelKeyAll.onClick = function () {
        app.beginUndoGroup("DelKeyAll");
        var mLyrIdx = parseInt(mPnl.mEtIdx.text);
        var mSel = app.project.selection;
        var mTimeTxt = mPnl.mEtFrm.text;
        
        //マッチネームと、マッチするかの関数を作っておく。
        var mFuncs = mToMakeFuncs();

        for (var i = 0; i < mSel.length; i++) {
            var mCmp = mSel[i];
            mCmp.openInViewer();
                    
             //各コンポ内の時間を設定する。
            //もしもボタンがT（TC）ならばテキストはTC表示なので、TCチェックtrueのTime尺を得る。
            if (mPnl.mBtFrm.text == "TC") {
                var mIdcTime = mGetTimeFromEtStr(mTimeTxt, mCmp, true);
                //もしもボタンがFならばテキストはF表示なので、、TCチェックfalseのTime尺を得る。
            } else if (mPnl.mBtFrm.text == "F") {
                var mIdcTime = mGetTimeFromEtStr(mTimeTxt, mCmp, false);
            }
            //シフト尺（フレーム）からシフト尺（秒）を得る。
            var mSftT = mGetTimeFromEtStr( mPnl.mEtISft.text, mCmp, false);
            //シフト時間に応じてずらす。
             //ずらしてペーストする場合、たいがいコピー元は含まないので最初から１単位ずらす仕様にする。
            mCmp.time = mIdcTime + mSftT * (i+1) ;
                    
            //もしも番号がレイヤー総数以上であればこのコンポについては何もしない。
            if( mCmp.layers.length < mLyrIdx ){mCloseCmp(); continue;}
            var mTgtLyr = mCmp.layer(mLyrIdx);
            
            //該当レイヤーから、マッチネームでプロパティを探す。
            var mMchPropAry = mGetAllPropsFromOgl( mTgtLyr, mFuncs );
            if(mMchPropAry.length === 0){mCloseCmp(); continue;}
            var mProp = mMchPropAry[0];
            //キーが無ければ何もしない。
            if(mProp.numKeys === 0){mCloseCmp(); continue;}
            //該当時間の値を取っておく(エクスプレッション前の値とする仕様にする)。
            var mTimeVal = mProp.valueAtTime(mCmp.time, true);
            //全てのキーを消す。
            for (var j = mProp.numKeys; j >=1 ; j--) {
                mProp.removeKey(j);
            }
            //該当時間の値にする。
            mProp.setValue(mTimeVal);
            
            //チェックがあればコンポを閉じる。
            mCloseCmp();
                
        }
        app.endUndoGroup();
    }
    //------------------------------------------------------------------------
    mPnl.mBtDelPrp.onClick = function () {
        app.beginUndoGroup("DelPrp");
        var mLyrIdx = parseInt(mPnl.mEtIdx.text);
        var mSel = app.project.selection;
        var mTimeTxt = mPnl.mEtFrm.text;
        
        //マッチネームと、マッチするかの関数を作っておく。
        var mFuncs = mToMakeFuncs();
        
        for (var i = 0; i < mSel.length; i++) {
            var mCmp = mSel[i];
            mCmp.openInViewer();

            //もしも番号がレイヤー総数以上であればこのコンポについては何もしない。
            if( mCmp.layers.length < mLyrIdx ){mCloseCmp(); continue;}
            var mTgtLyr = mCmp.layer(mLyrIdx);
            
            //該当レイヤーから、マッチネームでプロパティを探す。
            var mMchPropAry = mGetAllPropsFromOgl( mTgtLyr, mFuncs );
            if(mMchPropAry.length === 0){mCloseCmp(); continue;}
            var mProp = mMchPropAry[0];
            
            //もしもプロップが削除可能（親がPropertyType.INDEXED_GROUP）であれば削除する。
            if( mProp.propertyGroup(1).propertyType === PropertyType.INDEXED_GROUP ){
                mProp.remove();
            }
        
            //チェックがあればコンポを閉じる。
            mCloseCmp();  
        }
        app.endUndoGroup();
    }
    //------------------------------------------------------------------------
    //プロップタブで共通して使う、検索条件用関数を生成する関数。
    function mToMakeFuncs(){
        var mFuncs = [];
        if( mPnl.mCbPrp.value ){
            var mMtcN = mPnl.mEtPrp.text;
            function mFunc1(aProp){
                if( aProp.matchName === mMtcN ){ return true; }
                else{ return false; }
            }
            mFuncs.push( mFunc1 );
        }
        if( mPnl.mCbPrpN.value ){
            var mName = mPnl.mEtPrpN.text;
            function mFunc2(aProp){
                if( aProp.name === mName ){ return true; }
                else{ return false; }
            }
            mFuncs.push( mFunc2 );
        }
        if( mPnl.mCbPrpIdx.value ){
            var mIdx = parseInt( mPnl.mEtPrpIdx.text);
            function mFunc3(aProp){
                if( aProp.propertyIndex === mIdx ){ return true; }
                else{ return false; }
            }
            mFuncs.push( mFunc3 );
        }
        if( mPnl.mCbPrpDpt.value ){
            var mDpt = parseInt( mPnl.mEtPrpDpt.text);
            function mFunc4(aProp){
                if( aProp.propertyDepth === mDpt ){ return true; }
                else{ return false; }
            }
            mFuncs.push( mFunc4 );
        }
        return mFuncs;
    }
    //------------------------------------------------------------------------
    mPnl.mBtRpcSrc.onClick = function () {
        app.beginUndoGroup("ReplaceSource");
        var mLyrIdx = parseInt(mPnl.mEtIdx.text);
        var mSel = app.project.selection;
        
        var mSrcID = parseInt( mPnl.mEtRpc.text );
        var mPjt = app.project;
        var mSrc = null;
        for (var i = 1; i <= mPjt.numItems; i++) {
            var mItm = mPjt.item(i);
            if( mItm.id === mSrcID ){
                mSrc = mItm;
                break;
            }
        }
        //ソースIDからソースが見つからなければリターンする。
        if( mSrc === null ){ return;}

        for (var i = 0; i < mSel.length; i++) {
            var mCmp = mSel[i];
            mCmp.openInViewer();

            //もしも番号がレイヤー総数以上であればこのコンポについては何もしない。
            if( mCmp.layers.length < mLyrIdx ){mCloseCmp(); continue;}
            var mTgtLyr = mCmp.layer(mLyrIdx);
            
            if( mTgtLyr.hasOwnProperty( "source" ) ){
                mTgtLyr.replaceSource(mSrc, true);
            }
        
            //チェックがあればコンポを閉じる。
            mCloseCmp(); 
        
        }
        app.endUndoGroup();
    }
    //------------------------------------------------------------------------
    //コンポを閉じる関数。continueが多いので関数化する。
    function mCloseCmp(){
        if( mPnl.mCbClose.value ){app.executeCommand(4);}  
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //TCとFの変換ボタン。
    mPnl.mBtFrm.onClick = function () {
        app.beginUndoGroup("ConvertTime");

        var mAi = app.project.activeItem;
        var mTxt = mPnl.mEtFrm.text;

        //もしもボタンがTCならばテキストはTC表示なので、mConvertTime関数でFに変換する。
        if (mPnl.mBtFrm.text == "TC") {
            var mTimeTmp = mConvertTime(mTxt, mAi, true);
            mPnl.mEtFrm.text = mTimeTmp;
            //ボタン自身の文字も変える。
            mPnl.mBtFrm.text = "F";
            //もしもボタンがFならばテキストはF表示なので、mConvertTime関数でTCに変換する。    
        } else if (mPnl.mBtFrm.text == "F") {
            var mTimeTmp = mConvertTime(mTxt, mAi, false);
            mPnl.mEtFrm.text = mTimeTmp;
            //ボタン自身の文字も変える。
            mPnl.mBtFrm.text = "TC";
        }

        app.endUndoGroup();
        //------------------------------------------------------------------------- 
        //セッティングブロック。変更した要素をセーブする。
        //mSaveSetting(mPnl.mPref1, mPnl.mEtFrm.text);
        //mSaveSetting(mPnl.mPref2, mPnl.mBtFrm.text);
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    /*
    //セッティング関連関数（オブジェクト引数版）。
    //mSecとmKeyという要素を持つObjを作って、それを入れて使う。
    //----------------------------------------------------------
    //設定があればそれを返す関数。
    function mGetSetting(aPrefObj) {
        var mPrefObj = aPrefObj;
        if (app.settings.haveSetting(mPrefObj.mSec, mPrefObj.mKey) === false) {
            return null;
        } else {
            return app.settings.getSetting(mPrefObj.mSec, mPrefObj.mKey);
        }
    }
    //----------------------------------------------------------
    //引数を設定に保存する関数。
    function mSaveSetting(aPrefObj, aValue) {
        var mPrefObj = aPrefObj;
        app.settings.saveSetting(mPrefObj.mSec, mPrefObj.mKey, aValue);
    }
    */
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //TC関連関数。

    //文字列（エディットテキスト）からTime尺を得る。
    //aTCorFは文字列をTCとするか、Fとするか。
    function mGetTimeFromEtStr(aStr, aAi, aTCorF) {
        var mAi = aAi;
        var mTxt = aStr;
        var mTCorF = aTCorF;

        //もしも表示形式がフレームであれば、一時的にタイムコードにしておく。
        var mTdtFRAMESorNot = false;
        if (app.project.timeDisplayType === TimeDisplayType.FRAMES) {
            app.project.timeDisplayType = TimeDisplayType.TIMECODE;
            mTdtFRAMESorNot = true;
        }

        //もしもチェックがTCならばテキストはTC表示なので、Timeに変換する。
        if (mTCorF === true) {
            var mTimeTmp = mTCtoT(mTxt, mAi);
            //もしもチェックがFならばテキストはF表示なので、Timeに変換する。
        } else {
            var mTimeTmp = mFtoT(mTxt, mAi);
        }

        //もしも元の表示形式がフレームであったならば、元に戻す。
        if (mTdtFRAMESorNot === true) {
            app.project.timeDisplayType = TimeDisplayType.FRAMES;
        }

        return mTimeTmp;
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //TCとFを変換する（Time経由）。
    //aTCorFは、引数aStrがTCかFかで、戻り値は引数とは逆のフォーマットとなる。
    function mConvertTime(aStr, aAi, aTCorF) {
        var mAi = aAi;
        var mTxt = aStr;
        var mTCorF = aTCorF;

        //もしも表示形式がフレームであれば、一時的にタイムコードにしておく。
        var mTdtFRAMESorNot = false;
        if (app.project.timeDisplayType == TimeDisplayType.FRAMES) {
            app.project.timeDisplayType = TimeDisplayType.TIMECODE;
            mTdtFRAMESorNot = true;
        }

        //もしもチェックがTCならばテキストはTC表示なので、Time経由でFに変換する。
        if (mTCorF === true) {
            var mTimeTmp = mTCtoT(mTxt, mAi);
            mTimeTmp = mTtoF(mTimeTmp, mAi);
            //もしもチェックがFならばテキストはF表示なので、Time経由でTCに変換する。    
        } else {
            var mTimeTmp = mFtoT(mTxt, mAi);
            mTimeTmp = mTtoTC(mTimeTmp, mAi);
        }

        //もしも元の表示形式がフレームであったならば、元に戻す。
        if (mTdtFRAMESorNot === true) {
            app.project.timeDisplayType = TimeDisplayType.FRAMES;
        }

        return mTimeTmp;
    }
    //-----------------------------------------------------------------------
    //-----------------------------------------------------------------------
    //タイム                     秒基準の10進数
    //タイムコードTC       各単位の各進数
    //フレームF                 フレーム基準の10進数

    //カレントフォーマットをタイムに変換。
    //currentFormatToTimeに、フォーマットになっていない文字列（aとかbとか）を入れると0が返るので、エラー対策はしなくてよい。
    function mTCtoT(aTC, aAi) {
        var mAi = aAi;
        //フレームレート（１秒が何フレームあるか。29.97とか）。
        var mFps = mAi.frameRate;
        //1フレーム分の秒数（小数点）。
        var mFdtn = mAi.frameDuration;

        //カレントフォーマットをタイムに変換。
        var RstT = currentFormatToTime(aTC, mFps);

        return RstT;
    }
    //-----------------------------------------------------------------------
    //タイムをカレントフォーマットに変換。
    //中間経由関数で、入力するタイムが数字以外になることはないのでエラー対策はしない。
    function mTtoTC(aT, aAi) {
        var mAi = aAi;
        //フレームレート（１秒が何フレームあるか。29.97とか）。
        var mFps = mAi.frameRate;
        //1フレーム分の秒数（小数点）。
        var mFdtn = mAi.frameDuration;

        //タイムをカレントフォーマットに変換。
        var RstTC = timeToCurrentFormat(aT, mFps);

        return RstTC;
    }
    //-----------------------------------------------------------------------
    //フレームをタイムに変換。
    //文字列を入れ、文字列のまま処理すると戻り値がNaNになってしまうので、引数を数値に変換する。
    //数値変換の結果がNaNであれば、変化させないために戻り値をゼロにしておく。
    function mFtoT(aF, aAi) {
        var mAi = aAi;
        //フレームレート（１秒にフレームが何個あるか。29.97とか）。
        var mFps = mAi.frameRate;
        //1フレームの秒数（小数点）。
        var mFdtn = mAi.frameDuration;

        //引数の変換ブロック。
        var mF = parseFloat(aF);
        if (isNaN(mF) === true) { mF = 0; }

        //フレームをタイムに変換。１フレームの秒数＊フレーム個数で出る。
        var RstT = mFdtn * mF;

        return RstT;
    }
    //-----------------------------------------------------------------------
    //タイムをフレームに変換。
    //中間経由関数で、入力するタイムが数字以外になることはないのでエラー対策はしない。
    function mTtoF(aT, aAi) {
        var mAi = aAi;
        //フレームレート（１秒にフレームが何個あるか。29.97とか）。
        var mFps = mAi.frameRate;
        //1フレームの秒数（小数点）。
        var mFdtn = mAi.frameDuration;

        //フレームをタイムに変換。タイムの中に”１フレームの秒数”が何個あるか、で出る。割り切れない場合があるのでラウンドする。
        var RstF = Math.round(aT / mFdtn);

        return RstF;
    }
//--------------------------------------------------------------------------------------------------------------------------------------------------
//特定のプロパティ（レイヤーでも可）から始めて、条件合致した全てを配列に入れる関数。
//引数２には、引数にプロパティを入れたら真偽値を返す関数群の配列を入れる。１つであっても配列にすることに注意。
function mGetAllPropsFromOgl( aOglProp, aIfFuncs ) {
    var mOglProp = aOglProp;
    var mIfFuncs = aIfFuncs;

    //この空配列に、再帰関数内で要素が全て入る。
    var mRst = [];
    //最初の引数を入れて再帰関数を発動、終わったらmRstをリターン。
    mExecute(mOglProp);
    return mRst;
    
    //再帰関数。
    //最初の引数以外は上記関数内にある外部引数を使っていることに注意。
    function mExecute( aProp ) {
         //まずは自身を条件合致でmRstへ入れる。
         if( mSortAndTorF( aProp , mIfFuncs ) ){ mRst.push(aProp);}
        
        //プロパティタイプが子要素ありタイプならば、子要素について処理する。
        var mPropType = aProp.propertyType;
        if( mPropType ===  PropertyType.INDEXED_GROUP
        ||  mPropType ===  PropertyType.NAMED_GROUP){
            for (var i = 1; i <= aProp.numProperties; i++) {
                mExecute( aProp(i) );
            }
        }
    }
    
    function mSortAndTorF( aPropTmp , aIfFuncs ) {
        var mPropTmp = aPropTmp;
        var mIfFuncs = aIfFuncs;
        //プロパティを、真偽値を返す関数群が入った配列ループで回し、
        //関数ごとにプロパティを引数に入れて真偽値を更新していく。
        //一度でもfalseであればfalseをリターンする。
        //最後までたどり着いたら全てtrueなのでtrueをリターンする。
        for (var i = 0; i < mIfFuncs.length; i++) {
            if( mIfFuncs[i]( mPropTmp ) !== true ){ return false; }
        }
        return true;
    }
}
/*
//引数にする関数例。
function mFunc2(aProp){
    if( aProp.matchName === mPnl.mEtMn.text ){ return true; }
    else{ return false; }
}
*/
//--------------------------------------------------------------------------------------------------------------------------------------------------
}(this));
