﻿(function (aGbl) {
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //システム上のファイル名から名前を抜き出す。
    var mFileName = mGetSelfName();

    function mCreateUI(aObj) {
        var mPorW = (aObj instanceof Panel) ? aObj : new Window("palette", mFileName, undefined);
        mPorW.preferredSize = [200, 340];
        mPorW.margins = [10, 10, 10, 10];
        mPorW.spacing = 10;

        mPorW.mLtName = mPorW.add("listbox { preferredSize:  [180,270 ] }");

        mPorW.mGpOpts = mPorW.add("group { alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0]}");

        mPorW.mGpOpts1 = mPorW.mGpOpts.add("group { orientation : 'column' , alignment :  [ 'fill','top' ] , margins : [0, 0, 0, 0]}");
        mPorW.mGpOpts1.spacing = 5;
        mPorW.mGpWord = mPorW.mGpOpts1.add("group { alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0] }");
        mPorW.mGpWord.spacing = 0;
        mPorW.mStWord = mPorW.mGpWord.add("statictext { preferredSize : [-1,20] , text : 'Search' }");
        mPorW.mEtWord = mPorW.mGpWord.add("edittext { preferredSize : [60,20] , text : '.jsx' }");
        mPorW.mEtWord.addEventListener("changing", mRenewLst);

        mPorW.mGpChk = mPorW.mGpOpts1.add("group { alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0] }");
        mPorW.mCbSub = mPorW.mGpChk.add("checkbox {  preferredSize : [-1,20] , text : 'SubF' , value : false , helpTip : 'Subfolders'}");
        mPorW.mCbExt = mPorW.mGpChk.add("checkbox {   preferredSize : [-1,20] , text : 'Ext' , value : false , helpTip : 'Extension'}");

        mPorW.mGpOpts2 = mPorW.mGpOpts.add("group { orientation : 'column' , alignment :  [ 'fill','top' ] , margins : [0, 0, 0, 0]}");
        mPorW.mGpOpts2.spacing = 0;
        mPorW.mBtSel = mPorW.mGpOpts2.add("button { preferredSize : [60,20] , text : 'Select Path' }");
        mPorW.mBtRe = mPorW.mGpOpts2.add("button { preferredSize : [60,20], text : 'Reload' }");

        //フルパス保存用配列。
        mPorW.mFullPaths = [];

        return mPorW;
    }
    //mPnlという名でメインウインドウを作成。
    var mPnl = mCreateUI(aGbl);
    if (mPnl instanceof Window) {
        mPnl.center();
        mPnl.show();
    } else if (mPnl instanceof Panel) {
        //UIパネルの場合は以下をしないと自動レイアウトされない。
        mPnl.layout.layout(true);
    }

    //-------------------------------------------------------------------------
    //セッティング読み込みパート。

    //もしもサブフォルダ設定があれば適用する。
    if (app.settings.haveSetting(mFileName, "subFolder") === true) {
        mPnl.mCbSub.value = (app.settings.getSetting(mFileName, "subFolder") === "true");
    }

    //もしも拡張子設定があれば適用する。
    if (app.settings.haveSetting(mFileName, "Extension") === true) {
        mPnl.mCbExt.value = (app.settings.getSetting(mFileName, "Extension") === "true");
    }

    //もしも検索ワード設定があれば適用する。
    if (app.settings.haveSetting(mFileName, "word") === true) {
        mPnl.mEtWord.text = app.settings.getSetting(mFileName, "word");
    }

    //リストボックスにアイテムを追加する。
    mRenewLst();

    //-------------------------------------------------------------------------
    //セッティング保存兼各パーツの処理パート。
    mPnl.mBtRe.onClick = function () {
        //更新ボタンなので更新。
        mRenewLst();
    }
    mPnl.mBtSel.onClick = function () {
        //ファイル選択画面から選んだパスを保存する。
        var mChsedPth = Folder.selectDialog("Choose folder");
        if (mChsedPth === null) { return; }
        app.settings.saveSetting(mFileName, "path", mChsedPth.fsName);

        //パスが変わったので更新。
        mRenewLst();
    }
    mPnl.mCbSub.onClick = function () {
        //サブフォルダチェックを保存。
        app.settings.saveSetting(mFileName, "subFolder", mPnl.mCbSub.value.toString());
        //チェックが変わったので更新。
        mRenewLst();
    }
    mPnl.mCbExt.onClick = function () {
        //拡張子チェックを保存。
        app.settings.saveSetting(mFileName, "Extension", mPnl.mCbExt.value.toString());
        //チェックが変わったので更新。
        mRenewLst();
    }
    mPnl.mEtWord.onChange = function () {
        //検索ワードが変わったら保存。
        app.settings.saveSetting(mFileName, "word", mPnl.mEtWord.text);
        //検索ワードが変わったので更新。
        mRenewLst();
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //メイン処理パート。
    mPnl.mLtName.onDoubleClick = function () {
        //ネームリストとフルパス配列の順番は一緒なので、
        //選択ネームリストの番号からフルパスを得る（Objではなく文字列になっている）。
        var mFullPath = mPnl.mFullPaths[this.selection.index];
        //もしもフルパス名Objから得た名前に.jsxが含まれていたら、スクリプトを起動する。
        if (mFullPath.indexOf("jsx") != -1) {
            $.evalFile(mFullPath);
            //それ以外ならば、ファイルを読み込む。
        } else {
            var mFobj = new File(mFullPath);
            var mOptn = new ImportOptions(mFobj);
            app.project.importFile(mOptn);
        }
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //（ mGetNameAndFullPath()の内容が変わる状態なので ）リストボックスの中身を更新する。
    function mRenewLst() {
        var mTxts = mGetNameAndFullPath();

        //ファイル検索に１秒以上かかったらタイムアウトでnullが返るのでリターン。
        if (mTxts === null) { return; }

        //ネームのリストとフルパスの配列を更新する。
        mPnl.mLtName.removeAll();
        for (var i = 0; i < mTxts.mNames.length; i++) {
            mPnl.mLtName.add("item", mTxts.mNames[i]);
        }
        mPnl.mFullPaths = mTxts.mFullPaths;
        //-------------------------------------------------------------------------
        //以下、使用関数。
        //セッティングからネームとフルパスを得る。
        function mGetNameAndFullPath() {
            var mFpth = "";
            if (app.settings.haveSetting(mFileName, "path") == true) {
                mFpth = app.settings.getSetting(mFileName, "path");
            }

            //セッティングからファイルObj配列を得る。
            var mFileObjs = mGetFileObjs(mFpth);
            //もしもmFileObjsの再帰関数がタイムアウトしてNullが返ってきたら、Nullを返す。
            if (mFileObjs === null) { return null; }

            //検索ワードの空白を消して、コンマで配列に分ける。もしもコンマが無くとも、要素１の配列になるのでエラーは出ない。
            var mWord = mPnl.mEtWord.text;
            mWord = mWord.replace(/ /g, "");
            var mWords = mWord.split(",");

            //検索ワードでフルパス（Obj）をふるいにかける。
            mFileObjs = mScreening(mFileObjs, mWords);

            //上記ファイルObj配列から名前の配列を作る。
            var mFnames = [];
            var mFullPaths = [];
            for (var i = 0; i < mFileObjs.length; i++) {
                //日本語部分をデコードしたものを入れる。
                mFnames.push(decodeURIComponent(mFileObjs[i].name));
                mFullPaths.push(decodeURIComponent(mFileObjs[i].fsName));
            }

            //もしも拡張子チェックがfalseならば、名前配列からドット以下を消す。
            if (mPnl.mCbExt.value === false) {
                for (var i = 0; i < mFnames.length; i++) {
                    var mNameWotExt = mFnames[i].split(".")[0];
                    mFnames.splice(i, 1, mNameWotExt);
                }
            }

            //ネーム、フルパスをObjで返す。
            var mRst = {};
            mRst.mFullPaths = mFullPaths;
            mRst.mNames = mFnames;
            return mRst;

        }
    }

    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //フォルダパスからファイルObjのh配列を再帰処理で得る関数。
    //ファイルObjのプロパティは以下。
    //fsName　フルパス＆ファイル名。
    //path　フルパス。
    //name　ファイル名。
    function mGetFileObjs(aPth) {
        var mRst = [];
        var mStopOrNot = false;
        var mStdTime = Date.now();

        //サブフォルダチェックがtrueならば再帰処理版を使う。
        if (mPnl.mCbSub.value === false) { mExecute1(aPth); }
        else { mExecute2(aPth); }

        //取得処理が終わり、mStopOrNotがtrueになっていれば１秒タイムアウトなのでnullを返す。
        if (mStopOrNot === true) { return null; }
        return mRst;

        //ファイルObj取得関数その１。指定フォルダのみを探す。
        function mExecute1(aPth) {
            //getFiles()で得られるものはフルパス名ではなくファイルObj。
            var mFls = new Folder(aPth).getFiles();
            for (var i = 0; i < mFls.length; i++) {
                //もしもファイルならば配列に入れる。
                if (mFls[i] instanceof File) {
                    mRst.push(mFls[i]);
                }
            }
        }
        //ファイルObj取得関数その２。再帰処理でサブフォルダも探す。
        function mExecute2(aPth) {
            //もしも指定ミリ秒を超えたら、ストップorNotチェックをtrueにして、リターンする。
            if (mTimeOut(mStdTime, 100) === true) {
                mStopOrNot = true;
                return;
            }
            //getFiles()で得られるものはフルパス名ではなくファイルObj。
            var mFls = new Folder(aPth).getFiles();
            //正規表現（カッコでくくられた文字列）。
            var mExt = ".*\\(.*\\)$";
            for (var i = 0; i < mFls.length; i++) {
                //もしもフルパス先がフォルダ、かつ名前にカッコがなく、シャットダウン、スタートアップフォルダでなければ、
                //再帰処理でmExecuteを行う。
                if (mFls[i] instanceof Folder
                    && RegExp(mExt).test(mFls[i].name) === false
                    && mFls[i].name !== "Shutdown" && mFls[i].name !== "Startup") {
                    mExecute2(mFls[i]);
                    //フルパス先がファイルならば配列に入れる。
                } else {
                    if (mFls[i] instanceof File) {
                        mRst.push(mFls[i]);
                    }
                }
            }
        }

        //使用関数。
        //タイムアウト関数。もしも経過時間（ 現在時間 - 引数の基準時間 )が指定ミリ秒を超えたらtrueを返す。
        function mTimeOut(aStdTime, aMilliSec) {
            var mNowTime = Date.now();
            if (mNowTime - aStdTime > aMilliSec) {
                return true;
            }
        }
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //文字列配列aStrAryの中に、文字列配列aWordsの各要素が含まれているか否かでふるいにかけて、新配列にして返す関数。
    function mScreening(aStrAry, aWords) {
        var mRst = [];
        for (var i = 0; i < aStrAry.length; i++) {
            var TgtEmt = aStrAry[i];
            for (var j = 0; j < aWords.length; j++) {
                var mWordTmp = aWords[j];
                //testは文字列が含まれていればtrueを返すメソッド。
                if (RegExp(mWordTmp).test(aStrAry[i].name) == true) {
                    mRst.push(aStrAry[i]);
                    //一度入れたら、別のワードでも引っかかってもう一度入れないためにブレイクする。
                    break;
                }
            }
        }
        return mRst;
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //システム上のファイル名から名前を抜き出す関数。
    function mGetSelfName() {
        //フルパスから名前だけ抜き出す。
        var mFile = new File($.fileName);
        var mFileName = mFile.name;
        //拡張子があるならば、その前までを抜き出す。
        if (mFileName.indexOf(".") !== -1) {
            var mExp1 = /^.*(?=\.)/;
            var mRst = mFileName.match(mExp1);
            mFileName = mRst[0];
        }
        return mFileName;
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
})(this);


















