﻿(function (aGbl) {
    //----------------------------------------------------------------------------------------------------------------------
    //テキストコードで使える変数。
    var check = false;
    var exArray = [];

    //シェイプオブジェクト保存用変数。
    var mShapeForPaste = {};

    //----------------------------------------------------------------------------------------------------------------------
    //メインウィンドウ作成関数。
    function mCreateUI(aObj) {
        var mPorW = (aObj instanceof Panel) ? aObj : new Window("palette", "EffectsDrive", undefined);
        mPorW.preferredSize = [200, 200];

        //四隅の余白。
        mPorW.margins = [5, 5, 5, 5];
        mPorW.alignment = ["fill", "fill"];
        //タブを追加。
        mPorW.mTbp = mPorW.add("panel { type : 'tabbedpanel' , \
    mTb1 : Panel{ type : 'tab' , text : 'Main' } \
    mTb2 : Panel{ type : 'tab' , text : 'Note' } }");
        mPorW.mTbp.preferredSize = [-1, -1];
        mPorW.mTbp.alignment = ["fill", "fill"];
        mPorW.mTbp.margins = [0, 0, 0, 0];

        mPorW.mTbp.mTb1.preferredSize = [-1, -1];
        mPorW.mTbp.mTb1.alignment = ["fill", "fill"];
        mPorW.mTbp.mTb1.margins = [5, 5, 5, 5];
        mPorW.mTbp.mTb1.spacing = 5;

        mPorW.GpPick = mPorW.mTbp.mTb1.add("group {alignment :  [ 'left','top' ] }");
        mPorW.mBtPick = mPorW.GpPick.add("button { preferredSize: [60, 20], text : 'PickUp',alignment :  [ 'left','top' ] }");
        mPorW.GpPickTxt = mPorW.GpPick.add("group {orientation : 'column' , alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0]}");
        mPorW.GpPickTxt.spacing = 0;
        mPorW.mCbWoNum = mPorW.GpPickTxt.add("checkbox {  text : 'w/o Num',alignment :  [ 'left','top' ] }");
        mPorW.mCbMn = mPorW.GpPickTxt.add("checkbox {  text : 'matchName',alignment :  [ 'left','top' ] }");

        mPorW.GpFft = mPorW.mTbp.mTb1.add("group {alignment : ['left','top'] }");
        mPorW.mEtEft = mPorW.GpFft.add("EditText { preferredSize: [120, 20] , text : '' }");
        mPorW.mEtEft.text = "エフェクト名";
        mPorW.mCbInclEft = mPorW.GpFft.add("checkbox {  text : 'incl.'}");
        mPorW.mCbInclEft.value = false;

        mPorW.GpPrm = mPorW.mTbp.mTb1.add("group {alignment : ['left','top'] }");
        mPorW.mEtPrm = mPorW.GpPrm.add("EditText { preferredSize: [120, 20] , text : ''}");
        mPorW.mEtPrm.text = "パラメータ名";
        mPorW.mCbInclPrm = mPorW.GpPrm.add("checkbox {  text : 'incl.' }");
        mPorW.mCbInclPrm.value = false;

        mPorW.GpLyrs = mPorW.mTbp.mTb1.add("group {alignment : ['right','top'] }");
        mPorW.StLyrs = mPorW.GpLyrs.add("StaticText { preferredSize: [-1, 20] , text : 'Layers'}");
        mPorW.mRb1 = mPorW.GpLyrs.add("RadioButton { preferredSize: [-1, 20] , text : 'Selected'}");
        mPorW.mRb2 = mPorW.GpLyrs.add("RadioButton { preferredSize: [-1, 20] , text : 'All'}");
        mPorW.mRb1.value = true;

        mPorW.GpLst = mPorW.mTbp.mTb1.add("group {alignment : ['right','top'] }");
        mPorW.mLstName = mPorW.GpLst.add("listbox {preferredSize: [150, 100] }");

        mPorW.GpKey = mPorW.mTbp.mTb1.add("group {alignment : ['right','top'] }");
        mPorW.mEtKey = mPorW.GpKey.add("EditText { preferredSize: [100, 20] , text : ''}");
        mPorW.mEtKey.text = "0.00";
        mPorW.mCbKey = mPorW.GpKey.add("checkbox {  text : 'Key'}");
        mPorW.mCbKey.value = false;

        mPorW.GpExtc = mPorW.mTbp.mTb1.add("group {alignment : ['right','top'] }");
        mPorW.mBtExtc = mPorW.GpExtc.add("button { preferredSize: [40, 20], text : 'SetVal' }");

        mPorW.mTbp.mTb2.preferredSize = [-1, -1];
        mPorW.mTbp.mTb2.alignment = ["fill", "fill"];
        mPorW.mTbp.mTb2.margins = [5, 5, 5, 5];
        mPorW.mTbp.mTb2.spacing = 0;

        mPorW.GpCode = mPorW.mTbp.mTb2.add("group {alignment : ['left','top'] }");
        mPorW.GpCode.spacing = 5;
        mPorW.mBtCode = mPorW.GpCode.add("button { preferredSize: [60, 20], text : 'Code' }");
        mPorW.mBtNote = mPorW.GpCode.add("button { preferredSize: [60, 20], text : 'Note' }");

        return mPorW;
    }

    //mPnlという名でメインウインドウを作成。
    var mPnl = mCreateUI(aGbl);
    if (mPnl instanceof Window) {
        mPnl.center();
        mPnl.show();
    } else if (mPnl instanceof Panel) {
        //UIパネルの場合は以下をしないと自動レイアウトされない。
        mPnl.layout.layout(true);
    }
    //-----------------------------------------------------------
    //コード用テキスト。オブジェクトにすることで疑似的なパーツにする。
    mPnl.mAllCodeTxt = {};
    mPnl.mAllCodeTxt.text = "//選択" + "\n" +
        "if( i === 0 ){" + "\n" +
        "    var mSelLyrs = app.project.activeItem.selectedLayers;" + "\n" +
        "    for( var j= 0 ; j< mSelLyrs.length ; j++ ){" + "\n" +
        "        mSelLyrs[j].selected = false;" + "\n" +
        "    }" + "\n" +
        "}" + "\n" +
        "eachProp.selected = true;" + "\n" +
        "if( i === propLength - 1 ){"+ "\n" +
        "    app.activeViewer.setActive();"+ "\n" +
        "}"+ "\n" +
        "" + "\n" +
        "//目玉オンオフ" + "\n" +
        "if( check === false ){" + "\n" +
        "    eachProp.enabled = false;" + "\n" +
        "}else{" + "\n" +
        "    eachProp.enabled = true;" + "\n" +
        "}" + "\n" +
        "if( i === propLength - 1 ){" + "\n" +
        "    if( check === true ){ check = false; }" + "\n" +
        "    else{ check = true; }" + "\n" +
        "}" + "\n" +
        "" + "\n" +
        "//削除" + "\n" +
        "eachProp.remove();" + "\n" +
        "if( i === propLength - 1 ){"+ "\n" +
        "    app.activeViewer.setActive();"+ "\n" +
        "}"+ "\n" +
        "";

    //ノート用テキスト。オブジェクトにすることで疑似的なパーツにする。
    mPnl.mAllNoteTxt = {};
    mPnl.mAllNoteTxt.text = "";

    //コード用テキストをリスト化したときにできる、それに対応するコード配列。
    mPnl.mCodeList = [];

    //-----------------------------------------------------------
    //コードウインドウ作成関数。
    function mCreateCodeWdw() {
        var mPorW = new Window("palette", "Code", undefined, { resizeable: true });
        mPorW.preferredSize = [400, 400];

        // リサイズ用オンリサイズ関数。
        mPorW.onResizing = mPorW.onResize = function () { this.layout.resize(); }
        mPorW.onShow = function () {
            mPorW.minimumSize = mPorW.size;
        }

        mPorW.mCodeEt = mPorW.add("EditText { text : '', alignment : [ 'fill','fill' ] ,properties : { multiline : true }  }");
        //mPnl.mAllCodeTxtを入れ込む。
        mPorW.mCodeEt.text = mPnl.mAllCodeTxt.text;

        //閉じたらmPnl.mAllCodeTxtを更新して設定を保存し、表示リスト＆コードリストを更新する。
        mPorW.onClose = function () {
            mPnl.mAllCodeTxt.text = mPorW.mCodeEt.text;
            //このウインドウを開いたときにはmPnlはできているので、mPnl.を使って問題ない。
            app.settings.saveSetting(mPnl.mSec, mPnl.mAllCodeTxt.mKey, mConvertTxtToCodesTxt(mPnl.mAllCodeTxt.text));
            mRenewList();
        }

        mPorW.center();
        mPorW.show();

    }

    //メインウインドウのコードボタンが押されたらコードウインドウを作成。
    mPnl.mBtCode.onClick = function () {
        mCreateCodeWdw();
    }
    //-----------------------------------------------------------
    //ノートウインドウ作成関数。
    function mCreateNoteWdw() {
        var mPorW = new Window("palette", "Note", undefined, { resizeable: true });
        mPorW.preferredSize = [400, 400];

        // リサイズ用オンリサイズ関数。
        mPorW.onResizing = mPorW.onResize = function () { this.layout.resize(); }
        mPorW.onShow = function () {
            mPorW.minimumSize = mPorW.size;
        }

        mPorW.mNoteEt = mPorW.add("EditText { text : '', alignment : [ 'fill','fill' ] ,properties : { multiline : true }  }");
        //グローバルのmPnl.mAllNoteTxtを入れ込む。
        mPorW.mNoteEt.text = mPnl.mAllNoteTxt.text;

        //閉じたら設定を保存する。
        mPorW.onClose = function () {
            mPnl.mAllNoteTxt.text = mPorW.mNoteEt.text;
            //このウインドウを開いたときにはmPnlはできているので、mPnl.を使って問題ない。
            app.settings.saveSetting(mPnl.mSec, mPnl.mAllNoteTxt.mKey, mConvertTxtToCodesTxt(mPnl.mAllNoteTxt.text));
        }
        mPorW.center();
        mPorW.show();
    }

    //メインウインドウのコードボタンが押されたらコードウインドウを作成。
    mPnl.mBtNote.onClick = function () {
        mCreateNoteWdw();
    }

    //-----------------------------------------------------------
    //セッティングパート。

    //まずはセクション名を規定する。
    mPnl.mSec = "EffectsDrive12";
    //設定を保存したいパーツにキー名を付ける。
    mPnl.mCbWoNum.mKey = "mCbWoNum";
    mPnl.mCbMn.mKey = "mCbMn";
    mPnl.mEtEft.mKey = "mEtEft";
    mPnl.mCbInclEft.mKey = "mCbInclEft";
    mPnl.mEtPrm.mKey = "mEtPrm";
    mPnl.mCbInclPrm.mKey = "mCbInclPrm";
    mPnl.mRb1.mKey = "mRb1";
    mPnl.mRb2.mKey = "mRb2";
    mPnl.mEtKey.mKey = "mEtKey";
    mPnl.mCbKey.mKey = "mCbKey";

    mPnl.mCbInclPrm.mKeyEnbl = "mCbInclPrmEnbl";
    mPnl.mCbInclEft.mKeyEnbl = "mCbInclEftEnbl";

    //パーツに設定があれば読み込む（mKeyEnblを含む）。
    mGetAllSettings(mPnl, mPnl.mSec);

    //テキスト類はパーツ扱いではないので、個別で設定読み込みをする。
    mPnl.mAllCodeTxt.mKey = "mAllCodeTxt";
    mPnl.mAllNoteTxt.mKey = "mAllNoteTxt";
    if (app.settings.haveSetting(mPnl.mSec, mPnl.mAllCodeTxt.mKey) === true) {
        mPnl.mAllCodeTxt.text = mConvertCodesTxtToTxt(app.settings.getSetting(mPnl.mSec, mPnl.mAllCodeTxt.mKey));
    }
    if (app.settings.haveSetting(mPnl.mSec, mPnl.mAllNoteTxt.mKey) === true) {
        mPnl.mAllNoteTxt.text = mConvertCodesTxtToTxt(app.settings.getSetting(mPnl.mSec, mPnl.mAllNoteTxt.mKey));
    }

    //表示リストとmPnl.mCodeListを更新する。
    mRenewList();

    //チェックボックス、ラジオボタン、エディットテキストに、変化したら保存するonイベントを加える。
    mAddSaveEventOn(mPnl, mPnl.mSec);

    //-----------------------------------------------------------
    //onイベント上書きパート。enabledはmkeyとmKeyEnblの両方を保存する。
    mPnl.mCbMn.onClick = function () {
        if (mPnl.mCbMn.value === true && mPnl.mCbWoNum.value = true) {
            mPnl.mCbWoNum.value = false;
        }
        if (mPnl.mCbMn.value === true) {
            mPnl.mCbInclPrm.enabled = false;
            mPnl.mCbInclEft.enabled = false;
        } else {
            mPnl.mCbInclPrm.enabled = true;
            mPnl.mCbInclEft.enabled = true;
        }
        //設定を保存。
        app.settings.saveSetting(mPnl.mSec, mPnl.mCbMn.mKey, mPnl.mCbMn.value);
        app.settings.saveSetting(mPnl.mSec, mPnl.mCbWoNum.mKey, mPnl.mCbWoNum.value);
        app.settings.saveSetting(mPnl.mSec, mPnl.mCbInclPrm.mKeyEnbl, mPnl.mCbInclPrm.enabled);
        app.settings.saveSetting(mPnl.mSec, mPnl.mCbInclEft.mKeyEnbl, mPnl.mCbInclEft.enabled);
    }

    mPnl.mCbWoNum.onClick = function () {
        if (mPnl.mCbWoNum.value === true && mPnl.mCbMn.value = true) {
            mPnl.mCbMn.value = false;
        }
        if (mPnl.mCbMn.value === true) {
            mPnl.mCbInclPrm.enabled = false;
            mPnl.mCbInclEft.enabled = false;
        } else {
            mPnl.mCbInclPrm.enabled = true;
            mPnl.mCbInclEft.enabled = true;
        }
        //設定を保存。
        app.settings.saveSetting(mPnl.mSec, mPnl.mCbMn.mKey, mPnl.mCbMn.value);
        app.settings.saveSetting(mPnl.mSec, mPnl.mCbWoNum.mKey, mPnl.mCbWoNum.value);
        app.settings.saveSetting(mPnl.mSec, mPnl.mCbInclPrm.mKeyEnbl, mPnl.mCbInclPrm.enabled);
        app.settings.saveSetting(mPnl.mSec, mPnl.mCbInclEft.mKeyEnbl, mPnl.mCbInclEft.enabled);
    }

    //-----------------------------------------------------------
    //mPnl.mAllCodeTxtを使って、表示リストとmPnl.mCodeListを更新する関数。
    function mRenewList() {
        //コメント記号でコードを分ける。
        var mLstStrAry = mPnl.mAllCodeTxt.text.split("//");
        //コードリストはグローバルで使うので事前に定義してある。
        mPnl.mCodeList = [];
        var mNameList = [];
        for (var i = 0; i < mLstStrAry.length; i++) {
            //コメントから0番目の改行がネームと実コードを分ける箇所なので、
            //そこで分割する。
            var mDivNum = mLstStrAry[i].indexOf("\n");
            if (mLstStrAry[i] !== "") {
                mNameList.push(mLstStrAry[i].slice(0, mDivNum));
                mPnl.mCodeList.push(mLstStrAry[i].slice(mDivNum + 1, mLstStrAry[i].length));
            }
        }

        mPnl.mLstName.removeAll();
        for (var i = 0; i < mNameList.length; i++) {
            mPnl.mLstName.add("item", mNameList[i]);
        }
    }

    //----------------------------------------------------------------------------------------------------------------------
    //ここからメインパート。
    //ピックボタンでエフェクト名をピックアップする。
    mPnl.mBtPick.onClick = function () {
        app.beginUndoGroup("EffectsDrive");

        var mAi = app.project.activeItem;
        var mSls = mAi.selectedLayers;
        var mSl = mSls[0];
        var mSps = mSl.selectedProperties;

        //選択プロパティがエフェクト１つの場合、エフェクト１つかエフェクト&パラメータの２つの場合がある。
        //まずは選択プロパティが１～２つではない場合はリターン。
        if (mSps.length !== 1 && mSps.length !== 2) { return; }
        //１つ目がエフェクトプロパティではない場合もリターン。
        if (mSps[0].isEffect === false) { return; }
        //２つの場合、２つ目の親プロパティが１つ目と一緒でなければリターン。
        if (mSps.length === 2) {
            if (mSps[1].propertyGroup(1).name !== mSps[0].name) { return; }
        }

        //マッチネームチェックがtrueの場合。
        if (mPnl.mCbMn.value === true) {
            //エフェクトとパラメータの場合。
            if (mSps.length !== 1) {
                mPnl.mEtEft.text = mSps[0].matchName;
                mPnl.mEtPrm.text = mSps[1].matchName;
                mPnl.mEtKey.text = mSps[1].value;
                //エフェクトのみの場合。
            } else {
                mPnl.mEtEft.text = mSps[0].matchName;
                mPnl.mEtPrm.text = "";
                mPnl.mEtKey.text = "";
            }
            //マッチネームチェックがfalseの場合。
        } else {
            //エフェクトとパラメータの場合。
            if (mSps.length !== 1) {
                //数字なしチェックのありなしで分ける。
                if (mPnl.mCbWoNum.value === false) { mPnl.mEtEft.text = mSps[0].name; }
                else { mPnl.mEtEft.text = mSps[0].name.replace(/ [0-9]+/g, ""); }
                mPnl.mEtPrm.text = mSps[1].name;
                mPnl.mEtKey.text = mSps[1].value;
                //エフェクトのみの場合。
            } else {
                //数字なしチェックのありなしで分ける。
                if (mPnl.mCbWoNum.value === false) { mPnl.mEtEft.text = mSps[0].name; }
                else { mPnl.mEtEft.text = mSps[0].name.replace(/ [0-9]+/g, ""); }
                mPnl.mEtPrm.text = "";
                mPnl.mEtKey.text = "";
            }
        }
        //エディットテキストの設定を保存。
        app.settings.saveSetting(mPnl.mSec, mPnl.mEtEft.mKey, mConvertTxtToCodesTxt(mPnl.mEtEft.text));
        app.settings.saveSetting(mPnl.mSec, mPnl.mEtPrm.mKey, mConvertTxtToCodesTxt(mPnl.mEtPrm.text));
        app.settings.saveSetting(mPnl.mSec, mPnl.mEtKey.mKey, mConvertTxtToCodesTxt(mPnl.mEtKey.text));

        app.endUndoGroup();
    }
    //----------------------------------------------------------------------------------------------------------------------
    //リストをダブルクリックで内部検索＆リストと同じ番号のmAllCodeTxtの要素文字列を実行する。
    //リスト内の名前とmAllCodeTxtの要素は配列番号で合致するようにしてある。
    mPnl.mLstName.onDoubleClick = function () {
        mExecOglOrKey(true);
    }
    mPnl.mBtExtc.onClick = function () {
        mExecOglOrKey(false);
    }

    //------------------------------------------------------------
    function mExecOglOrKey(aOglOrKey) {
        var mAi = app.project.activeItem;

        if (mPnl.mRb1.value === true) {
            var mSls = mAi.selectedLayers;
            //全レイヤーの場合、レイヤーズは１始まりなので配列に入れてゼロ始まりにする。
        } else {
            var mSls = [];
            for (var ctr1 = 1; ctr1 <= mAi.layers.length; ctr1++) {
                mSls.push(mAi.layers[ctr1]);
            }
        }

        app.beginUndoGroup("EffectsDrive");
        //------------------------------------------------------------
        var mPptyName = mPnl.mEtEft.text;

        var mRst = [];
        //名前が入っていない場合は選択エフェクト全てを入れる。
        if (mPptyName === "") {
            for (var ctr1 = 0; ctr1 < mSls.length; ctr1++) {
                //各レイヤーのエフェクト（１始まりの配列風要素を持つオブジェクト）。
                var mTmpLyrEfts = mSls[ctr1].effect;
                for (var ctr2 = 1; ctr2 <= mTmpLyrEfts.numProperties; ctr2++) {
                    mRst.push(mTmpLyrEfts(ctr2));
                }
            }
            //名前が入っている場合。
        } else {
            for (var ctr1 = 0; ctr1 < mSls.length; ctr1++) {
                //各レイヤーのエフェクト（１始まりの配列風要素を持つオブジェクト）。
                var mTmpLyrEfts = mSls[ctr1].effect;

                for (var ctr2 = 1; ctr2 <= mTmpLyrEfts.numProperties; ctr2++) {
                    //もしもマッチネームチェックがtrueならば、マッチネームを使う。
                    if (mPnl.mCbMn.value === true) {
                        if (mTmpLyrEfts(ctr2).matchName === mPptyName) {
                            mRst.push(mTmpLyrEfts(ctr2));
                        }
                        //もしもマッチネームチェックがfalseならば、ネームを使う。
                    } else {
                        //チェックがfalseならば、文字列が合致すれば入れ込む。
                        if (mPnl.mCbInclEft.value === false) {
                            if (mTmpLyrEfts(ctr2).name === mPptyName) {
                                mRst.push(mTmpLyrEfts(ctr2));
                            }
                            //チェックがtrueならば、文字列を含めば入れ込む。
                        } else {
                            if (mTmpLyrEfts(ctr2).name.indexOf(mPptyName) != -1) {
                                mRst.push(mTmpLyrEfts(ctr2));
                            }
                        }
                    }
                }
            }
        }
        //------------------------------------------------------------
        var mPptyParamsName = mPnl.mEtPrm.text;
        //名前が入っていた場合のみ処理する。
        if (mPptyParamsName !== "") {
            var mRstParams = [];
            for (var ctr1 = 0; ctr1 < mRst.length; ctr1++) {
                var mEftTmp = mRst[ctr1];
                for (var ctr2 = 1; ctr2 <= mEftTmp.numProperties; ctr2++) {
                    //もしもマッチネームチェックがtrueならば、マッチネームを使う。
                    if (mPnl.mCbMn.value === true) {
                        if (mEftTmp(ctr2).matchName === mPptyParamsName) {
                            mRstParams.push(mEftTmp(ctr2));
                        }
                        //もしもマッチネームチェックがfalseならば、ネームを使う。
                    } else {
                        //チェックがfalseならば、文字列が合致すれば入れ込む。
                        if (mPnl.mCbInclPrm.value === false) {
                            if (mEftTmp(ctr2).name === mPptyParamsName) {
                                mRstParams.push(mEftTmp(ctr2));
                            }
                            //チェックがtrueならば、文字列を含めば入れ込む。
                        } else {
                            if (mEftTmp(ctr2).name.indexOf(mPptyParamsName) != -1) {
                                mRstParams.push(mEftTmp(ctr2));
                            }
                        }
                    }
                }
            }
            //エフェクトでもパラメータでも次以降の処理が１つになるよう、mRstを書き換えする。
            mRst = mRstParams;
        }

        //------------------------------------------------------------
        //得たプロパティ配列をアドレスにして新配列に入れる。
        var mRstAdrsStrs = [];
        for (var ctr1 = 0; ctr1 < mRst.length; ctr1++) {
            var mAdrsTmp = mGetSelPptyAdrs(mRst[ctr1]);
            mRstAdrsStrs.push(mAdrsTmp);
        }

        //任意の処理がremove()だった場合、昇順だとプロパティ番号が順に変わってしまい
        //エラーが出るので反転させ、降順で処理されるようにする。
        mRstAdrsStrs.reverse();

        //処理前にプロパティの選択は外しておく。
        for (var ctr1 = 0; ctr1 < mSls.length; ctr1++) {
            var mSps = mSls[ctr1].selectedProperties;
            for (var ctr2 = 0; ctr2 < mSps.length; ctr2++) {
                mSps[ctr2].selected = false;
            }
        }

        if (aOglOrKey === true) {
            //------------------------------------------------------------
            //テキストコードで名前を打ちやすいように総数を変数に入れる。
            var propLength = mRstAdrsStrs.length;
            //任意の処理を行う。
            for (var i = 0; i < propLength; i++) {
                //アドレスからプロパティを得る。
                var eachProp = mGetPptyFromAdrs(mRstAdrsStrs[i], 0);
                //上の変数eachPropを先頭に、テキスト欄にコードを入れれば処理される。 i とpropLength、Checkも使える（降順になっていることに注意）。
                var mCodeStr = mPnl.mCodeList[mPnl.mLstName.selection.index];
                eval(mCodeStr);
            }
            //------------------------------------------------------------
        } else {
            var propLength = mRstAdrsStrs.length;
            for (var Ctr1 = 0; Ctr1 < propLength; Ctr1++) {
                //アドレスからプロパティを得る。
                var eachProp = mGetPptyFromAdrs(mRstAdrsStrs[Ctr1], 0);
                mExecKey(eachProp);
            }
        }

        //スクリプトのメモリ対策のためにガベージコレクションしておく。
        $.gc();

        app.endUndoGroup();
    }
    //----------------------------------------------------------------------------------------------------------------------
    //キーフレーム処理をする関数。
    function mExecKey(aEachProp) {
        var mAi = app.project.activeItem;
        var mKeyChk = mPnl.mCbKey.value;
        var mValStr = mPnl.mEtKey.text;

        if (mValStr.indexOf(",") !== -1) {
            var mStrAryTmp = mValStr.split(",");
            var mRst = [];
            for (var i = 0; i < mStrAryTmp.length; i++) {
                var mNumTmP = parseFloat(mStrAryTmp[i]);
                mRst.push(mNumTmP);
            }
            //数値しか入っていない文字列はisNaNがfalseになるので、elseのほうに数値の処理を入れる。
        } else if (mValStr.isNaN === true) {
            return;
        } else {
            mRst = parseFloat(mValStr);
        }

        //プロパティのキーフレームがゼロの場合。
        if (aEachProp.numKeys === 0) {
            //チェックがfalseならば、キーを打たずに値を入れる。
            if (mKeyChk === false) {
                aEachProp.setValue(mRst);
                //チェックがtrueならば、キーを打つ。
            } else {
                aEachProp.setValueAtTime(mAi.time, mRst);
                //すでにキーが打たれていればキーを打つ。
            }
        } else {
            aEachProp.setValueAtTime(mAi.time, mRst);
        }
    }
    //----------------------------------------------------------------------------------------------------------------------
    //----------------------------------------------------------------------------------------------------------------------
    //プロパティの指定をアドレス（オブジェクトの階層）経由にする関数２つ。
    //これで、プロパティの削除や移動をすると事前に変数に入れておいたプロパティが直接参照不可になる問題を回避できる。
    //移動や昇順での削除はプロパティ番号が変わる（つまりアドレスが変わる）のでこの関数での一括処理は有用ではないが、
    //今回は降順での削除に対応できればよいのでOK。

    //選択Propから [ 選択レイヤー（これのみ番号等ではなくObj)～選択Prop ] の階層別idx配列を得る関数。
    function mGetSelPptyAdrs(aSp) {
        var mSp = aSp;
        var mAdrs = [];
        //親プロパティ情報を上から入れていく。
        for (var i = mSp.propertyDepth; i >= 1; i--) {
            var mPropTmp = mSp.propertyGroup(i);
            //一番手前のものはレイヤーなので、プロパティとしては呼べないのでレイヤーを直接入れる。
            if( i === mSp.propertyDepth ){
                mAdrs.push(mSp.propertyGroup(mSp.propertyDepth));
            }else{
                mAdrs.push(mPropTmp.propertyIndex);
            }
        }
        //自身の情報を入れる。
        mAdrs.push(mSp.propertyIndex);
        return mAdrs;
    }
    //----------------------------------------------------------
    //階層別idx配列から、該当Pptyを得る関数。
    //（引数2を１上げるごとに、aAdrsの1層上のPptyが得られる。最深層でよい場合はゼロを入れる）。
    function mGetPptyFromAdrs(aAdrs, aNum) {
        var mAdrs = aAdrs;
        //まずはレイヤーが直接入っている0番目を参照する。
        var mSpfydPpty = aAdrs[0];
        //階層を下って、選択pptyを変えていく。
        for (var i = 1; i < mAdrs.length - aNum; i++) {
            mSpfydPpty = mSpfydPpty(mAdrs[i]);
        }
        return mSpfydPpty;
    }
    //----------------------------------------------------------------------------------------------------------------------
    //文字をコード（数字）の文字列にする関数。
    function mConvertTxtToCodesTxt(aTxt) {
        var mNameCodes = [];
        //文字を一つずつUnicode（数字）で取得して、配列に入れる。
        for (var i = 0; i < aTxt.length; i++) {
            var mCode = aTxt.charCodeAt(i);
            mNameCodes.push(mCode);
        }
        //コードの配列をコンマ区切りの文字列にする。
        //aTxtに””を入力すると、lengthゼロなので直接ここへ来て、空の配列mNameCodesを処理する。
        //join()は[]を””にするので、戻り値がコード文字列or””となるが、読み込み関数で処理する。
        var mNameCodesStr = mNameCodes.join(",");
        return mNameCodesStr;
    }
    //----------------------------------------------------------
    function mConvertCodesTxtToTxt(aCodesTxt) {
        //空""にはコード番号はない。それに対し、
        //（本来コード番号数値を入れるはずの）fromCharCode()に空””（文字列）を入れると
        //なぜかコード番号0番目の空を取得してしまう。厳密には変換できていないので、その対策が以下。
        if (aCodesTxt === "") { return "" }

        //まずは文字列を配列にする。
        var mNameCodesAry = aCodesTxt.split(",");
        var mNameLetterAry = [];
        //Unicode（数字）を文字にして１つずつ取得、配列に入れていく。
        for (var i = 0; i < mNameCodesAry.length; i++) {
            var mLetter = String.fromCharCode(mNameCodesAry[i]);
            mNameLetterAry.push(mLetter);
        }
        //１文字ずつ入った配列を１つの文字列にまとめる。
        var mNameRst = mNameLetterAry.join("");
        return mNameRst;
    }
    //----------------------------------------------------------------------------------------------------------------------
    //全ての設定を読み込む関数。対象はチェックボックス、ラジオボタン、エディットテキスト、enabled。
    //設定保存する各パーツにmKeyかmKeyEnblという要素があることが前提となっている。
    function mGetAllSettings(aPnl, aSecName) {
        var mSecName = aSecName;
        //まずは全てのパーツを抜き出す。
        var mElmts = mGetElementsForSettings(aPnl);

        for (var i = 0; i < mElmts.length; i++) {
            var mElmt = mElmts[i];
            //もしもパーツがmKeyという要素を持ち、その名の設定がある場合。
            if (mElmt.mKey !== undefined && app.settings.haveSetting(mSecName, mElmt.mKey) === true) {
                //設定を変数に入れる。
                var mSetting = app.settings.getSetting(mSecName, mElmt.mKey);
                //パーツがチェックボックスかラジオボタンだった場合。
                if (mElmt instanceof Checkbox || mElmt instanceof RadioButton) {
                    mElmt.value = (mSetting === "true");
                    //パーツがエディットテキストだった場合。
                } else if (mElmt instanceof EditText) {
                    //ユニコードを文字列に変換する。
                    mElmt.text = mConvertCodesTxtToTxt(mSetting);
                }
            }
            //もしもパーツがmKeyEnblという要素を持ち、その名の設定がある場合。
            if (mElmt.mKeyEnbl !== undefined && app.settings.haveSetting(mSecName, mElmt.mKeyEnbl) === true) {
                //設定を変数に入れる。
                var mSetting = app.settings.getSetting(mSecName, mElmt.mKeyEnbl);
                mElmt.enabled = (mSetting === "true");
            }
        }
    }
    //----------------------------------------------------------
    //全てのパーツにセーブイベントを加える関数。対象はチェックボックス、ラジオボタン、エディットテキスト。
    //ListenerではなくOnイベントのため、この関数の行の前に書いてあるOnイベントを上書きすることに注意。
    //逆に、この関数を上書きしたい場合はこの関数の後に書く。
    function mAddSaveEventOn(aPnl, aSecName) {
        var mSecName = aSecName;
        //まずは全てのパーツを抜き出す。
        var mElmts = mGetElementsForSettings(aPnl);
        for (var i = 0; i < mElmts.length; i++) {
            var mElmt = mElmts[i];
            if (mElmt instanceof Checkbox || mElmt instanceof RadioButton) {
                mElmt.onClick = function () { app.settings.saveSetting(mSecName, this.mKey, this.value); }
                //tエディットテキストの場合、ユニコードにして保存する。
            } else if (mElmt instanceof EditText) {
                mElmt.onChange = function () { app.settings.saveSetting(mSecName, this.mKey, mConvertTxtToCodesTxt(this.text)); }
            }
        }
    }
    //----------------------------------------------------------
    //パネルの全てのパーツを抜き出す関数。
    function mGetElementsForSettings(aPnl) {
        var mAllElmt = [];
        mGet(aPnl);
        return mAllElmt;

        function mGet(aObj) {
            for (var i = 0; i < aObj.children.length; i++) {
                if (aObj.children[i] instanceof Group === true
                    || aObj.children[i] instanceof Panel === true) {
                    mGet(aObj.children[i]);
                } else {
                    mAllElmt.push(aObj.children[i]);
                }
            }
        }
    }
    //----------------------------------------------------------------------------------------------------------------------
})(this);