﻿(function (aGbl) {
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    function mCreateUI(aObj) {
        var mPorW = (aObj) instanceof Panel ? aObj : new Window("palette", "EaseSwinger", undefined);
        mPorW.preferredSize = [200, 200];
        mPorW.margins = [10, 10, 10, 10];
        mPorW.spacing = 5;

        mPorW.mGpEse1 = mPorW.add("group {alignment :  [ 'fill','top' ] }");
        mPorW.mGpEse1.spacing = 0;
        mPorW.mGpEse1.add("staticText { preferredSize:  [40,20]  ,text : 'Ease' }");
        mPorW.mEtEseF = mPorW.mGpEse1.add("EditText { preferredSize:  [50,20]  ,text : '33.33' ,alignment :  [ 'right','top' ]}");
        mPorW.mEtEseL = mPorW.mGpEse1.add("EditText { preferredSize:  [50,20]  ,text : '100' ,alignment :  [ 'right','top' ]}");
        mPorW.mEtEseF.enabled = false;
        mPorW.mEtEseL.enabled = false;

        mPorW.mGpEse2 = mPorW.add("group {alignment :  [ 'fill','top' ] }");
        mPorW.mGpEse2.spacing = 5;
        mPorW.mBtEseF = mPorW.mGpEse2.add("button { preferredSize : [-1‬,20] , text : '' , alignment :  [ 'fill','top' ]}");
        mPorW.mBtEseF.text = "\\";
        mPorW.mBtEseL = mPorW.mGpEse2.add("button { preferredSize : [-1,20] , text : '/' ,alignment :  [ 'fill','top' ]}");
        mPorW.mCbEse = mPorW.mGpEse2.add("checkBox { preferredSize:  [20,20]  ,text : '' }");
        mPorW.mCbEse.value = true;

        mPorW.mGpRpd1 = mPorW.add("group {alignment :  [ 'fill','top' ] }");
        mPorW.mGpRpd1.spacing = 0;
        mPorW.mGpRpd1.add("staticText { preferredSize:  [40,20]  ,text : 'Rapid' }");
        mPorW.mEtRpdF = mPorW.mGpRpd1.add("EditText { preferredSize:  [50,20]  ,text : '0.1' ,alignment :  [ 'right','top' ]}");
        mPorW.mEtRpdL = mPorW.mGpRpd1.add("EditText { preferredSize:  [50,20]  ,text : '100' ,alignment :  [ 'right','top' ]}");
        mPorW.mEtRpdF.enabled = false;
        mPorW.mEtRpdL.enabled = false;

        mPorW.mGpRpd2 = mPorW.add("group {alignment :  [ 'fill','top' ] }");
        mPorW.mGpRpd2.spacing = 5;
        mPorW.mBtRpdF = mPorW.mGpRpd2.add("button { preferredSize : [-1‬,20] , text : '' , alignment :  [ 'fill','top' ]}");
        mPorW.mBtRpdF.text = "\\";
        mPorW.mBtRpdL = mPorW.mGpRpd2.add("button { preferredSize : [-1,20] , text : '/' ,alignment :  [ 'fill','top' ]}");
        mPorW.mCbRpd = mPorW.mGpRpd2.add("checkBox { preferredSize:  [20,20]  ,text : '' }");
        mPorW.mCbRpd.value = true;

        return mPorW;

    }

    //mPnlという名でメインウインドウを作成。
    var mPnl = mCreateUI(aGbl);
    if (mPnl instanceof Window) {
        mPnl.center();
        mPnl.show();
    } else if (mPnl instanceof Panel) {
        //UIパネルの場合は以下をしないと自動レイアウトされない。
        mPnl.layout.layout(true);
    }

    //-------------------------------------------------------------------------
    //チェックボックス制御。
    mPnl.mCbEse.onClick = function () {
        if (mPnl.mCbEse.value === true) {
            mPnl.mEtEseF.enabled = false;
            mPnl.mEtEseL.enabled = false;
        } else {
            mPnl.mEtEseF.enabled = true;
            mPnl.mEtEseL.enabled = true;
        }
    }
    //-------------------------------------------------------------------------
    mPnl.mCbRpd.onClick = function () {
        if (mPnl.mCbRpd.value === true) {
            mPnl.mEtRpdF.enabled = false;
            mPnl.mEtRpdL.enabled = false;
        } else {
            mPnl.mEtRpdF.enabled = true;
            mPnl.mEtRpdL.enabled = true;
        }
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //セッティングパート。

    //設定のキーを作る。
    mPnl.mPref1 = {};
    mPnl.mPref1.mSec = "EaseSwinger";
    mPnl.mPref1.mKey = "EseF";
    mPnl.mPref2 = {};
    mPnl.mPref2.mSec = "EaseSwinger";
    mPnl.mPref2.mKey = "EseL";
    mPnl.mPref3 = {};
    mPnl.mPref3.mSec = "EaseSwinger";
    mPnl.mPref3.mKey = "RpdF";
    mPnl.mPref4 = {};
    mPnl.mPref4.mSec = "EaseSwinger";
    mPnl.mPref4.mKey = "RpdL";

    //もしも設定があれば読み込む。
    mPnl.Setting1 = mGetSetting(mPnl.mPref1);
    if (mPnl.Setting1 !== null) { mPnl.mEtEseF.text = mPnl.Setting1; }
    mPnl.Setting2 = mGetSetting(mPnl.mPref2);
    if (mPnl.Setting2 !== null) { mPnl.mEtEseL.text = mPnl.Setting2; }
    mPnl.Setting3 = mGetSetting(mPnl.mPref3);
    if (mPnl.Setting3 !== null) { mPnl.mEtRpdF.text = mPnl.Setting3; }
    mPnl.Setting4 = mGetSetting(mPnl.mPref4);
    if (mPnl.Setting4 !== null) { mPnl.mEtRpdL.text = mPnl.Setting4; }

    //-------------------------------------------------------------------------
    //テキストが変化したら設定に保存する。
    mPnl.mEtEseF.onChange = function () {
        mSaveSetting(mPnl.mPref1, mPnl.mEtEseF.text);
    }
    mPnl.mEtEseL.onChange = function () {
        mSaveSetting(mPnl.mPref2, mPnl.mEtEseL.text);
    }
    mPnl.mEtRpdF.onChange = function () {
        mSaveSetting(mPnl.mPref3, mPnl.mEtRpdF.text);
    }
    mPnl.mEtRpdL.onChange = function () {
        mSaveSetting(mPnl.mPref4, mPnl.mEtRpdL.text);
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //メイン処理パート。
    //キーフレームイーズオブジェクトを作り、適用用関数に入れて処理する。
    mPnl.mBtEseF.onClick = function () {
        mEasyEase(new KeyframeEase(0, mPnl.mEtEseF.text), new KeyframeEase(0, mPnl.mEtEseL.text));
    }
    //-------------------------------------------------------------------------
    mPnl.mBtEseL.onClick = function () {
        mEasyEase(new KeyframeEase(0, mPnl.mEtEseL.text), new KeyframeEase(0, mPnl.mEtEseF.text));
    }
    //-------------------------------------------------------------------------
    mPnl.mBtRpdF.onClick = function () {
        mEasyEase(new KeyframeEase(0, mPnl.mEtRpdF.text), new KeyframeEase(0, mPnl.mEtRpdL.text));
    }
    //-------------------------------------------------------------------------
    mPnl.mBtRpdL.onClick = function () {
        mEasyEase(new KeyframeEase(0, mPnl.mEtRpdL.text), new KeyframeEase(0, mPnl.mEtRpdF.text));
    }
    //-------------------------------------------------------------------------
    //イーズ適用用の関数。
    function mEasyEase(aEaseObj1, aEaseObj2) {
        var mAi = app.project.activeItem;
        var mSls = mAi.selectedLayers;

        app.beginUndoGroup("EaseSwinger");

        for (var i = 0; i < mSls.length; i++) {
            //プロパティ毎に適用する。
            var mSps = mSls[i].selectedProperties;
            for (var j = 0; j < mSps.length; j++) {
                var mSp = mSps[j];

                //キーフレームがオンorオフのプロパティには適用できないが、ほぼ使わないので考慮しない。
                //alert( mSp.propertyValueType );

                //もしも選択プロパティのタイプがPROPERTY（キーフレーム打ちが可能）でない、
                //そうでなくとも選択キーフレームの数が２つでなければ、なにもせずに次のプロパティへ移行する。
                if (mSp.propertyType != PropertyType.PROPERTY
                    || mSp.selectedKeys.length != 2) {
                    //mSp.isTimeVarying == false
                    continue;
                } else {
                    //２つのキーインデックスを出す。
                    var mKeyIdxF = mSp.selectedKeys[0];
                    var mKeyIdxL = mSp.selectedKeys[1];

                    //オリジナルのキー１のイン、キー２のアウトを出しておく。
                    var mEaseInF = mSp.keyInTemporalEase(mKeyIdxF);
                    var mEaseOutL = mSp.keyOutTemporalEase(mKeyIdxL);

                    //１番目について、もともとのインと新アウトを適用（引数はキーインデックス、インイーズ、アウトイーズ）。
                    mSp.setTemporalEaseAtKey(mKeyIdxF, mEaseInF, mGetEaseObjDimAry(mSp, aEaseObj1));
                    //２番目について、もともとのアウトと新インを適用。
                    mSp.setTemporalEaseAtKey(mKeyIdxL, mGetEaseObjDimAry(mSp, aEaseObj2), mEaseOutL);
                }
            }
        }

        app.endUndoGroup();
    }

    //-------------------------------------------------------------------------
    //aSpのタイプ別で何次元かのを判断した、イーズオブジェクトが入った配列を返す。
    function mGetEaseObjDimAry(aSp, aKease) {
        if (aSp.propertyValueType == PropertyValueType.ThreeD) {
            return [aKease, aKease, aKease];
        } else if (aSp.propertyValueType == PropertyValueType.TwoD) {
            return [aKease, aKease];
        } else {
            return [aKease];
        }
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //セッティング関連関数（オブジェクト引数版）。
    //mSecとmKeyという要素を持つObjを作って、それを入れて使う。
    //----------------------------------------------------------
    //設定があればそれを返す関数。
    function mGetSetting(aPrefObj) {
        var mPrefObj = aPrefObj;
        if (app.settings.haveSetting(mPrefObj.mSec, mPrefObj.mKey) === false) {
            return null;
        } else {
            return app.settings.getSetting(mPrefObj.mSec, mPrefObj.mKey);
        }
    }
    //----------------------------------------------------------
    //引数を設定に保存する関数。
    function mSaveSetting(aPrefObj, aValue) {
        var mPrefObj = aPrefObj;
        app.settings.saveSetting(mPrefObj.mSec, mPrefObj.mKey, aValue);
    }

    //--------------------------------------------------------------------------------------------------------------------------------------------------
}(this));

