﻿(function (aGbl) {
    //----------------------------------------------------------------------------------------------------------------------
    function mCreateUI(aObj) {
        var mPorW = (aObj instanceof Panel) ? aObj : new Window("palette", "DiceLine", undefined);
        mPorW.preferredSize = [200, 200];
        mPorW.margins = [10, 10, 10, 10];
        mPorW.spacing = 5;
        
        mPorW.mGpMtr = mPorW.add("group { orientation : 'row', alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0], spacing : 10}");
        
        mPorW.mGpBts = mPorW.mGpMtr.add("group { orientation : 'column', alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0], spacing : 0}");
        mPorW.mBtAdd = mPorW.mGpBts.add("button { preferredSize : [60,20] , text : 'Add Grid'}");
        mPorW.mBtDel = mPorW.mGpBts.add("button { preferredSize : [60,20] , text : 'Delete'}");
        
        mPorW.mGpChks = mPorW.mGpMtr.add("group { orientation : 'column', alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0], spacing : 5}");
        mPorW.mGpPix = mPorW.mGpChks.add("group { orientation : 'row', alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0], spacing : 0}");
        mPorW.mStPix = mPorW.mGpPix.add("statictext {  preferredSize : [-1,20] , text : 'pixel :'}");
        mPorW.mEtPix = mPorW.mGpPix.add("edittext {  preferredSize : [60,20] , text : '60'}");
        mPorW.mCbSqr = mPorW.mGpChks.add("checkbox { preferredSize : [-1,20], text : 'Only 4 sides' , alignment :  [ 'left','top' ], value : false }");
        //mPorW.mGpChks.add("statictext {  preferredSize : [-1,20] , text : ''}");
        mPorW.mGpLS = mPorW.mGpChks.add("group { orientation : 'row', alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0], spacing : 0}"); 
        mPorW.mCbLock = mPorW.mGpLS.add("checkbox { preferredSize : [-1,20], text : 'Lock' , alignment :  [ 'left','top' ], value : true }");
        mPorW.mCbSnap = mPorW.mGpLS.add("checkbox { preferredSize : [-1,20], text : 'Snap' , alignment :  [ 'left','top' ], value : true }");
        
        mPorW.mDfltLock = true;
        mPorW.mDfltSnap = true; 
        mPorW.mIsFstClick = false;

        return mPorW;
    }

    //mPnlという名でメインウインドウを作成。
    var mPnl = mCreateUI(aGbl);
    if (mPnl instanceof Window) {
        mPnl.center();
        mPnl.show();
    } else if (mPnl instanceof Panel) {
        //UIパネルの場合は以下をしないと自動レイアウトされない。
        mPnl.layout.layout(true);
    }

    //----------------------------------------------------------------------------------------------------------------------
    //セッティングパート。
    var mSecName = "DiceLine";
    //パーツの変数名を集める。
    var mKeys = ["mEtPix", "mCbSqr","mCbLock","mCbSnap"];
    
    //もしも設定があれば読み込む。
    for (var i = 0; i < mKeys.length; i ++) {
        var mKey = mKeys[i];
        if (app.settings.haveSetting(mSecName, mKey)){
            var mStng = app.settings.getSetting(mSecName, mKey);
            //パーツが何かによって適用の仕方を変える。
            //ブラケット記法により、パーツを変数名文字列で指定できる。
            if( mPnl[mKey] instanceof Checkbox ){ mPnl[mKey].value = (mStng === "true");}
            else if( mPnl[mKey] instanceof EditText ){ mPnl[mKey].text = mStng;}
        }
    }
    //Enabledは上記パーツと名前の重複を避けるため、別箇で読み込む。
    var mEnblKeys =["mEtPixEnbl", "mStPixEnbl"];
    for (var i = 0; i < mEnblKeys.length; i ++) {
        var mEnblKey = mEnblKeys[i];
        if (app.settings.haveSetting(mSecName, mEnblKey)){
            var mStng = app.settings.getSetting(mSecName, mEnblKey);
            var mPartName = mEnblKey.replace("Enbl", "");
            mPnl[mPartName].enabled = (mStng === "true");
        }
    }

    //テキスト、チェック、Enabledが変化したら設定に書き込む。
    mPnl.mEtPix.onChange = function () {
        app.settings.saveSetting(mSecName, "mEtPix", mPnl.mEtPix.text);
    }
    mPnl.mCbSqr.onClick = function () {
        mPnl.mStPix.enabled = !(mPnl.mCbSqr.value);
        mPnl.mEtPix.enabled = !(mPnl.mCbSqr.value);
        app.settings.saveSetting(mSecName, "mCbSqr", mPnl.mCbSqr.value);
        app.settings.saveSetting(mSecName, "mEtPixEnbl", mPnl.mEtPix.enabled);
        app.settings.saveSetting(mSecName, "mStPixEnbl", mPnl.mStPix.enabled);
    }
    mPnl.mCbLock.onClick = function () {
        app.settings.saveSetting(mSecName, "mCbLock", mPnl.mCbLock.value);
    }
    mPnl.mCbSnap.onClick = function () {
        app.settings.saveSetting(mSecName, "mCbSnap", mPnl.mCbSnap.value);
    }

    //----------------------------------------------------------------------------------------------------------------------
    mPnl.mBtAdd.onClick = function () {
        app.beginUndoGroup("AddGuides");

        var mAi = app.project.activeItem;

        var mNbr = parseFloat(mPnl.mEtPix.text);
        //入力欄がNaN、もしくはゼロであれば何もせずにリターンする。
        if (isNaN(mNbr) || mNbr === 0) { return; }

        //XY軸にガイドを作成。 
        //四隅のみチェックがあれば、四隅のみにする。
        if( mPnl.mCbSqr.value ){
            mAi.addGuide(1, 0);
            mAi.addGuide(1, mAi.width);
            mAi.addGuide(0, 0);
            mAi.addGuide(0, mAi.height);
        }else{
            for (var i = 0; i <= mAi.width; i = i + mNbr) {mAi.addGuide(1, i);}
            for (var i = 0; i <= mAi.height; i = i + mNbr) { mAi.addGuide(0, i);}
        }
        
        //作成が初回であれば、ロックとスナップのデフォルト状態を保存しておく。
        //作成チェックはデリートボタンを押せば初回に戻るので、デリート後の作成であれば、新たにその時点でのロック＆スナップ状態を保存する。
        var mNowOpt = app.activeViewer.views[0].options;
        if (mPnl.mIsFstClick) {
            mPnl.mDfltLock =mNowOpt.guidesLocked;
            mPnl.mDfltSnap =mNowOpt.guidesSnap;
            //初回作成チェックを初回ではなくする（２回目以降にデフォルト状態を上書きしないため）。
            mPnl.mIsFstClick = false;
        }

        //ロックとスナップチェックがtrueならばロックとスナップする（現在の状態がTFどちらかによらず処理する）。
        if (mPnl.mCbLock.value) { mNowOpt.guidesLocked = true;}
        else {mNowOpt.guidesLocked = false;}
        if (mPnl.mCbSnap.value) { mNowOpt.guidesSnap = true;}
        else {mNowOpt.guidesSnap = false;}

        app.endUndoGroup();
    }
    //----------------------------------------------------------------------------------------------------------------------
    mPnl.mBtDel.onClick = function () {
        app.beginUndoGroup("DelGuides");

        //ガイドを消去。
        app.executeCommand(2276);
        //作成クリックチェックを初回に戻す。
        mPnl.mIsFstClick = true;
        //ロックとｌスナップをデフォルト状態に戻す。
        var mOpt = app.activeViewer.views[0].options;
        mOpt.guidesLocked = mPnl.mDfltLock;
        mOpt.guidesSnap = mPnl.mDfltSnap;

        app.endUndoGroup();
    }
    //----------------------------------------------------------------------------------------------------------------------
}(this));










