﻿(function (aGbl) {
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    function mCreateUI(aObj) {
        var mPorW = (aObj instanceof Panel) ? aObj : new Window("palette", "Chesstics", undefined);
        mPorW.preferredSize = [200, 120];
        mPorW.margins = [10, 10, 10, 10];
        mPorW.spacing = 5;

        mPorW.mGpBts = mPorW.add("group { alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0]}");
        mPorW.mGpBts.spacing = 0;
        mPorW.mB1 = mPorW.mGpBts.add("button { preferredSize : [60,20] ,  text : 'Sort' }");
        mPorW.mGpBts.add("group { preferredSize : [30,20]}");
        mPorW.mStPix = mPorW.mGpBts.add("statictext { preferredSize : [-1,20]  , text : 'Pixel :'}");
        mPorW.mEtPix = mPorW.mGpBts.add("edittext { preferredSize : [60,20]  , text : '20' }");

        mPorW.mGpMoveTtl = mPorW.add("group { orientation : 'stack' ,  alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0]}");
        mPorW.mGpMoveTtl.add("panel { preferredSize : [60,0] }");
        mPorW.mStDir = mPorW.mGpMoveTtl.add("statictext { preferredSize : [-1,20]  , text : 'Move' , justify: 'center' }");

        mPorW.mBtDirGp = mPorW.add("group { orientation : 'column' ,  alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0]}");
        mPorW.mBtDirGp.spacing = 0;
        mPorW.mBtDirGp1 = mPorW.mBtDirGp.add("group { alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0]}");
        mPorW.mBtDirGp1.spacing = 0;
        mPorW.mBtDirGp1.add("group { preferredSize : [20,20]}");
        mPorW.mBtDirU = mPorW.mBtDirGp1.add("button { preferredSize : [20,20] , text : '^'  ,alignment :  [ 'center','top' ] }");
        mPorW.mBtDirGp2 = mPorW.mBtDirGp.add("group { alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0]}");
        mPorW.mBtDirGp2.spacing = 0; 
        mPorW.mBtDirL = mPorW.mBtDirGp2.add("button { preferredSize : [20,20] , text : '<' }");
        mPorW.mBtDirGp2.add("group { preferredSize : [20,20]}");
        mPorW.mBtDirR = mPorW.mBtDirGp2.add("button { preferredSize : [20,20] ,  text : '>' }");
        mPorW.mBtDirGp2.add("group { preferredSize : [30,20]}");
        mPorW.mCbSm = mPorW.mBtDirGp2.add("checkbox { preferredSize : [-1,20] , text : 'Without Sorting' }");
        mPorW.mCbSm.value = true;
        mPorW.mBtDirGp3 = mPorW.mBtDirGp.add("group { alignment :  [ 'left','top' ] , margins : [0, 0, 0, 0]}");
        mPorW.mBtDirGp3.spacing = 0;
        mPorW.mBtDirGp3.add("group { preferredSize : [20,20]}");    
        mPorW.mBtDirD = mPorW.mBtDirGp3.add("button { preferredSize : [20,20]  , text : 'v' }");
        
        return mPorW;

    }

    //mPnlという名でメインウインドウを作成。
    var mPnl = mCreateUI(aGbl);
    if (mPnl instanceof Window) {
        mPnl.center();
        mPnl.show();
    } else if (mPnl instanceof Panel) {
        //UIパネルの場合は以下をしないと自動レイアウトされない。
        mPnl.layout.layout(true);
    }

    //-------------------------------------------------------------------------
    //セッティングパート。

    //設定のキーを作る。
    mPnl.mPref1 = {};
    mPnl.mPref1.mSec = "Chesstics";
    mPnl.mPref1.mKey = "Pixel";
    mPnl.mPref2 = {};
    mPnl.mPref2.mSec = "Chesstics";
    mPnl.mPref2.mKey = "NotSortCheck";

    //もしも設定があれば読み込む。
    mPnl.Setting1 = mGetSetting(mPnl.mPref1);
    if (mPnl.Setting1 !== null) { mPnl.mEtPix.text = mPnl.Setting1; }
    mPnl.Setting2 = mGetSetting(mPnl.mPref2);
    if (mPnl.Setting2 !== null) { mPnl.mCbSm.value = (mPnl.Setting2 === "true"); }

    //テキスト、チェックが変化したら設定に保存する。
    //ボタンについてはonClickに入れ込む。
    mPnl.mEtPix.onChange = function () {
        mSaveSetting(mPnl.mPref1, mPnl.mEtPix.text);
    }
    mPnl.mCbSm.onClick = function () {
        mSaveSetting(mPnl.mPref2, mPnl.mCbSm.value.toString());
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //メイン処理パート。
    mPnl.mB1.onClick = function () { mSetPt(0); }
    mPnl.mBtDirL.onClick = function () { mSetPt(1); }
    mPnl.mBtDirR.onClick = function () { mSetPt(2); }
    mPnl.mBtDirU.onClick = function () { mSetPt(3); }
    mPnl.mBtDirD.onClick = function () { mSetPt(4); }
    //-----------------------------------------------------------------------------
    //引数のディレクションによって位置を整理する関数。
    function mSetPt(aDir) {
        var mAi = app.project.activeItem;
        var mSls = mAi.selectedLayers;
        var mCtlLyr = mAi.selectedLayers[0];
        var mSlsForDel = mAi.selectedLayers;
        var mTime = mAi.time;

        var mNum = parseFloat(mPnl.mEtPix.text);

        var mNotSortChk = mPnl.mCbSm.value;

        if (aDir === 0) { var mNumDir = [0, 0]; }
        else if (aDir === 1) { var mNumDir = [-mNum, 0]; }
        else if (aDir === 2) { var mNumDir = [mNum, 0]; }
        else if (aDir === 3) { var mNumDir = [0, -mNum]; }
        else if (aDir === 4) { var mNumDir = [0, mNum]; }
        //-----------------------------------------------------------------------------
        app.beginUndoGroup("Chesstics");

        //座標変換用ポイント制御エフェクトを選択レイヤーゼロへ加える。
        mSetPointCtlToSelLyrZero(mCtlLyr);

        try {
            //コンポ位置取得と移動はそれぞれ一括でやっているため、
            //子が選択されていれば、親から順に移動する限り、親の移動は子に影響がない。
            //なので親から移動させるようにする。

            //各選択レイヤーについて、親がない先祖が見つかるまで自分からさかのぼり、
            //先祖までのカウントを作って配列に入れる。
            var mSlCtrs = [];
            for (var i = 0; i < mSls.length; i++) {
                var mAtr = mSls[i];
                var mCtr = 0;
                while (mAtr.parent != null) {
                    mCtr++;
                    mAtr = mAtr.parent;
                }
                mSlCtrs.push(mCtr);
            }

            //要素２つ（レイヤー自身、先祖の数）のオブジェクトの配列を作る。
            var mSlObjs = [];
            for (var i = 0; i < mSls.length; i++) {
                var mObjTmp = {};
                mObjTmp.Lyr = mSls[i];
                mObjTmp.PrtCtr = mSlCtrs[i];
                mSlObjs.push(mObjTmp);
            }

            //カウンターの数が多いほど先祖が多い子となる。ので、親から処理するためには、
            //カウンターの数で昇順ソート（数が少ないほうが先＝親が先になる）すればよい。
            //また、親の数が同じものは親子ではないので、そこの処理順番はどうでもよい。
            mSlObjs = mSlObjs.sort(function (a, b) { return a.PrtCtr - b.PrtCtr; });
            //mSlsに値を差し戻す。
            for (var i = 0; i < mSlObjs.length; i++) {
                mSls[i] = mSlObjs[i].Lyr;
            }

            //-----------------------------------------------------------------------------
            //整列パート。
            var mSortChk = false;
            //もしもaDirが0であれば、（ノットソートチェックに関係なく）ソートチェックをtrueにする。
            if (aDir === 0) { mSortChk = true; }
            //aDirが0以外であれば、ノットソートチェックがfalseならばソートチェックをtrueにする。
            else { if (mNotSortChk === false) { mSortChk = true; } }

            //各選択レイヤーのコンポ座標を出し、ソート座標を割り出す。
            var mActPtAry = [];
            for (var i = 0; i < mSls.length; i++) {
                var mActPt = mGetCompPos(mSls[i], mCtlLyr);
                if (mSortChk === true) { mActPt = mRoundPt(mActPt, mNum); }

                //最終的なコンポ座標を次で使うので配列に入れておく。
                mActPtAry.push(mActPt);
            }

            //-----------------------------------------------------------------------------
            //移動パート。
            //整列パートで作ったコンポ座標を使う。
            for (var i = 0; i < mSls.length; i++) {
                var mPptyPt = mActPtAry[i];

                //方向チェックに基づいた方向へ値を移動させる（0の場合はゼロ移動）。
                mPptyPt = mPptyPt + mNumDir;

                //親があれば親の座標にする。
                if (mSls[i].parent != null) {
                    mPptyPt = mGetLyrCoordFromCompPos(mPptyPt, mSls[i].parent, mCtlLyr);
                }

                //キーフレームのありなし、次元分割の有無を考慮してsetValueする。
                mSetPosVal(mSls[i].position, mPptyPt, mTime);
            }
            //ポイント制御エフェクトを消す。
            mDelPointCtlToSelLyrZero(mCtlLyr, mSlsForDel);

        } catch (e) {
            //なんらかのエラーが出た場合はポイント制御エフェクトだけ消しておく。
            mDelPointCtlToSelLyrZero(mCtlLyr, mSlsForDel);
        }


        app.endUndoGroup();

    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //XYの値aPtをaPix基準でまとめる関数。
    function mRoundPt(aPt, aPix) {
        var mRstX = Math.round(aPt[0] / aPix) * aPix;
        var mRstY = Math.round(aPt[1] / aPix) * aPix;
        return [mRstX, mRstY];
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //キーフレームのありなし、次元分割の有無を考慮したPosition用setValue関数。
    function mSetPosVal(aPosPpty, aVal, aTime) {
        //次元分割されていない場合。
        if (aPosPpty.dimensionsSeparated === false) {
            //キーフレームがあれば追加する。
            if (aPosPpty.isTimeVarying == true) {
                aPosPpty.setValueAtTime(aTime, aVal);
                //なければキーフレ無しの値を入れる。
            } else {
                aPosPpty.setValue(aVal);
            }
            //次元分割されている場合。
        } else {
            var mXPpty = aPosPpty.getSeparationFollower(0);
            var mYPpty = aPosPpty.getSeparationFollower(1);

            //XYそれぞれについて、キーフレームがあれば追加する。
            if (mXPpty.isTimeVarying == true) {
                mXPpty.setValueAtTime(aTime, aVal[0]);
                //なければキーフレ無しの値を入れる。    
            } else {
                mXPpty.setValue(aVal[0]);
            }
            if (mYPpty.isTimeVarying == true) {
                mYPpty.setValueAtTime(aTime, aVal[1]);
            } else {
                mYPpty.setValue(aVal[1]);
            }
        }
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //コンポ座標やレイヤー座標を得るための仮ポイント制御エフェクトを任意のレイヤーに付ける関数。
    //以下のコンポ座標やレイヤー座標変換関数は、そのレイヤーに以下の名のポイント制御があることを前提に動く。
    function mSetPointCtlToSelLyrZero(aCtlLyr) {
        var mPtCtl = aCtlLyr.effect.addProperty("ADBE Point Control");
        mPtCtl.name = "PtCtlForGetCmpAndLyrPos";
    }

    //仮ポイント制御エフェクトを消す関数。
    //なんらかのプロパティが選択されていた場合、すべてのレイヤーの選択が外れるので
    //操作するmSlsとは別に選択レイヤー群をとっておき、それらを再選択する。
    //任意のポイント制御付きレイヤーのなんらかのプロパティが選択されていたら、そのプロパティは選択が外れることに注意する。
    function mDelPointCtlToSelLyrZero(aCtlLyr, aSlsForDel) {
        var mSelLyrs = aSlsForDel;
        aCtlLyr.effect("PtCtlForGetCmpAndLyrPos").remove();
        for (var i = 0; i < mSelLyrs.length; i++) {
            mSelLyrs[i].selected = true;
        }
    }

    //aLyrのコンポ座標を得る。
    function mGetCompPos(aLyr, aCtlLyr) {
        var mPtCtl = aCtlLyr.effect("PtCtlForGetCmpAndLyrPos");
        //エクスプレッションでコンポ座標を得る。
        mPtCtl("ADBE Point Control-0001").expression
            = "thisComp.layer(" + aLyr.index + ").toComp( thisComp.layer(" + aLyr.index + ").anchorPoint );"
        //変数に値を入れる。
        var mRstPt = mPtCtl("ADBE Point Control-0001").value;

        //値をリターンする。
        return mRstPt;
    }
    //コンポ座標aCoordをaLyr上でのレイヤー座標に変換する。
    function mGetLyrCoordFromCompPos(aCoord, aLyr, aCtlLyr) {
        var mPtCtl = aCtlLyr.effect("PtCtlForGetCmpAndLyrPos");
        //エクスプレッションでレイヤー座標を得る。
        var mCoordStr = "[" + aCoord.join(",") + "]";
        mPtCtl("ADBE Point Control-0001").expression
            = "thisComp.layer(" + aLyr.index + ").fromComp( " + mCoordStr + ");"
        //変数に値を入れる。
        var mRstPt = mPtCtl("ADBE Point Control-0001").value;

        //値をリターンする。
        return mRstPt;
    }
    //--------------------------------------------------------------------------------------------------------------------------------------------------
    //セッティング関連関数（オブジェクト引数版）。
    //mSecとmKeyという要素を持つObjを作って、それを入れて使う。
    //----------------------------------------------------------
    //設定があればそれを返す関数。
    function mGetSetting(aPrefObj) {
        var mPrefObj = aPrefObj;
        if (app.settings.haveSetting(mPrefObj.mSec, mPrefObj.mKey) === false) {
            return null;
        } else {
            return app.settings.getSetting(mPrefObj.mSec, mPrefObj.mKey);
        }
    }
    //----------------------------------------------------------
    //引数を設定に保存する関数。
    function mSaveSetting(aPrefObj, aValue) {
        var mPrefObj = aPrefObj;
        app.settings.saveSetting(mPrefObj.mSec, mPrefObj.mKey, aValue);
    }

    //--------------------------------------------------------------------------------------------------------------------------------------------------
}(this));


















